/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.SetMultimap;
import com.google.inject.Provider;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.FXImageViewHoverOverlay;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.tools.FXHoverTool;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;
import org.eclipse.gef4.zest.fx.policies.HideNodePolicy;
import org.eclipse.gef4.zest.fx.policies.HoverFirstAnchorageOnHoverPolicy;

public class ZestFxHidingHandlePart
extends AbstractFXSegmentHandlePart<FXImageViewHoverOverlay> {
    public static final String IMG_PRUNE = "/collapseall.png";
    public static final String IMG_PRUNE_DISABLED = "/collapseall_disabled.png";
    private boolean isVisible = false;

    public ZestFxHidingHandlePart(Provider<BezierCurve[]> segmentsInSceneProvider, int segmentIndex, double segmentParameter) {
        super(segmentsInSceneProvider, segmentIndex, segmentParameter);
        this.setAdapter(AdapterKey.get((Class)FXHoverTool.TOOL_POLICY_KEY), (Object)new HoverFirstAnchorageOnHoverPolicy());
    }

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        if (!(anchorage instanceof NodeContentPart)) {
            throw new IllegalArgumentException("Anchorage not applicable <" + anchorage + ">. Can only attach to NodeContentPart.");
        }
        super.attachToAnchorageVisual(anchorage, role);
    }

    protected FXImageViewHoverOverlay createVisual() {
        Image hoverImage = this.getHoverImage();
        Image image = this.getImage();
        FXImageViewHoverOverlay blendImageView = new FXImageViewHoverOverlay();
        blendImageView.baseImageProperty().set((Object)image);
        blendImageView.overlayImageProperty().set((Object)hoverImage);
        blendImageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                ZestFxHidingHandlePart.this.onClicked(event);
            }
        });
        return blendImageView;
    }

    public void doRefreshVisual(FXImageViewHoverOverlay visual) {
        boolean wasVisible = this.isVisible;
        super.doRefreshVisual((Node)visual);
        this.isVisible = ((FXImageViewHoverOverlay)this.getVisual()).isVisible();
        DoubleProperty opacityProperty = ((FXImageViewHoverOverlay)this.getVisual()).opacityProperty();
        if (!wasVisible && this.isVisible) {
            opacityProperty.set(0.0);
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)opacityProperty, (Object)1)})}).play();
        } else if (wasVisible && !this.isVisible) {
            opacityProperty.set(1.0);
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)opacityProperty, (Object)0)})}).play();
        }
    }

    protected Image getHoverImage() {
        return new Image(IMG_PRUNE);
    }

    protected Image getImage() {
        return new Image(IMG_PRUNE_DISABLED);
    }

    protected void onClicked(MouseEvent event) {
        SetMultimap anchorages = this.getAnchorages();
        if (anchorages == null || anchorages.isEmpty()) {
            return;
        }
        IVisualPart anchorage = (IVisualPart)anchorages.keySet().iterator().next();
        HideNodePolicy hideNodePolicy = (HideNodePolicy)((Object)anchorage.getAdapter(HideNodePolicy.class));
        hideNodePolicy.hide();
    }
}

