/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.policies;

import java.util.Set;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnTypePolicy;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;
import org.eclipse.gef4.zest.fx.policies.HideNodePolicy;

public class HideOnTypePolicy
extends AbstractFXOnTypePolicy {
    public NodeContentPart getHost() {
        return (NodeContentPart)super.getHost();
    }

    public void pressed(KeyEvent event) {
        KeyCode keyCode = event.getCode();
        if (KeyCode.P.equals((Object)keyCode)) {
            this.prune();
        } else if (KeyCode.E.equals((Object)keyCode)) {
            this.unprune();
        }
    }

    protected void prune() {
        ((HideNodePolicy)((Object)this.getHost().getAdapter(HideNodePolicy.class))).hide();
    }

    public void released(KeyEvent event) {
    }

    protected void unprune() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        HidingModel hidingModel = (HidingModel)viewer.getAdapter(HidingModel.class);
        Set<Node> hiddenNeighbors = hidingModel.getHiddenNeighbors(this.getHost().getContent());
        if (hiddenNeighbors != null && !hiddenNeighbors.isEmpty()) {
            for (Node node : hiddenNeighbors) {
                ((HideNodePolicy)((Object)((IContentPart)viewer.getContentPartMap().get(node)).getAdapter(HideNodePolicy.class))).show();
            }
        }
    }
}

