/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.linklf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;

public class DiagramGridSpec {
    private final EditPartViewer myViewer;
    private PrecisionRectangle myRelativeGridSpec;
    private PrecisionRectangle myAbsoluteGridSpec;
    private final GridSpecListener myGridListener;

    public DiagramGridSpec(EditPartViewer viewer) {
        this.myViewer = viewer;
        this.myGridListener = new GridSpecListener(){

            @Override
            public void gridSpecChanged() {
                DiagramGridSpec.this.myRelativeGridSpec = null;
                DiagramGridSpec.this.myAbsoluteGridSpec = null;
            }
        };
        this.myViewer.addPropertyChangeListener((PropertyChangeListener)this.myGridListener);
    }

    public void dispose() {
        this.myViewer.removePropertyChangeListener((PropertyChangeListener)this.myGridListener);
        this.myRelativeGridSpec = null;
        this.myAbsoluteGridSpec = null;
    }

    public PrecisionRectangle getAbsoluteGridSpec() {
        PrecisionRectangle result = this.getRelativeGridSpec();
        if (result == null) {
            return null;
        }
        if (this.myAbsoluteGridSpec == null) {
            this.myAbsoluteGridSpec = new PrecisionRectangle();
        }
        this.myAbsoluteGridSpec.setPreciseBounds(result.preciseX(), result.preciseY(), result.preciseWidth(), result.preciseHeight());
        GraphicalEditPart diagramEP = (GraphicalEditPart)this.myViewer.getContents();
        diagramEP.getContentPane().translateToAbsolute((Translatable)this.myAbsoluteGridSpec);
        return this.myAbsoluteGridSpec;
    }

    private PrecisionRectangle getRelativeGridSpec() {
        if (this.myRelativeGridSpec == null) {
            this.myRelativeGridSpec = DiagramGridSpec.getRelativeGridSpec(this.myViewer);
        }
        return this.myRelativeGridSpec;
    }

    public EditPartViewer getViewer() {
        return this.myViewer;
    }

    public static PrecisionRectangle getAbsoluteGridSpec(EditPartViewer viewer) {
        PrecisionRectangle spec = DiagramGridSpec.getRelativeGridSpec(viewer);
        if (spec != null) {
            GraphicalEditPart diagramEP = (GraphicalEditPart)viewer.getContents();
            diagramEP.getContentPane().translateToAbsolute((Translatable)spec);
        }
        return spec;
    }

    private static PrecisionRectangle getRelativeGridSpec(EditPartViewer viewer) {
        Point origin;
        Boolean enabled = (Boolean)viewer.getProperty("SnapToGrid.isEnabled");
        if (enabled == null || !enabled.booleanValue()) {
            return null;
        }
        double gridX = 0.0;
        double gridY = 0.0;
        Dimension spacing = (Dimension)viewer.getProperty("SnapToGrid.GridSpacing");
        if (spacing != null) {
            gridX = spacing.preciseWidth();
            gridY = spacing.preciseHeight();
        }
        if (gridX <= 0.0) {
            gridX = 12.0;
        }
        if (gridY <= 0.0) {
            gridY = 12.0;
        }
        PrecisionRectangle result = new PrecisionRectangle((origin = (Point)viewer.getProperty("SnapToGrid.GridOrigin")) == null ? 0.0 : origin.preciseX(), origin == null ? 0.0 : origin.preciseY(), gridX, gridY);
        return result;
    }

    public static abstract class GridSpecListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("SnapToGrid.GridOrigin".equals(propertyName) || "SnapToGrid.isEnabled".equals(propertyName) || "SnapToGrid.GridSpacing".equals(propertyName)) {
                this.gridSpecChanged();
            }
        }

        public abstract void gridSpecChanged();
    }
}

