/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.contextbuttons;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.datatypes.IRectangle;
import org.eclipse.graphiti.internal.contextbuttons.IContextButtonPadDeclaration;
import org.eclipse.graphiti.internal.contextbuttons.PositionedContextButton;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;

public abstract class AbstractContextButtonPadDeclaration
implements IContextButtonPadDeclaration {
    private Rectangle originalReferenceRectangle;
    private Rectangle padReferenceRectangle;
    private IContextButtonPadData contextButtonPadData;
    private List<IContextButtonEntry> collapseAndGenericButtons;
    private List<IContextButtonEntry> domainButtonsRight;
    private List<IContextButtonEntry> domainButtonsBottom;
    private Rectangle top;
    private Rectangle right;
    private Rectangle bottom;
    private IContextButtonPadDeclaration.PadStyle topStyle = IContextButtonPadDeclaration.PadStyle.STANDARD;
    private IContextButtonPadDeclaration.PadStyle rightStyle = IContextButtonPadDeclaration.PadStyle.STANDARD;
    private List<PositionedContextButton> positionedButtons;
    private List<Rectangle> containmentRectangles;
    private List<Rectangle> overlappingContainmentRectangles;

    public AbstractContextButtonPadDeclaration(IContextButtonPadData contextButtonPadData) {
        this.contextButtonPadData = contextButtonPadData;
        IRectangle l = contextButtonPadData.getPadLocation();
        this.originalReferenceRectangle = new Rectangle(l.getX(), l.getY(), l.getWidth(), l.getHeight());
        this.padReferenceRectangle = new Rectangle(this.originalReferenceRectangle);
        this.padReferenceRectangle.grow(1, 1);
        this.initializeDomainButtonLists();
        this.initializeRectangles();
        this.initializeButtonPositions();
        this.initializeContainmentRectangles();
    }

    protected abstract int getButtonSize();

    protected abstract int getButtonPadding();

    protected abstract int getCollapseButtonPadding();

    protected abstract int getPadPaddingOutside();

    protected abstract int getPadPaddingInside();

    protected abstract int getPadHorizontalOverlap();

    protected abstract int getPadVerticalOverlap();

    protected abstract int getPadAppendageLength();

    public abstract PositionedContextButton createButton(IContextButtonEntry var1, Rectangle var2);

    @Override
    public Rectangle getTopPad() {
        return this.top;
    }

    @Override
    public Rectangle getRightPad() {
        return this.right;
    }

    @Override
    public Rectangle getBottomPad() {
        return this.bottom;
    }

    @Override
    public IContextButtonPadDeclaration.PadStyle getTopPadStyle() {
        return this.topStyle;
    }

    @Override
    public IContextButtonPadDeclaration.PadStyle getRightPadStyle() {
        return this.rightStyle;
    }

    protected final Rectangle getOriginalReferenceRectangle() {
        return this.originalReferenceRectangle;
    }

    protected final Rectangle getPadReferenceRectangle() {
        return this.padReferenceRectangle;
    }

    protected final List<IContextButtonEntry> getGenericButtons() {
        return this.contextButtonPadData.getGenericContextButtons();
    }

    protected final IContextButtonEntry getCollapseButton() {
        return this.contextButtonPadData.getCollapseContextButton();
    }

    protected final List<IContextButtonEntry> getCollapseAndGenericButtons() {
        if (this.collapseAndGenericButtons == null) {
            this.collapseAndGenericButtons = new ArrayList<IContextButtonEntry>(this.getGenericButtons().size() + 1);
            if (this.getCollapseButton() != null) {
                this.collapseAndGenericButtons.add(this.getCollapseButton());
            }
            this.collapseAndGenericButtons.addAll(this.getGenericButtons());
        }
        return this.collapseAndGenericButtons;
    }

    protected final List<IContextButtonEntry> getDomainButtons() {
        return this.contextButtonPadData.getDomainSpecificContextButtons();
    }

    protected final List<IContextButtonEntry> getDomainButtonsRight() {
        return this.domainButtonsRight;
    }

    protected final List<IContextButtonEntry> getDomainButtonsBottom() {
        return this.domainButtonsBottom;
    }

    @Override
    public final List<PositionedContextButton> getPositionedContextButtons() {
        return this.positionedButtons;
    }

    @Override
    public final List<Rectangle> getContainmentRectangles() {
        return this.containmentRectangles;
    }

    @Override
    public final List<Rectangle> getOverlappingContainmentRectangles() {
        return this.overlappingContainmentRectangles;
    }

    protected void initializeDomainButtonLists() {
        int maxNumberOfButtons;
        int referenceHeight = this.getPadReferenceRectangle().height + 2 * this.getPadVerticalOverlap();
        if ((referenceHeight -= 2 * this.getPadPaddingOutside() + this.getButtonSize()) < 0) {
            maxNumberOfButtons = 0;
        } else {
            double additionalButtons = (double)referenceHeight / (double)(this.getButtonSize() + this.getButtonPadding());
            maxNumberOfButtons = 1 + (int)Math.ceil(additionalButtons);
        }
        this.domainButtonsRight = new ArrayList<IContextButtonEntry>();
        int i = 0;
        while (i < maxNumberOfButtons && i < this.getDomainButtons().size()) {
            this.domainButtonsRight.add(this.getDomainButtons().get(i));
            ++i;
        }
        int rightSize = this.getDomainButtonsRight().size();
        this.domainButtonsBottom = new ArrayList<IContextButtonEntry>();
        int i2 = rightSize;
        while (i2 < this.getDomainButtons().size()) {
            this.domainButtonsBottom.add(this.getDomainButtons().get(i2));
            ++i2;
        }
    }

    protected void initializeRectangles() {
        Rectangle innerRectangle = new Rectangle(this.getPadReferenceRectangle());
        innerRectangle.height = this.getPadDynamicSize(this.getDomainButtonsRight().size());
        innerRectangle.height -= 2 * this.getPadVerticalOverlap();
        if (this.getDomainButtonsBottom().size() > 0 && innerRectangle.height > this.getPadReferenceRectangle().height) {
            innerRectangle.y -= (innerRectangle.height - this.getPadReferenceRectangle().height + 1) / 2;
        }
        Point innerTop = new Point(innerRectangle.x + innerRectangle.width, innerRectangle.y);
        Point innerBottom = new Point(innerTop.x, innerTop.y + innerRectangle.height);
        if (this.getCollapseAndGenericButtons().size() != 0) {
            this.top = new Rectangle();
            this.top.width = this.getPadDynamicSize(this.getCollapseAndGenericButtons().size());
            if (this.getCollapseButton() != null && this.getGenericButtons().size() > 0) {
                this.top.width += this.getCollapseButtonPadding() - this.getButtonPadding();
            }
            this.top.height = this.getPadConstantSize();
            this.top.x = innerTop.x - this.top.width + this.getPadHorizontalOverlap();
            this.top.y = innerTop.y - this.top.height;
        } else if (this.getPadAppendageLength() > 0) {
            this.topStyle = IContextButtonPadDeclaration.PadStyle.APPENDAGE;
            this.top = new Rectangle();
            this.top.width = this.getPadAppendageLength() + this.getPadHorizontalOverlap();
            this.top.height = this.getPadVerticalOverlap();
            this.top.x = innerTop.x - this.top.width + this.getPadHorizontalOverlap();
            this.top.y = innerTop.y - this.top.height;
        }
        if (this.getDomainButtonsRight().size() != 0 || this.getDomainButtonsBottom().size() != 0) {
            this.right = new Rectangle();
            this.right.width = this.getPadConstantSize();
            this.right.height = this.getPadDynamicSize(this.getDomainButtonsRight().size());
            this.right.x = innerTop.x;
            this.right.y = innerTop.y - this.getPadVerticalOverlap();
        } else if (this.getPadAppendageLength() > 0) {
            this.rightStyle = IContextButtonPadDeclaration.PadStyle.APPENDAGE;
            this.right = new Rectangle();
            this.right.width = this.getPadHorizontalOverlap();
            this.right.height = this.getPadAppendageLength() + this.getPadVerticalOverlap();
            this.right.x = innerTop.x;
            this.right.y = innerTop.y - this.getPadVerticalOverlap();
        }
        if (this.getDomainButtonsBottom().size() != 0) {
            this.bottom = new Rectangle();
            this.bottom.width = this.getPadDynamicSize(this.getDomainButtonsBottom().size());
            this.bottom.height = this.getPadConstantSize();
            this.bottom.x = innerBottom.x - this.bottom.width + this.getPadHorizontalOverlap();
            this.bottom.y = innerBottom.y;
        }
    }

    protected void initializeButtonPositions() {
        Rectangle position;
        int y;
        int x;
        int iBackwards;
        this.positionedButtons = new ArrayList<PositionedContextButton>();
        int i = 0;
        while (i < this.getCollapseAndGenericButtons().size()) {
            iBackwards = this.getCollapseAndGenericButtons().size() - 1 - i;
            x = this.top.x + this.getPadPaddingOutside() + iBackwards * (this.getButtonSize() + this.getButtonPadding());
            if (i == 0 && this.getCollapseButton() != null && this.getGenericButtons().size() > 0) {
                x += this.getCollapseButtonPadding() - this.getButtonPadding();
            }
            y = this.top.y + this.getPadPaddingInside();
            position = new Rectangle(x, y, this.getButtonSize(), this.getButtonSize());
            this.positionedButtons.add(this.createButton(this.getCollapseAndGenericButtons().get(i), position));
            ++i;
        }
        i = 0;
        while (i < this.getDomainButtonsRight().size()) {
            int x2 = this.right.x + this.getPadPaddingInside();
            int y2 = this.right.y + this.getPadPaddingOutside() + i * (this.getButtonSize() + this.getButtonPadding());
            Rectangle position2 = new Rectangle(x2, y2, this.getButtonSize(), this.getButtonSize());
            this.positionedButtons.add(this.createButton(this.getDomainButtonsRight().get(i), position2));
            ++i;
        }
        i = 0;
        while (i < this.getDomainButtonsBottom().size()) {
            iBackwards = this.getDomainButtonsBottom().size() - 1 - i;
            x = this.bottom.x + this.getPadPaddingOutside() + iBackwards * (this.getButtonSize() + this.getButtonPadding());
            y = this.bottom.y + this.getPadPaddingInside();
            position = new Rectangle(x, y, this.getButtonSize(), this.getButtonSize());
            this.positionedButtons.add(this.createButton(this.getDomainButtonsBottom().get(i), position));
            ++i;
        }
    }

    protected void initializeContainmentRectangles() {
        this.containmentRectangles = new ArrayList<Rectangle>();
        this.overlappingContainmentRectangles = new ArrayList<Rectangle>();
        if (this.getTopPad() != null) {
            this.containmentRectangles.add(this.getTopPad());
        }
        if (this.getRightPad() != null) {
            this.containmentRectangles.add(this.getRightPad());
        }
        if (this.getBottomPad() != null) {
            this.containmentRectangles.add(this.getBottomPad());
        }
        for (PositionedContextButton button : this.getPositionedContextButtons()) {
            boolean buttonInside = false;
            for (Rectangle rectangle : this.containmentRectangles) {
                if (!rectangle.contains(button.getPosition())) continue;
                buttonInside = true;
                break;
            }
            if (buttonInside) continue;
            this.containmentRectangles.add(button.getPosition());
        }
        Rectangle r = this.getOriginalReferenceRectangle();
        Point referencePoint = new Point(r.x + r.width / 2, r.y + r.height / 2);
        for (Rectangle rectangle : this.containmentRectangles) {
            Rectangle unionRectangle = rectangle.union(new Rectangle(referencePoint));
            this.overlappingContainmentRectangles.add(unionRectangle);
        }
        this.overlappingContainmentRectangles.add(this.getOriginalReferenceRectangle());
    }

    private int getPadConstantSize() {
        return this.getPadPaddingInside() + this.getButtonSize() + this.getPadPaddingInside();
    }

    private int getPadDynamicSize(int numberOfButtons) {
        return 2 * this.getPadPaddingOutside() + (numberOfButtons > 0 ? numberOfButtons * this.getButtonSize() : this.getPadReferenceRectangle().height) + (numberOfButtons > 1 ? (numberOfButtons - 1) * this.getButtonPadding() : 0);
    }
}

