/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.jetty.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IUploadAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.UploadDialogField;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportCertificateDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private static final String[] POSSIBLE_PKCS12_EXTENSIONS = new String[]{".p12", ".pkcs12"};
    private final StringDialogField idField = new StringDialogField();
    private final StringDialogField keyStorePasswordField = new StringDialogField();
    private final StringDialogField keyPasswordField = new StringDialogField();
    private final SelectionButtonDialogFieldGroup keystoreTypeField = new SelectionButtonDialogFieldGroup(16, new String[]{"JKS", "PKCS12"}, 2);
    private final UploadDialogField keystoreUploadField = new UploadDialogField();
    private Throwable importError;
    private String keystoreFileName;
    private byte[] keystoreBytes;
    private char[] generatedKeystorePassword;
    private char[] generatedKeyPassword;
    private final IJettyManager jettyManager;

    public ImportCertificateDialog(Shell parent, IJettyManager jettyManager) {
        super(parent);
        this.jettyManager = jettyManager;
        this.setTitle("New Certificate");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        gd.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.keystoreTypeField.setLabelText("Keystore Type");
        this.keyStorePasswordField.setLabelText("Keystore Password");
        this.keyPasswordField.setLabelText("Key Password");
        this.keystoreUploadField.setLabelText("Keystore");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ImportCertificateDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.keystoreTypeField.setDialogFieldListener(validateListener);
        this.keyStorePasswordField.setDialogFieldListener(validateListener);
        this.keyPasswordField.setDialogFieldListener(validateListener);
        this.keystoreUploadField.setDialogFieldListener(validateListener);
        Infobox infobox = new Infobox(composite);
        infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        infobox.addHeading("Import a keystore!");
        infobox.addParagraph("Please fill in id, keytore type and passwords before uploading the keystore!\nAfter the upload the key store is validated. If the validation was sucessful,\nyou can import the key store into gyrex by pressing OK.");
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, new Separator(), this.keyStorePasswordField, this.keyPasswordField, new Separator(), this.keystoreTypeField, this.keystoreUploadField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.keystoreUploadField.getFileTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)infobox, (int)masterLayout.numColumns);
        return composite;
    }

    void importKeystore(InputStream in) throws Exception {
        KeyStore tempKs;
        if (this.keystoreTypeField.isSelected(0)) {
            tempKs = KeyStore.getInstance("JKS");
        } else if (this.keystoreTypeField.isSelected(1)) {
            tempKs = KeyStore.getInstance("PKCS12");
        } else {
            throw new IllegalArgumentException("Please select a keystore type before uploading a keystore and retry.");
        }
        String keystorePassword = this.keyStorePasswordField.getText();
        String keyPassword = this.keyPasswordField.getText();
        tempKs.load(new BufferedInputStream(in), keystorePassword != null ? keystorePassword.toCharArray() : null);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        this.generatedKeystorePassword = UUID.randomUUID().toString().toCharArray();
        this.generatedKeyPassword = UUID.randomUUID().toString().toCharArray();
        Enumeration<String> aliases = tempKs.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!tempKs.isKeyEntry(alias)) continue;
            Key key = tempKs.getKey(alias, keyPassword != null ? keyPassword.toCharArray() : (char[])(keystorePassword != null ? keystorePassword.toCharArray() : null));
            Certificate[] chain = tempKs.getCertificateChain(alias);
            if (chain == null) {
                Certificate certificate = tempKs.getCertificate(alias);
                if (certificate == null) continue;
                chain = new Certificate[]{certificate};
            }
            ks.setKeyEntry("jetty", key, this.generatedKeyPassword, chain);
            break;
        }
        if (!ks.aliases().hasMoreElements()) {
            throw new IllegalArgumentException("The uploaded keystore does not have a valid key + certificate chain entry. Please use a different keystore and retry.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ks.store(out, this.generatedKeystorePassword);
        this.keystoreBytes = out.toByteArray();
    }

    protected void okPressed() {
        final Display display = this.getShell().getDisplay();
        String fileName = this.keystoreUploadField.getFileName();
        if (StringUtils.isNotBlank((String)fileName) && (this.keystoreBytes == null || this.keystoreFileName == null || !StringUtils.equals((String)this.keystoreFileName, (String)fileName))) {
            final ServerPushSession serverPushSession = new ServerPushSession();
            this.updateButtonsEnableState((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.http.jetty", "Upload in progress!"));
            serverPushSession.start();
            this.keystoreUploadField.startUpload(new IUploadAdapter(){

                public void receive(InputStream stream, String fileName, String contentType, long contentLength) {
                    block5: {
                        InputStream in = null;
                        try {
                            try {
                                in = stream instanceof FileInputStream ? new BufferedInputStream(stream) : stream;
                                ImportCertificateDialog.this.importKeystore(in);
                                ImportCertificateDialog.this.keystoreFileName = fileName;
                                ImportCertificateDialog.this.importError = null;
                            }
                            catch (Exception e) {
                                ImportCertificateDialog.this.importError = e;
                                ImportCertificateDialog.this.keystoreBytes = null;
                                ImportCertificateDialog.this.keystoreFileName = null;
                                ImportCertificateDialog.this.generatedKeyPassword = null;
                                ImportCertificateDialog.this.generatedKeystorePassword = null;
                                IOUtils.closeQuietly((InputStream)in);
                                break block5;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ImportCertificateDialog.this.okPressedAndFileReceived();
                        }
                    });
                    serverPushSession.stop();
                }
            });
        } else {
            this.okPressedAndFileReceived();
        }
    }

    void okPressedAndFileReceived() {
        if (this.importError != null) {
            this.setError("The uploaded keystore could not be imported.\n" + this.importError.getMessage());
            return;
        }
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            this.jettyManager.addCertificate(this.idField.getText(), this.keystoreBytes, this.generatedKeystorePassword, this.generatedKeyPassword);
        }
        catch (Exception e) {
            this.setError(String.format("Error adding certificate: %s", e.getMessage()));
            return;
        }
        super.okPressed();
    }

    private void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.http.jetty", message));
        this.getShell().pack(true);
    }

    private void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.http.jetty", message));
    }

    private void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.http.jetty", message));
    }

    void validate() {
        String id = this.idField.getText();
        if (StringUtils.isNotBlank((String)id) && !IdHelper.isValidId((String)id)) {
            this.setError("The entered id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter a certificate id.");
            return;
        }
        if (!this.keystoreTypeField.isSelected(0) && !this.keystoreTypeField.isSelected(1)) {
            this.setInfo("Please select a keystore type.");
            return;
        }
        if (StringUtils.isBlank((String)this.keystoreUploadField.getFileName())) {
            this.setInfo("Please select a keystore to upload.");
            return;
        }
        if (StringUtils.endsWithAny((String)this.keystoreUploadField.getFileName().toLowerCase(), (String[])POSSIBLE_PKCS12_EXTENSIONS) && !this.keystoreTypeField.isSelected(1)) {
            this.setWarning("The selected file might be a PKCS12 keystore. Please verify the correct keystore type is selected!");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

