/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.AdminPageWithTree;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.internal.widgets.Statusbox;
import org.eclipse.gyrex.admin.ui.internal.wizards.NonBlockingWizardDialog;
import org.eclipse.gyrex.admin.ui.jobs.internal.BackgroundTasksPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiActivator;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsUiImages;
import org.eclipse.gyrex.admin.ui.jobs.internal.ScheduleEntriesContentProvider;
import org.eclipse.gyrex.admin.ui.jobs.internal.ScheduleEntryWizard;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.internal.schedules.SchedulingUtil;
import org.eclipse.gyrex.jobs.internal.util.ContextHashUtil;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.rap.helper.SwtUtil;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.prefs.BackingStoreException;

public class ScheduleEntriesPage
extends AdminPageWithTree {
    public static final String ID = "schedule-entries";
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_CRON = 2;
    private static final int COLUMN_PRECEDINGS = 3;
    private static final int COLUMN_LAST_RESULT = 4;
    private static final int COLUMN_STATUS = 5;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button enableButton;
    private Button disableButton;
    private Button runNowButton;
    private ScheduleImpl schedule;

    public ScheduleEntriesPage() {
        super(6);
        this.setTitle("Schedule Entries");
        this.setTitleToolTip("Edit a schedule and its entries for executing background tasks.");
    }

    void addButtonPressed() {
        this.editOrAddScheduleEntry(null);
    }

    protected void createButtons(Composite parent) {
        this.addButton = this.createButton(parent, "New...");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ScheduleEntriesPage.this.addButtonPressed();
            }
        });
        this.editButton = this.createButton(parent, "Edit...");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ScheduleEntriesPage.this.editButtonPressed();
            }
        });
        this.removeButton = this.createButton(parent, "Remove");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ScheduleEntriesPage.this.removeButtonPressed();
            }
        });
        this.createButtonSeparator(parent);
        this.enableButton = this.createButton(parent, "Enable");
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ScheduleEntriesPage.this.enableButtonPressed();
            }
        });
        this.disableButton = this.createButton(parent, "Disable");
        this.disableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ScheduleEntriesPage.this.disableButtonPressed();
            }
        });
        this.createButtonSeparator(parent);
        this.runNowButton = this.createButton(parent, "Run Now");
        this.runNowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ScheduleEntriesPage.this.runNowButtonPressed();
            }
        });
    }

    protected ITreeContentProvider createContentProvider() {
        return new ScheduleEntriesContentProvider();
    }

    protected Control createHeader(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        if (this.getSchedule().isEnabled()) {
            Statusbox statusbox = new Statusbox(composite, Statusbox.Status.Warning);
            statusbox.addLink("The schedule is enabled. You can not modify it. Please <a>disable it first</a>.", (SelectionListener)new SelectionAdapter(){
                private static final long serialVersionUID = 1L;

                public void widgetSelected(SelectionEvent e) {
                    final ScheduleImpl schedule = ScheduleEntriesPage.this.getSchedule();
                    NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)ScheduleEntriesPage.this.getTreeViewer().getTree()), (String)"Disable Schedule", (String)String.format("Do you want to disable schedule %s?", schedule.getId()), (DialogCallback)new DialogCallback(){
                        private static final long serialVersionUID = 1L;

                        public void dialogClosed(int returnCode) {
                            if (returnCode != 0) {
                                return;
                            }
                            try {
                                schedule.setEnabled(false);
                                ScheduleStore.flush((String)schedule.getStorageKey(), (ScheduleImpl)schedule);
                                schedule.load();
                            }
                            catch (BackingStoreException ex) {
                                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", "Unable to deactivate schedule.", (Throwable)ex), "Error");
                            }
                            BackgroundTasksPage.openSchedule(schedule, ScheduleEntriesPage.this.getApplicationService());
                        }
                    });
                }
            });
        }
        Infobox infobox = new Infobox(composite);
        infobox.addHeading("Schedule Entries");
        infobox.addParagraph("A schedule is composed of schedule entries. They define, what and how a background task should run. They can have a cron expression and/or a dependency on other entries in the same schedule.");
        infobox.addHeading("Navigate");
        infobox.addLink("Back to <a>schedules list</a>", (SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ScheduleEntriesPage.this.openSchedulesPage();
            }
        });
        return composite;
    }

    void disableButtonPressed() {
        ScheduleEntryImpl scheduleEntry = this.getSelectedScheduleEntry();
        if (scheduleEntry == null) {
            return;
        }
        try {
            scheduleEntry.setEnabled(false);
            scheduleEntry.getSchedule().save();
        }
        catch (BackingStoreException e) {
            Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", "Unable to activate schedule.", (Throwable)e), "Error");
        }
        this.getTreeViewer().refresh((Object)scheduleEntry);
        this.updateButtons();
    }

    void editButtonPressed() {
        this.editOrAddScheduleEntry(this.getSelectedScheduleEntry());
    }

    private void editOrAddScheduleEntry(ScheduleEntryImpl entryToEdit) {
        if (this.schedule.isEnabled()) {
            NonBlockingMessageDialogs.openInformation((Shell)SwtUtil.getShell((Widget)this.getTreeViewer().getTree()), (String)"Active Schedule", (String)"The schedule is enabled and cannot be modified. Please disable it first!", null);
            return;
        }
        NonBlockingWizardDialog dialog = new NonBlockingWizardDialog(SwtUtil.getShell((Widget)this.getTreeViewer().getTree()), (IWizard)new ScheduleEntryWizard(this.getSchedule(), entryToEdit));
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    ScheduleEntriesPage.this.refresh();
                }
            }
        });
    }

    void enableButtonPressed() {
        ScheduleEntryImpl scheduleEntry = this.getSelectedScheduleEntry();
        if (scheduleEntry == null) {
            return;
        }
        try {
            scheduleEntry.setEnabled(true);
            scheduleEntry.getSchedule().save();
        }
        catch (BackingStoreException e) {
            Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", "Unable to activate schedule.", (Throwable)e), "Error");
        }
        this.getTreeViewer().refresh((Object)scheduleEntry);
        this.updateButtons();
    }

    protected String getColumnLabel(int column) {
        switch (column) {
            case 0: {
                return "Entry";
            }
            case 1: {
                return "Task";
            }
            case 2: {
                return "Cron Exp.";
            }
            case 3: {
                return "Precedings";
            }
            case 4: {
                return "Last Run";
            }
            case 5: {
                return "Status";
            }
        }
        return "";
    }

    protected ColumnLayoutData getColumnLayoutData(int column) {
        switch (column) {
            case 0: {
                return new ColumnWeightData(25, 50);
            }
            case 1: 
            case 2: {
                return new ColumnWeightData(12, 50);
            }
            case 4: 
            case 5: {
                return new ColumnWeightData(6, 30);
            }
        }
        return new ColumnWeightData(10, 50);
    }

    protected Image getElementImage(Object element, int column) {
        if (element instanceof ScheduleEntryImpl) {
            if (column == 0) {
                if (((ScheduleEntryImpl)element).isEnabled()) {
                    return JobsUiImages.getImage("obj/active.gif");
                }
                return JobsUiImages.getImage("obj/inactive.gif");
            }
            if (column == 4) {
                return this.getLastResultImage((ScheduleEntryImpl)element);
            }
        }
        return null;
    }

    protected String getElementLabel(Object element, int column) {
        if (element instanceof ScheduleEntryImpl) {
            ScheduleEntryImpl entry = (ScheduleEntryImpl)element;
            switch (column) {
                case 0: {
                    return entry.getId();
                }
                case 1: {
                    return this.getName(entry);
                }
                case 2: {
                    return entry.getCronExpression();
                }
                case 3: {
                    return StringUtils.join((Collection)entry.getPrecedingEntries(), (String)", ");
                }
                case 4: {
                    if (this.getLastResultImage(entry) == null) {
                        return this.getLastResult(entry);
                    }
                    return null;
                }
                case 5: {
                    return this.getJobStatus(entry);
                }
            }
            return null;
        }
        return null;
    }

    String getJobStatus(ScheduleEntryImpl entry) {
        IJob job;
        IJobManager jobManager;
        IRuntimeContext ctx = ((IRuntimeContextRegistry)JobsUiActivator.getInstance().getService(IRuntimeContextRegistry.class)).get(this.schedule.getContextPath());
        if (ctx != null && (jobManager = (IJobManager)ctx.get(IJobManager.class)) != null && (job = jobManager.getJob(entry.getJobId())) != null) {
            JobState state = job.getState();
            switch (state) {
                case ABORTING: {
                    return "aborting";
                }
                case RUNNING: {
                    return "running";
                }
                case WAITING: {
                    return "waiting";
                }
                case NONE: {
                    if (!entry.isEnabled() || !entry.getSchedule().isEnabled()) break;
                    return "sleeping";
                }
            }
            return "";
        }
        return "n/a";
    }

    String getLastResult(ScheduleEntryImpl entry) {
        IStatus result;
        IJob job;
        IJobManager jobManager;
        IRuntimeContext ctx = ((IRuntimeContextRegistry)JobsUiActivator.getInstance().getService(IRuntimeContextRegistry.class)).get(this.schedule.getContextPath());
        if (ctx != null && (jobManager = (IJobManager)ctx.get(IJobManager.class)) != null && (job = jobManager.getJob(entry.getJobId())) != null && (result = job.getLastResult()) != null) {
            if (result.isOK()) {
                return "OK";
            }
            if (result.matches(8)) {
                return "aborted";
            }
            if (result.matches(4)) {
                return "failed";
            }
            if (result.matches(2)) {
                return "with warnings";
            }
            if (result.matches(1)) {
                return "OK";
            }
        }
        return "n/a";
    }

    private Image getLastResultImage(ScheduleEntryImpl entry) {
        IStatus result;
        IJob job;
        IJobManager jobManager;
        IRuntimeContext ctx = ((IRuntimeContextRegistry)JobsUiActivator.getInstance().getService(IRuntimeContextRegistry.class)).get(this.schedule.getContextPath());
        if (ctx != null && (jobManager = (IJobManager)ctx.get(IJobManager.class)) != null && (job = jobManager.getJob(entry.getJobId())) != null && (result = job.getLastResult()) != null) {
            if (result.isOK()) {
                return null;
            }
            if (result.matches(8)) {
                return null;
            }
            if (result.matches(4)) {
                return JobsUiImages.getImage("obj/error_result.gif");
            }
            if (result.matches(2)) {
                return JobsUiImages.getImage("obj/warn_result.gif");
            }
            if (result.matches(1)) {
                return null;
            }
        }
        return null;
    }

    private String getName(ScheduleEntryImpl entry) {
        String name = JobsActivator.getInstance().getJobProviderRegistry().getName(entry.getJobTypeId());
        if (StringUtils.isNotBlank((String)name)) {
            return name;
        }
        return "unknown (" + entry.getJobTypeId() + ")";
    }

    public ScheduleImpl getSchedule() {
        return this.schedule;
    }

    private ScheduleEntryImpl getSelectedScheduleEntry() {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof ScheduleEntryImpl) {
            return (ScheduleEntryImpl)selection.getFirstElement();
        }
        return null;
    }

    protected Object getViewerInput() {
        return this.schedule;
    }

    protected boolean isColumnSortable(int column) {
        return false;
    }

    protected void openSchedulesPage() {
        this.getApplicationService().openPage("background-tasks", new String[0]);
    }

    protected void openSelectedElement() {
        this.editOrAddScheduleEntry(this.getSelectedScheduleEntry());
    }

    protected void refresh() {
        try {
            this.getSchedule().load();
        }
        catch (BackingStoreException e) {
            Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", "Error loading schedule.", (Throwable)e), "Error");
        }
        this.getTreeViewer().refresh();
    }

    void removeButtonPressed() {
        final ScheduleEntryImpl scheduleEntry = this.getSelectedScheduleEntry();
        if (scheduleEntry == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.getTreeViewer().getTree()), (String)"Remove selected Schedule entry ", (String)String.format("Do you really want to delete schedule entry %s?", scheduleEntry.getId()), (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                try {
                    ScheduleImpl schedule = scheduleEntry.getSchedule();
                    schedule.removeEntry(scheduleEntry.getId());
                    schedule.save();
                }
                catch (AssertionError | Exception | LinkageError e) {
                    Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", "Unable to activate schedule.", (Throwable)e), "Error");
                }
                ScheduleEntriesPage.this.refresh();
                ScheduleEntriesPage.this.updateButtons();
            }
        });
    }

    void runNowButtonPressed() {
        final ScheduleEntryImpl scheduleEntry = this.getSelectedScheduleEntry();
        if (scheduleEntry == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.getTreeViewer().getTree()), (String)"Run Now", (String)String.format("Do you want to queue entry '%s' for execution now?", scheduleEntry.getId()), (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                try {
                    SchedulingUtil.queueJob((ScheduleEntryImpl)scheduleEntry);
                }
                catch (Exception ex) {
                    Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", "Unable to queue schedule entry.", (Throwable)ex), "Error");
                }
                ScheduleEntriesPage.this.getTreeViewer().refresh((Object)scheduleEntry);
                ScheduleEntriesPage.this.updateButtons();
            }
        });
    }

    public void setArguments(String[] args) {
        super.setArguments(args);
        if (args.length >= 3) {
            String contextPath = args[1];
            String scheduleId = args[2];
            String storageKey = new ContextHashUtil((IPath)new Path(contextPath)).toInternalId(scheduleId);
            try {
                ScheduleImpl schedule = ScheduleStore.load((String)storageKey, (String)ScheduleManagerImpl.getExternalId((String)storageKey), (boolean)false);
                if (schedule == null) {
                    throw new IllegalArgumentException(String.format("Schedule %s not found in context %s", scheduleId, contextPath));
                }
                this.setSchedule(schedule);
            }
            catch (BackingStoreException e) {
                throw new UnhandledException((Throwable)e);
            }
        }
    }

    public void setSchedule(ScheduleImpl schedule) {
        this.schedule = schedule;
        this.setTitle("Schedule " + schedule.getId());
    }

    protected void updateButtons() {
        ScheduleEntryImpl selectedScheduleEntry = this.getSelectedScheduleEntry();
        if (this.getSchedule().isEnabled()) {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.enableButton.setEnabled(false);
            this.disableButton.setEnabled(false);
            this.runNowButton.setEnabled(selectedScheduleEntry != null && selectedScheduleEntry.isEnabled());
            return;
        }
        if (selectedScheduleEntry == null) {
            this.addButton.setEnabled(true);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.enableButton.setEnabled(false);
            this.disableButton.setEnabled(false);
            this.runNowButton.setEnabled(false);
            return;
        }
        this.addButton.setEnabled(true);
        this.editButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        if (selectedScheduleEntry.isEnabled()) {
            this.enableButton.setEnabled(false);
            this.disableButton.setEnabled(true);
            this.runNowButton.setEnabled(true);
        } else {
            this.enableButton.setEnabled(true);
            this.disableButton.setEnabled(false);
            this.runNowButton.setEnabled(false);
        }
    }
}

