/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal.externalprocess;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.jobs.configuration.wizard.JobConfigurationWizardSession;
import org.eclipse.gyrex.admin.ui.jobs.internal.externalprocess.AddEditArgumentDialog;
import org.eclipse.gyrex.admin.ui.jobs.internal.externalprocess.AddEditEnvironmentVariableDialog;
import org.eclipse.gyrex.admin.ui.jobs.internal.externalprocess.Argument;
import org.eclipse.gyrex.admin.ui.jobs.internal.externalprocess.SelectEnvironmentVariableDialog;
import org.eclipse.gyrex.admin.ui.jobs.internal.externalprocess.Variable;
import org.eclipse.gyrex.jobs.internal.externalprocess.ExternalProcessJobParameter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ExternalProcessWizardPage
extends WizardPage {
    private static final long serialVersionUID = 1L;
    final StringDialogField commandField = new StringDialogField();
    final ListDialogField argumentsList;
    final StringDialogField workingDirectoryField;
    final SelectionButtonDialogField clearEnvironmentCheckBox;
    final ListDialogField environmentTable;
    final StringDialogField expectedReturnCodeField;
    private final JobConfigurationWizardSession session;

    public ExternalProcessWizardPage(JobConfigurationWizardSession session) {
        super(ExternalProcessWizardPage.class.getSimpleName());
        String[] stringArray = new String[6];
        stringArray[0] = "New...";
        stringArray[1] = "Edit...";
        stringArray[2] = "Remove";
        stringArray[4] = "Up";
        stringArray[5] = "Down";
        this.argumentsList = new ListDialogField(new IListAdapter(){

            public void customButtonPressed(ListDialogField field, int index) {
                switch (index) {
                    case 0: {
                        ExternalProcessWizardPage.this.openAddArgumentDialog();
                        break;
                    }
                    case 1: {
                        ExternalProcessWizardPage.this.openEditArgumentDialog();
                        break;
                    }
                }
            }

            public void doubleClicked(ListDialogField field) {
                ExternalProcessWizardPage.this.openEditArgumentDialog();
            }

            public void selectionChanged(ListDialogField field) {
                field.enableButton(1, field.getSelectedElements().size() == 1);
            }
        }, stringArray, (ILabelProvider)new LabelProvider());
        this.argumentsList.setRemoveButtonIndex(2);
        this.argumentsList.setUpButtonIndex(4);
        this.argumentsList.setDownButtonIndex(5);
        this.workingDirectoryField = new StringDialogField();
        this.clearEnvironmentCheckBox = new SelectionButtonDialogField(32);
        this.environmentTable = new ListDialogField(new IListAdapter(){

            public void customButtonPressed(ListDialogField field, int index) {
                switch (index) {
                    case 0: {
                        ExternalProcessWizardPage.this.openAddVariableDialog();
                        break;
                    }
                    case 1: {
                        ExternalProcessWizardPage.this.openSelectVariableDialog();
                        break;
                    }
                    case 2: {
                        ExternalProcessWizardPage.this.openEditVariableDialog();
                        break;
                    }
                }
            }

            public void doubleClicked(ListDialogField field) {
                ExternalProcessWizardPage.this.openEditVariableDialog();
            }

            public void selectionChanged(ListDialogField field) {
                field.enableButton(2, field.getSelectedElements().size() == 1);
            }
        }, new String[]{"New...", "Select...", "Edit...", "Remove"}, (ILabelProvider)new ColumnLabelProvider(){
            private static final long serialVersionUID = 1L;

            public void update(ViewerCell cell) {
                Variable element = (Variable)cell.getElement();
                switch (cell.getColumnIndex()) {
                    case 0: {
                        cell.setText(element.getName());
                        break;
                    }
                    case 1: {
                        if (StringUtils.equals((String)element.getValue(), (String)"!INHERIT!")) {
                            cell.setText(String.valueOf(System.getenv(element.getName())) + " (inherited)");
                            cell.setForeground(Display.getCurrent().getSystemColor(15));
                            break;
                        }
                        cell.setText(element.getValue());
                        cell.setForeground(null);
                        break;
                    }
                }
            }
        });
        this.environmentTable.setRemoveButtonIndex(3);
        this.environmentTable.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"Variable", "Value"}, true));
        this.expectedReturnCodeField = new StringDialogField();
        this.session = session;
        this.setTitle("External Process");
        this.setDescription("Provide details for the external process to launch.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(this.convertVerticalDLUsToPixels(200), this.convertHorizontalDLUsToPixels(400)).create());
        this.setControl((Control)composite);
        this.commandField.setLabelText("Program:");
        this.argumentsList.setLabelText("Arguments:");
        this.clearEnvironmentCheckBox.setLabelText("Clear native environment before launching.");
        this.environmentTable.setLabelText("Environment variable to set:");
        this.workingDirectoryField.setLabelText("Working Directory:");
        this.expectedReturnCodeField.setLabelText("Return Code:");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExternalProcessWizardPage.this.validate();
            }
        };
        this.commandField.setDialogFieldListener(validateListener);
        this.argumentsList.setDialogFieldListener(validateListener);
        this.clearEnvironmentCheckBox.setDialogFieldListener(validateListener);
        this.environmentTable.setDialogFieldListener(validateListener);
        this.workingDirectoryField.setDialogFieldListener(validateListener);
        this.expectedReturnCodeField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.commandField, this.argumentsList, new Separator(), this.clearEnvironmentCheckBox, this.environmentTable, new Separator(), this.workingDirectoryField, this.expectedReturnCodeField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.commandField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.argumentsList.getListControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.environmentTable.getListControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.workingDirectoryField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.expectedReturnCodeField.getTextControl(null));
        this.readParameterFromSession();
    }

    public String getCommand() {
        return StringUtils.trimToNull((String)this.commandField.getText());
    }

    private String getWorkingDir() {
        return this.workingDirectoryField.getText();
    }

    void openAddArgumentDialog() {
        final AddEditArgumentDialog dialog = new AddEditArgumentDialog(this.getShell());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0 && StringUtils.isNotBlank((String)dialog.getValue())) {
                    ExternalProcessWizardPage.this.argumentsList.addElement((Object)new Argument(dialog.getValue()));
                }
            }
        });
    }

    void openAddVariableDialog() {
        final AddEditEnvironmentVariableDialog dialog = new AddEditEnvironmentVariableDialog(this.getShell());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0 && StringUtils.isNotBlank((String)dialog.getName())) {
                    ExternalProcessWizardPage.this.environmentTable.addElement((Object)new Variable(dialog.getName(), dialog.getValue()));
                }
            }
        });
    }

    void openEditArgumentDialog() {
        final Argument a = (Argument)this.argumentsList.getSelectedElements().iterator().next();
        final AddEditArgumentDialog dialog = new AddEditArgumentDialog(this.getShell(), a.getValue());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0 && StringUtils.isNotBlank((String)dialog.getValue())) {
                    a.setValue(dialog.getValue());
                    ExternalProcessWizardPage.this.argumentsList.refresh();
                }
            }
        });
    }

    void openEditVariableDialog() {
        final Variable v = (Variable)this.environmentTable.getSelectedElements().iterator().next();
        final AddEditEnvironmentVariableDialog dialog = new AddEditEnvironmentVariableDialog(this.getShell(), v.getName(), v.getValue());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0 && StringUtils.isNotBlank((String)dialog.getName())) {
                    v.setName(dialog.getName());
                    v.setValue(dialog.getValue());
                    ExternalProcessWizardPage.this.environmentTable.refresh();
                }
            }
        });
    }

    void openSelectVariableDialog() {
        final SelectEnvironmentVariableDialog dialog = new SelectEnvironmentVariableDialog(this.getShell());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    for (String name : dialog.getVariables()) {
                        ExternalProcessWizardPage.this.environmentTable.addElement((Object)new Variable(name, "!INHERIT!"));
                    }
                    ExternalProcessWizardPage.this.environmentTable.refresh();
                }
            }
        });
    }

    private void readParameterFromSession() {
        ExternalProcessJobParameter p = ExternalProcessJobParameter.fromParameter(this.session.getParameter(), (boolean)false);
        if (StringUtils.isNotBlank((String)p.getCommand())) {
            this.commandField.setText(StringUtils.trimToEmpty((String)p.getCommand()));
        }
        if (p.getArguments() != null) {
            this.argumentsList.removeAllElements();
            for (String string : p.getArguments()) {
                this.argumentsList.addElement((Object)new Argument(string));
            }
            this.argumentsList.selectElements(null);
        }
        if (p.getExpectedReturnCode() != null) {
            this.expectedReturnCodeField.setText(String.valueOf(p.getExpectedReturnCode()));
        }
        if (p.getClearEnvironment() != null) {
            this.clearEnvironmentCheckBox.setSelection(p.getClearEnvironment().booleanValue());
        }
        if (p.getEnvironment() != null) {
            this.environmentTable.removeAllElements();
            for (Map.Entry entry : p.getEnvironment().entrySet()) {
                this.environmentTable.addElement((Object)new Variable((String)entry.getKey(), (String)entry.getValue()));
            }
            this.environmentTable.selectElements(null);
        }
        if (StringUtils.isNotBlank((String)p.getWorkingDir())) {
            this.workingDirectoryField.setText(StringUtils.trimToEmpty((String)p.getWorkingDir()));
        }
    }

    private void saveParameterToSession() {
        ExternalProcessJobParameter p = new ExternalProcessJobParameter();
        p.setCommand(StringUtils.trimToNull((String)this.getCommand()));
        p.setWorkingDir(StringUtils.trimToNull((String)this.getWorkingDir()));
        p.setClearEnvironment(Boolean.valueOf(this.clearEnvironmentCheckBox.isSelected()));
        if (StringUtils.isBlank((String)this.expectedReturnCodeField.getText())) {
            p.setExpectedReturnCode(null);
        } else {
            p.setExpectedReturnCode(Integer.valueOf(NumberUtils.toInt((String)this.expectedReturnCodeField.getText())));
        }
        List arguments = this.argumentsList.getElements();
        if (!arguments.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(arguments.size());
            for (Object object : arguments) {
                result.add(((Argument)object).getValue());
            }
            p.setArguments(result);
        } else {
            p.setArguments(null);
        }
        List variables = this.environmentTable.getElements();
        if (!variables.isEmpty()) {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (Object variable : variables) {
                Variable v = (Variable)variable;
                result.put(v.getName(), v.getValue());
            }
            p.setEnvironment(result);
        } else {
            p.setEnvironment(null);
        }
        this.session.setParameter(p.toParameter());
    }

    void validate() {
        String command = this.getCommand();
        if (StringUtils.isBlank((String)command)) {
            this.setMessage("Please enter a program to launch.");
            this.setPageComplete(false);
            return;
        }
        String returnCode = this.expectedReturnCodeField.getText();
        if (StringUtils.isNotBlank((String)returnCode)) {
            try {
                Integer.parseInt(returnCode);
            }
            catch (NumberFormatException e) {
                this.setMessage("The entered return code must be an integer number.", 3);
                this.setPageComplete(false);
                return;
            }
        }
        this.saveParameterToSession();
        this.setMessage(null);
        this.setPageComplete(true);
    }
}

