/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.pages.registry;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.gyrex.admin.ui.internal.AdminUiActivator;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.PageContribution;
import org.eclipse.gyrex.common.lifecycle.IShutdownParticipant;
import org.eclipse.gyrex.rap.application.Category;
import org.eclipse.gyrex.rap.application.Page;
import org.eclipse.gyrex.rap.application.PageHandle;
import org.eclipse.gyrex.rap.application.PageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPageRegistry
extends PageProvider
implements IExtensionChangeHandler {
    private static final String ELEMENT_PAGE = "page";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String EP_PAGES = "pages";
    private static final Logger LOG = LoggerFactory.getLogger(AdminPageRegistry.class);
    private static final AdminPageRegistry instance = new AdminPageRegistry();

    public static AdminPageRegistry getInstance() {
        return instance;
    }

    private AdminPageRegistry() {
        IExtension[] extensions;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            throw new IllegalStateException("Extension registry is not available!");
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.gyrex.admin.ui", EP_PAGES);
        if (extensionPoint == null) {
            throw new IllegalStateException("Admin pages extension point not found!");
        }
        ExtensionTracker tracker = new ExtensionTracker(registry);
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extensionPoint));
        AdminUiActivator.getInstance().addShutdownParticipant(new IShutdownParticipant((IExtensionTracker)tracker){
            private final /* synthetic */ IExtensionTracker val$tracker;
            {
                this.val$tracker = iExtensionTracker;
            }

            public void shutdown() throws Exception {
                this.val$tracker.close();
            }
        });
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension((IExtensionTracker)tracker, extension);
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (StringUtils.equals((String)ELEMENT_PAGE, (String)element.getName())) {
                PageContribution page = new PageContribution(element);
                if (!this.addPage(page)) {
                    LOG.warn("Ignoring duplicate page {} contributed by {}", (Object)page.getId(), (Object)extension.getContributor().getName());
                }
            } else if (StringUtils.equals((String)ELEMENT_CATEGORY, (String)element.getName())) {
                Category category = new Category(element.getAttribute("id"));
                category.setName(element.getAttribute("name"));
                category.setSortKey(element.getAttribute("sortKey"));
                if (!this.addCategory(category)) {
                    LOG.warn("Ignoring duplicate category {} contributed by {}", (Object)category.getId(), (Object)extension.getContributor().getName());
                }
            }
            ++n2;
        }
    }

    public Page createPage(PageHandle pageHandle) throws Exception {
        return ((PageContribution)pageHandle).createPage();
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (StringUtils.equals((String)ELEMENT_PAGE, (String)element.getName())) {
                id = element.getAttribute("id");
                this.removePage(id);
            } else if (StringUtils.equals((String)ELEMENT_CATEGORY, (String)element.getName())) {
                id = element.getAttribute("id");
                this.removeCategory(id);
            }
            ++n2;
        }
    }
}

