/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.widgets;

import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.FilteredTree;
import org.eclipse.gyrex.admin.ui.internal.widgets.PatternFilter;
import org.eclipse.gyrex.rap.application.Page;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AdminPageWithTree
extends Page {
    protected static final int NO_COLUMN = -1;
    private final int numberOfColumns;
    private Composite composite;
    private TreeViewer treeViewer;
    private ISelectionChangedListener updateButtonsListener;

    public AdminPageWithTree(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    public void activate() {
        super.activate();
        if (this.treeViewer == null) {
            return;
        }
        this.treeViewer.setInput(this.getViewerInput());
        this.updateButtonsListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AdminPageWithTree.this.updateButtons();
            }
        };
        this.treeViewer.addSelectionChangedListener(this.updateButtonsListener);
        this.internalRefresh();
    }

    protected Button createButton(Composite parent, String buttonLabel) {
        Button b = new Button(parent, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    protected abstract void createButtons(Composite var1);

    protected Label createButtonSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setVisible(false);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    protected abstract ITreeContentProvider createContentProvider();

    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin(1, false));
        Control header = this.createHeader(this.composite);
        if (header != null) {
            GridData gd = AdminUiUtil.createHorzFillData();
            gd.verticalIndent = 10;
            header.setLayoutData((Object)gd);
            if (this.composite.getChildren().length != 1 || header != this.composite.getChildren()[0]) {
                throw new IllegalStateException("Please wrap header into its own composite!");
            }
        }
        Composite treeContainerWithButtons = new Composite(this.composite, 0);
        GridData gd = AdminUiUtil.createFillData();
        gd.verticalIndent = 10;
        treeContainerWithButtons.setLayoutData((Object)gd);
        treeContainerWithButtons.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin(2, false));
        FilteredTree filteredTree = this.createTree(treeContainerWithButtons);
        filteredTree.setLayoutData(new GridData(4, 4, true, true));
        Composite buttons = new Composite(treeContainerWithButtons, 0);
        buttons.setLayoutData((Object)new GridData(1, 4, false, true));
        buttons.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.createButtons(buttons);
        return this.composite;
    }

    protected abstract Control createHeader(Composite var1);

    protected void createMetricSeparator(Composite area) {
        Label separator = new Label(area, 514);
        separator.setData("org.eclipse.rap.rwt.customVariant", (Object)"line-separator");
        GridData gd = new GridData(0x1000000, 4, false, false);
        gd.widthHint = 24;
        separator.setLayoutData((Object)gd);
    }

    protected Label createMetricText(Composite parent, String description) {
        Composite metricParent = new Composite(parent, 0);
        metricParent.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        Label metricLabel = new Label(metricParent, 131072);
        metricLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)"text-xxlarge");
        metricLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label descLabel = new Label(metricParent, 131072);
        descLabel.setText(description);
        descLabel.setData("org.eclipse.rap.rwt.customVariant", (Object)"text-large");
        descLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return metricLabel;
    }

    protected PatternFilter createPatternFilter() {
        if (this.getNumberOfColumns() == 0) {
            PatternFilter patternFilter = new PatternFilter(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isLeafMatch(Viewer viewer, Object element) {
                    return this.wordMatches(AdminPageWithTree.this.getElementTextForFiltering(element, -1));
                }
            };
            patternFilter.setIncludeLeadingWildcard(true);
            return patternFilter;
        }
        PatternFilter patternFilter = new PatternFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isLeafMatch(Viewer viewer, Object element) {
                int i = 0;
                while (i < AdminPageWithTree.this.getNumberOfColumns()) {
                    if (this.wordMatches(AdminPageWithTree.this.getElementTextForFiltering(element, i))) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        };
        patternFilter.setIncludeLeadingWildcard(true);
        return patternFilter;
    }

    protected FilteredTree createTree(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 67586, this.createPatternFilter(), true);
        this.treeViewer = filteredTree.getViewer();
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setData("org.eclipse.rap.rwt.markupEnabled", (Object)Boolean.TRUE);
        TableLayout layout = new TableLayout();
        this.treeViewer.getTree().setLayout((Layout)layout);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        SortableColumnsComparator comparator = new SortableColumnsComparator();
        this.treeViewer.setComparator((ViewerComparator)comparator);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AdminPageWithTree.this.openSelectedElement();
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){
            private static final long serialVersionUID = 1L;

            public Image getImage(Object element) {
                return AdminPageWithTree.this.getElementImage(element, -1);
            }

            public String getText(Object element) {
                return StringUtils.trimToEmpty((String)AdminPageWithTree.this.getElementLabel(element, -1));
            }
        });
        int columns = this.getNumberOfColumns();
        int i = 0;
        while (i < columns) {
            final int column = i;
            TreeViewerColumn viewerColumn = new TreeViewerColumn(this.treeViewer, 16384);
            viewerColumn.getColumn().setText(this.getColumnLabel(column));
            viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
                private static final long serialVersionUID = 1L;

                public Image getImage(Object element) {
                    return AdminPageWithTree.this.getElementImage(element, column);
                }

                public String getText(Object element) {
                    return StringUtils.trimToEmpty((String)AdminPageWithTree.this.getElementLabel(element, column));
                }
            });
            ColumnLayoutData layoutData = this.getColumnLayoutData(column);
            if (layoutData != null) {
                layout.addColumnData(layoutData);
            }
            if (this.isColumnSortable(column)) {
                viewerColumn.getColumn().addSelectionListener((SelectionListener)new ChangeSortColumnListener(comparator, column, viewerColumn));
                if (this.treeViewer.getTree().getSortColumn() == null) {
                    this.treeViewer.getTree().setSortColumn(viewerColumn.getColumn());
                    this.treeViewer.getTree().setSortDirection(comparator.isReverse() ? 128 : 1024);
                }
            }
            ++i;
        }
        return filteredTree;
    }

    public void deactivate() {
        super.deactivate();
        if (this.treeViewer != null) {
            if (this.updateButtonsListener != null) {
                this.treeViewer.removeSelectionChangedListener(this.updateButtonsListener);
                this.updateButtonsListener = null;
            }
            if (!this.treeViewer.getTree().isDisposed()) {
                this.treeViewer.setInput(null);
            }
        }
    }

    protected abstract String getColumnLabel(int var1);

    protected ColumnLayoutData getColumnLayoutData(int column) {
        switch (column) {
            case 0: 
            case 1: {
                return new ColumnWeightData(30, 50);
            }
        }
        return new ColumnWeightData(10, 50);
    }

    protected int getElementCategory(Object element, int column) {
        return 0;
    }

    protected Image getElementImage(Object element, int column) {
        return null;
    }

    protected abstract String getElementLabel(Object var1, int var2);

    protected String getElementTextForFiltering(Object element, int column) {
        return this.getElementLabel(element, column);
    }

    protected String getElementTextForSorting(Object element, int column) {
        return this.getElementLabel(element, column);
    }

    protected final int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected abstract Object getViewerInput();

    final void internalRefresh() {
        this.refresh();
        this.treeViewer.refresh();
        this.treeViewer.expandToLevel(2);
        this.updateButtons();
    }

    protected boolean isColumnSortable(int column) {
        return true;
    }

    protected void openSelectedElement() {
    }

    protected void refresh() {
    }

    protected abstract void updateButtons();

    private final class ChangeSortColumnListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;
        private final SortableColumnsComparator comparator;
        private final TreeViewerColumn column;
        private final int sortIndex;

        private ChangeSortColumnListener(SortableColumnsComparator comparator, int sortIndex, TreeViewerColumn column) {
            this.comparator = comparator;
            this.sortIndex = sortIndex;
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.comparator.getColumn() == this.sortIndex) {
                this.comparator.setReverse(!this.comparator.isReverse());
            } else {
                this.comparator.setColumn(this.sortIndex);
                AdminPageWithTree.this.treeViewer.getTree().setSortColumn(this.column.getColumn());
            }
            AdminPageWithTree.this.treeViewer.getTree().setSortDirection(this.comparator.isReverse() ? 128 : 1024);
            AdminPageWithTree.this.treeViewer.refresh();
        }
    }

    private final class SortableColumnsComparator
    extends ViewerComparator {
        private static final long serialVersionUID = 1L;
        private int column;
        private boolean reverse;

        public int compare(Viewer viewer, Object e1, Object e2) {
            int c2;
            int c1 = AdminPageWithTree.this.getElementCategory(e1, this.getColumn());
            if (c1 != (c2 = AdminPageWithTree.this.getElementCategory(e2, this.getColumn()))) {
                return c1 - c2;
            }
            String t1 = StringUtils.trimToEmpty((String)AdminPageWithTree.this.getElementLabel(e1, this.getColumn()));
            String t2 = StringUtils.trimToEmpty((String)AdminPageWithTree.this.getElementLabel(e2, this.getColumn()));
            if (this.isReverse()) {
                return this.getComparator().compare(t2, t1);
            }
            return this.getComparator().compare(t1, t2);
        }

        public int getColumn() {
            return this.column;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public void setColumn(int column) {
            this.column = column;
            this.reverse = false;
        }

        public void setReverse(boolean reverse) {
            this.reverse = reverse;
        }
    }
}

