/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.widgets;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.Policy;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.widgets.Shell;

public abstract class NonBlockingTrayDialog
extends TrayDialog {
    private static final long serialVersionUID = 1L;
    private final AtomicReference<DialogCallback> callbackRef = new AtomicReference();

    public NonBlockingTrayDialog(Shell parent) {
        super(parent);
    }

    public boolean close() {
        DialogCallback callback;
        boolean closed = super.close();
        if (closed && (callback = (DialogCallback)this.callbackRef.getAndSet(null)) != null) {
            callback.dialogClosed(this.getReturnCode());
        }
        return closed;
    }

    public final int open() {
        try {
            return super.open();
        }
        catch (AssertionError | Exception | LinkageError e) {
            Policy.getStatusHandler().show((IStatus)(e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, "org.eclipse.gyrex.admin.ui", "Unable to open dialog. Please check the server logs.", (Throwable)e)), "Error Opening Dialog");
            return 1;
        }
    }

    public void openNonBlocking(DialogCallback callback) {
        if (!this.callbackRef.compareAndSet(null, callback)) {
            throw new IllegalStateException("Concurrent operation not supported!");
        }
        this.setBlockOnOpen(false);
        this.open();
    }
}

