/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.rap.helper.SwtUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class StringButtonDialogField
extends StringDialogField {
    private Button fBrowseButton;
    private String fBrowseButtonLabel;
    private final IStringButtonAdapter fStringButtonAdapter;
    private boolean fButtonEnabled;

    protected static GridData gridDataForButton(Button button, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = SwtUtil.getButtonWidthHint((Button)button);
        return gd;
    }

    public StringButtonDialogField(IStringButtonAdapter adapter) {
        this.fStringButtonAdapter = adapter;
        this.fBrowseButtonLabel = "!Browse...!";
        this.fButtonEnabled = true;
    }

    public void changeControlPressed() {
        this.fStringButtonAdapter.changeControlPressed(this);
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)StringButtonDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)StringButtonDialogField.gridDataForText(nColumns - 2));
        Button button = this.getChangeControl(parent);
        button.setLayoutData((Object)StringButtonDialogField.gridDataForButton(button, 1));
        return new Control[]{label, text, button};
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && enable);
        }
        this.fButtonEnabled = enable;
    }

    public Button getChangeControl(Composite parent) {
        if (this.fBrowseButton == null) {
            this.assertCompositeNotNull(parent);
            this.fBrowseButton = new Button(parent, 8);
            this.fBrowseButton.setFont(parent.getFont());
            this.fBrowseButton.setText(this.fBrowseButtonLabel);
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
            this.fBrowseButton.addSelectionListener(new SelectionListener(){
                private static final long serialVersionUID = 1L;

                public void widgetDefaultSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    StringButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.fBrowseButton;
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    public void setButtonLabel(String label) {
        this.fBrowseButtonLabel = label;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseButton)) {
            this.fBrowseButton.setEnabled(this.isEnabled() && this.fButtonEnabled);
        }
    }
}

