/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal.jmx;

import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.UnhandledException;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyJmxConnector {
    private static final String DEFAULT_JMXRMI_HOST = "localhost";
    private static final int DEFAULT_JMXRMI_PORT = 1099;
    private static final Logger LOG = LoggerFactory.getLogger(JettyJmxConnector.class);
    private static ConnectorServer connectorServer;
    private static Status state;
    private static final SystemSetting<Boolean> skipJmxConnectorSetting;
    private static final SystemSetting<String> jmxConnectorHostSetting;
    private static final SystemSetting<Integer> jmxConnectorPortSetting;

    static {
        skipJmxConnectorSetting = SystemSetting.newBooleanSetting("gyrex.jmxrmi.skip", "Prevents start of the built-in JMX connector for easier access through firewalls.").create();
        jmxConnectorHostSetting = SystemSetting.newStringSetting("gyrex.jmxrmi.host", "Host for accepting JMX connections.").usingDefault(DEFAULT_JMXRMI_HOST).create();
        jmxConnectorPortSetting = SystemSetting.newIntegerSetting("gyrex.jmxrmi.port", "Port for accepting JMX connections.").usingDefault(Platform.getInstancePort(1099)).create();
    }

    static synchronized void doStart() throws Exception {
        if (state != Status.STARTING) {
            return;
        }
        String host = jmxConnectorHostSetting.get();
        int port = jmxConnectorPortSetting.get();
        LOG.info("Enabling JMX remote connections on port {} (host {}).", new Object[]{port, host});
        JMXServiceURL url = new JMXServiceURL("rmi", host, port, String.format("/jndi/rmi://%s:%d/jmxrmi", host, port));
        connectorServer = new ConnectorServer(url, null, "org.eclipse.gyrex.jmx:name=rmiconnectorserver");
        connectorServer.start();
        state = Status.STARTED;
    }

    public static synchronized void start() throws Exception {
        if (skipJmxConnectorSetting.isTrue()) {
            return;
        }
        if (state == Status.STARTING || state == Status.STARTED) {
            throw new IllegalStateException("already started");
        }
        state = Status.STARTING;
        Thread t = new Thread("JettyJMXConnectorStart"){

            @Override
            public void run() {
                try {
                    JettyJmxConnector.doStart();
                }
                catch (AssertionError | ClassNotFoundException | LinkageError e) {
                    LOG.warn("Jetty JMX is not available. Please configure JMX support manually. ({})", (Object)((Throwable)e).getMessage());
                }
                catch (Exception e) {
                    ServerApplication.shutdown((Throwable)new UnhandledException("An error occured while starting the embedded JMX server. Please verify the port/host configuration is correct and no other server is running. JMX can also be disabled by setting system property 'gyrex.jmxrmi.skip' to true.", (Throwable)e));
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static synchronized void stop() throws Exception {
        state = null;
        if (connectorServer == null) {
            return;
        }
        try {
            try {
                connectorServer.stop();
            }
            catch (Exception exception) {
                connectorServer = null;
            }
        }
        finally {
            connectorServer = null;
        }
    }

    private static enum Status {
        STARTING,
        STARTED;

    }
}

