/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.settings;

abstract class ValueConverter<T> {
    ValueConverter() {
    }

    protected static <S> S convertToValueType(String value, Class<S> valueType) {
        if (valueType.isInstance(value)) {
            return (S)value;
        }
        if (valueType.equals(Boolean.class)) {
            return (S)new Boolean(Boolean.parseBoolean(value));
        }
        try {
            if (valueType.equals(Integer.class)) {
                return (S)new Integer(Integer.parseInt(value));
            }
            if (valueType.equals(Long.class)) {
                return (S)new Long(Long.parseLong(value));
            }
            if (valueType.equals(Double.class)) {
                return (S)new Double(Double.parseDouble(value));
            }
            if (valueType.equals(Float.class)) {
                return (S)new Float(Float.parseFloat(value));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Unable to parse value '%s'." + valueType, value), e);
        }
        throw new IllegalArgumentException("Unsupported value type: " + valueType);
    }

    abstract T convertValue(String var1);
}

