/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.internal.CloudState;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.prefs.Preferences;

public class NodeEnvironmentImpl
implements INodeEnvironment {
    @Override
    public String getNodeId() {
        NodeInfo nodeInfo = CloudState.getNodeInfo();
        if (nodeInfo == null) {
            return new NodeInfo().getNodeId();
        }
        return nodeInfo.getNodeId();
    }

    private Map<String, Object> getNodeProperties() {
        HashMap<String, Object> nodeProperties = new HashMap<String, Object>(2);
        nodeProperties.put("id", this.getNodeId());
        NodeInfo nodeInfo = CloudState.getNodeInfo();
        if (nodeInfo != null) {
            Set<String> tags = nodeInfo.getTags();
            if (!tags.isEmpty()) {
                nodeProperties.put("tag", tags.toArray(new String[tags.size()]));
            }
            if (StringUtils.isNotBlank((String)nodeInfo.getLocation())) {
                nodeProperties.put("location", nodeInfo.getLocation());
            }
            if (StringUtils.isNotBlank((String)nodeInfo.getName())) {
                nodeProperties.put("name", nodeInfo.getName());
            }
        }
        return nodeProperties;
    }

    @Override
    public Set<String> getTags() {
        NodeInfo nodeInfo = CloudState.getNodeInfo();
        if (nodeInfo == null) {
            return Collections.emptySet();
        }
        return nodeInfo.getTags();
    }

    @Override
    public boolean inStandaloneMode() {
        Preferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.gyrex.cloud").node("zookeeper");
        return preferences.get("clientConnectString", null) == null;
    }

    @Override
    public boolean isApproved() {
        NodeInfo nodeInfo = CloudState.getNodeInfo();
        if (nodeInfo == null) {
            return false;
        }
        return nodeInfo.isApproved();
    }

    @Override
    public boolean matches(String filter) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)filter).matches(this.getNodeProperties());
    }
}

