/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.zk.console;

import org.apache.zookeeper.ZooKeeper;
import org.eclipse.gyrex.cloud.internal.zk.console.PathBasedCmd;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class SetCmd
extends PathBasedCmd {
    @Option(name="--charset-name", usage="name of the character set to use when writing the input string as byte array")
    String charsetName;
    @Argument(index=1, metaVar="DATA", usage="input string to set", required=true)
    String data;

    public SetCmd() {
        super("- sets the content of the node at the specified path as a string");
    }

    @Override
    protected void doExecute(ZooKeeper zk, String path) throws Exception {
        if (this.charsetName != null) {
            zk.setData(path, this.data.getBytes(this.charsetName), -1);
        } else {
            zk.setData(path, this.data.getBytes(), -1);
        }
        this.ci.println((Object)("Updated " + path));
    }
}

