/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.services.zookeeper;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.zk.GateDownException;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperBasedService {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperBasedService.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ZooKeeperGateListener connectionMonitor = new ZooKeeperGateListener(){

        @Override
        public void gateDown(ZooKeeperGate gate) {
            if (!ZooKeeperBasedService.this.isClosed()) {
                ZooKeeperBasedService.this.disconnect();
            }
        }

        @Override
        public void gateRecovering(ZooKeeperGate gate) {
            if (!ZooKeeperBasedService.this.isClosed()) {
                ZooKeeperBasedService.this.suspend();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void gateUp(ZooKeeperGate gate) {
            if (!ZooKeeperBasedService.this.isClosed()) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (!ZooKeeperBasedService.this.isClosed()) {
                        ZooKeeperBasedService.this.reconnect();
                    }
                }
            }
        }

        public String toString() {
            return String.format("ZooKeeperGateListener {%s}", ZooKeeperBasedService.this);
        }
    };
    private final long retryDelayInMs;
    private final int retryCount;
    private final ExecutorService executor;

    public ZooKeeperBasedService() {
        this(250L, 8);
    }

    public ZooKeeperBasedService(long retryDelayInMs, int retryCount) {
        if (retryDelayInMs < 50L) {
            throw new IllegalArgumentException("retry delay to low");
        }
        if (retryCount < 1) {
            throw new IllegalArgumentException("retry count to low");
        }
        this.retryDelayInMs = retryDelayInMs;
        this.retryCount = retryCount;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, String.format("%s Deferred Executor", ZooKeeperBasedService.this));
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        LOG.error("Unhandled error processing operation in ({}). {}", new Object[]{ZooKeeperBasedService.this, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                    }
                });
                return t;
            }
        });
    }

    protected final void activate() {
        if (this.isClosed()) {
            return;
        }
        ZooKeeperGate.addConnectionMonitor(this.connectionMonitor);
    }

    protected final void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                try {
                    this.executor.shutdown();
                }
                finally {
                    this.doClose();
                }
            }
            finally {
                ZooKeeperGate.removeConnectionMonitor(this.connectionMonitor);
            }
        }
    }

    protected void disconnect() {
        if (this.isClosed()) {
            return;
        }
        LOG.warn("Connection to the cloud has been lost. Closing active service {}.", (Object)this);
        this.close();
    }

    protected void doClose() {
    }

    protected <V> V execute(Callable<V> operation) throws Exception {
        KeeperException.ConnectionLossException exception = null;
        int i = 0;
        while (i < this.retryCount) {
            try {
                return operation.call();
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                if (CloudDebug.debug) {
                    LOG.debug("Connection to the server has been lost (retry attempt {}).", (Object)i);
                }
                this.sleep(i);
            }
            catch (KeeperException.SessionExpiredException e) {
                if (!this.isClosed()) {
                    LOG.warn("ZooKeeper session expired. Service {} may be invalid now.", (Object)this);
                }
                throw e;
            }
            catch (GateDownException e) {
                if (!this.isClosed()) {
                    LOG.warn("ZooKeeper gate is down. Service {} may be invalid now.", (Object)this);
                }
                throw e;
            }
            ++i;
        }
        throw exception;
    }

    protected abstract String getToStringDetails();

    protected final boolean isClosed() {
        return this.closed.get();
    }

    protected void reconnect() {
    }

    protected final void sleep(int attemptCount) {
        if (attemptCount > 0) {
            try {
                long sleepTime = (long)attemptCount * this.retryDelayInMs;
                if (CloudDebug.debug) {
                    LOG.debug("Will sleep for {}ms.", (Object)sleepTime);
                }
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                if (CloudDebug.debug) {
                    LOG.debug("Sleep interrupted.");
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    protected <V> Future<V> submit(final Callable<V> operation) {
        return this.executor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return ZooKeeperBasedService.this.execute(operation);
            }
        });
    }

    protected void suspend() {
        this.disconnect();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        if (this.isClosed()) {
            builder.append(" CLOSED");
        }
        builder.append(" [").append(this.getToStringDetails()).append("]");
        return builder.toString();
    }

    protected static abstract class ZooKeeperCallable<V>
    implements Callable<V> {
        protected ZooKeeperCallable() {
        }

        @Override
        public final V call() throws Exception {
            return this.call(ZooKeeperGate.get().getZooKeeper());
        }

        protected abstract V call(ZooKeeper var1) throws Exception;
    }
}

