/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.provider.ProviderRegistration;
import org.eclipse.gyrex.context.provider.RuntimeContextObjectProvider;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(TypeRegistration.class);
    private final String typeName;
    private final ConcurrentNavigableMap<ServiceReference, ProviderRegistration> providersByReference = new ConcurrentSkipListMap(Collections.reverseOrder());
    private final Set<TypeRegistrationReference> references = new HashSet<TypeRegistrationReference>(3);
    private final Lock referencesLock = new ReentrantLock();

    public TypeRegistration(String typeName) {
        this.typeName = typeName;
    }

    void add(Class<?> type, RuntimeContextObjectProvider provider, ServiceReference serviceReference) {
        if (!this.typeName.equals(type.getName())) {
            throw new IllegalArgumentException("manager class name should be " + this.typeName);
        }
        ProviderRegistration providerRegistration = this.providersByReference.putIfAbsent(serviceReference, new ProviderRegistration(type, provider, serviceReference));
        if (providerRegistration != null) {
            LOG.warn("A provider was added which was already tracked by us. This looks like a programming (concurrency?) error. (old:{}, new:{}, {})", new Object[]{providerRegistration, serviceReference, this});
        }
        if (ContextDebug.objectLifecycle) {
            LOG.debug("Adding provider {} to {}", (Object)provider, (Object)this);
        }
        this.flushFromContexts();
    }

    public void addReference(TypeRegistrationReference reference) {
        this.referencesLock.lock();
        try {
            this.references.add(reference);
        }
        finally {
            this.referencesLock.unlock();
        }
    }

    void flushFromContexts() {
        Object[] currentRefs;
        this.referencesLock.lock();
        try {
            currentRefs = this.references.toArray();
        }
        finally {
            this.referencesLock.unlock();
        }
        Object[] objectArray = currentRefs;
        int n = currentRefs.length;
        int n2 = 0;
        while (n2 < n) {
            Object reference = objectArray[n2];
            ((TypeRegistrationReference)reference).flushReference(this);
            ++n2;
        }
    }

    public ProviderRegistration[] getMatchingProviders(Filter filter) {
        if (filter == null) {
            return this.providersByReference.values().toArray(new ProviderRegistration[0]);
        }
        ArrayList<ProviderRegistration> providers = new ArrayList<ProviderRegistration>(3);
        for (ProviderRegistration providerRegistration : this.providersByReference.values()) {
            if (!providerRegistration.match(filter)) continue;
            providers.add(providerRegistration);
        }
        return providers.isEmpty() ? null : providers.toArray(new ProviderRegistration[providers.size()]);
    }

    public String getTypeName() {
        return this.typeName;
    }

    void remove(Class<?> type, RuntimeContextObjectProvider provider, ServiceReference reference) {
        if (!this.typeName.equals(type.getName())) {
            throw new IllegalArgumentException("type class name should be " + this.typeName);
        }
        ProviderRegistration providerRegistration = (ProviderRegistration)this.providersByReference.remove(reference);
        if (providerRegistration != null) {
            if (ContextDebug.objectLifecycle) {
                LOG.debug("Removing provider {} from {}", (Object)provider, (Object)this);
            }
            providerRegistration.flushFromContexts();
        } else {
            LOG.warn("A provider was removed which wasn't tracked by us. This looks like a programming (concurrency?) error. ({}, {}, {})", new Object[]{provider, reference, this});
        }
    }

    public void removeReference(TypeRegistrationReference reference) {
        this.referencesLock.lock();
        try {
            this.references.remove(reference);
        }
        finally {
            this.referencesLock.unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeRegistration [typeName=").append(this.typeName).append("]");
        return builder.toString();
    }

    void update(Class<?> type, RuntimeContextObjectProvider provider, ServiceReference reference) {
        if (!this.typeName.equals(type.getName())) {
            throw new IllegalArgumentException("type class name should be " + this.typeName);
        }
        ProviderRegistration providerRegistration = (ProviderRegistration)this.providersByReference.get(reference);
        if (providerRegistration != null) {
            providerRegistration.flushProperties();
        }
        this.flushFromContexts();
    }

    public static interface TypeRegistrationReference {
        public void flushReference(TypeRegistration var1);
    }
}

