/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.eventbus.websocket.internal;

import java.nio.ByteBuffer;
import org.eclipse.gyrex.cloud.services.events.EventMessage;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

final class EventMessageReceiver
extends WebSocketAdapter {
    private final IEventMessageCallback dispatcher;
    private final String localNodeId;

    EventMessageReceiver(String localNodeId, IEventMessageCallback dispatcher) {
        this.dispatcher = dispatcher;
        this.localNodeId = localNodeId;
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        ByteBuffer buffer = ByteBuffer.wrap(payload, offset, len);
        String id = this.readNextUtf8String(buffer);
        String topic = this.readNextUtf8String(buffer);
        String type = this.readNextUtf8String(buffer);
        String source = this.readNextUtf8String(buffer);
        EventMessage message = new EventMessage(id, type, buffer.slice());
        if (!this.localNodeId.equals(source)) {
            this.dispatcher.onEventMessage(topic, message);
        }
    }

    private String readNextUtf8String(ByteBuffer buffer) {
        int length = buffer.getInt();
        Utf8StringBuilder stringBuilder = new Utf8StringBuilder(length);
        stringBuilder.append((ByteBuffer)buffer.slice().limit(length));
        buffer.position(buffer.position() + length);
        return stringBuilder.toString();
    }

    public static interface IEventMessageCallback {
        public void onEventMessage(String var1, EventMessage var2);
    }
}

