/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.app;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.http.application.ApplicationException;
import org.eclipse.gyrex.http.application.context.IApplicationContext;
import org.eclipse.gyrex.http.application.context.IResourceProvider;
import org.eclipse.gyrex.http.application.context.NamespaceException;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.gyrex.http.jetty.internal.JettyDebug;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationHandler;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationResourceServlet;
import org.eclipse.gyrex.http.jetty.internal.app.ApplicationServletHandler;
import org.eclipse.gyrex.http.jetty.internal.app.BundleResourceProvider;
import org.eclipse.gyrex.http.jetty.internal.app.ResourceProviderHolder;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.StringUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationContext
implements IApplicationContext {
    private static final String SLASH_STAR = "/*";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationContext.class);
    private final ApplicationHandler applicationHandler;
    private final Lock registryModificationLock = new ReentrantLock();
    private final Set<String> registeredAliases = new HashSet<String>();
    private final Map<Object, BundleResourceMonitor> bundleMonitors = new HashMap<Object, BundleResourceMonitor>();
    private final Map<Class<? extends HttpServlet>, String> registeredServletNamesByClass = new HashMap<Class<? extends HttpServlet>, String>();
    private final Set<Filter> registeredFilters = new HashSet<Filter>();

    public ApplicationContext(ApplicationHandler applicationHandler) {
        this.applicationHandler = applicationHandler;
    }

    private void addBundleResourceMonitor(Class<? extends HttpServlet> servletClass) {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(servletClass);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null) {
            BundleResourceMonitor monitor = new BundleResourceMonitor(servletClass, bundleContext);
            this.bundleMonitors.put(servletClass, monitor);
            monitor.activate();
        }
    }

    private void addBundleResourceMonitor(Filter filter) {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(filter.getClass());
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null) {
            BundleResourceMonitor monitor = new BundleResourceMonitor(filter, bundleContext);
            this.bundleMonitors.put(filter, monitor);
            monitor.activate();
        }
    }

    private void addBundleResourceMonitor(String alias, Class<?> bundleClass) {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(bundleClass);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null) {
            BundleResourceMonitor monitor = new BundleResourceMonitor(alias, bundleContext);
            this.bundleMonitors.put(alias, monitor);
            monitor.activate();
        }
    }

    public Map<String, String> getInitProperties() {
        return this.applicationHandler.getInitParams();
    }

    public ServletContext getServletContext() {
        return this.applicationHandler.getServletContext();
    }

    private String[] getUrlPatterns(Class<? extends HttpServlet> annotatedServletClass, WebServlet webServlet) {
        if (webServlet.value().length + webServlet.urlPatterns().length == 0) {
            throw new IllegalArgumentException(String.format("The WebServlet annotation found on '%s' does neither have urlPatterns nor value set.", annotatedServletClass.getName()));
        }
        if (webServlet.value().length + webServlet.urlPatterns().length != Math.max(webServlet.value().length, webServlet.urlPatterns().length)) {
            throw new IllegalArgumentException(String.format("The WebServlet annotation found on '%s' must only have urlPatterns or value set but not both.", annotatedServletClass.getName()));
        }
        return webServlet.urlPatterns().length == 0 ? webServlet.value() : webServlet.urlPatterns();
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ApplicationException {
        return this.applicationHandler.getDelegateHandler().handleApplicationRequest(request, response);
    }

    private void initializeServletIfNecessary(Class<? extends HttpServlet> servletClass, ServletHolder holder) throws ServletException {
        if (this.applicationHandler.getServletHandler().isStarted() || this.applicationHandler.getServletHandler().isStarting()) {
            try {
                holder.start();
                holder.initialize();
            }
            catch (Exception e) {
                block5: {
                    try {
                        this.unregister(servletClass);
                    }
                    catch (Exception e2) {
                        if (!JettyDebug.debug) break block5;
                        LOG.debug("Exception during cleanup of failed registration.", (Throwable)e2);
                    }
                }
                throw new ServletException(String.format("Error starting servlet. %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    private void initializeServletIfNecessary(String alias, ServletHolder holder) throws ServletException {
        if (this.applicationHandler.getServletHandler().isStarted() || this.applicationHandler.getServletHandler().isStarting()) {
            try {
                holder.start();
                holder.initialize();
            }
            catch (Exception e) {
                block5: {
                    try {
                        this.unregister(alias);
                    }
                    catch (Exception e2) {
                        if (!JettyDebug.debug) break block5;
                        LOG.debug("Exception during cleanup of failed registration.", (Throwable)e2);
                    }
                }
                throw new ServletException(String.format("Error starting servlet. %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    private String normalizeAliasToPathSpec(String alias) throws IllegalArgumentException {
        if (alias == null) {
            throw new IllegalArgumentException("alias must not be null");
        }
        if (!alias.startsWith("/") && !alias.startsWith("*.")) {
            throw new IllegalArgumentException("alias must start with '/' or '*.'");
        }
        if (alias.endsWith(SLASH_STAR)) {
            throw new IllegalArgumentException("alias must not end with '/*'");
        }
        if (!"/".equals(alias) && StringUtil.endsWithIgnoreCase((String)alias, (String)"/")) {
            throw new IllegalArgumentException("alias must not end with '/'");
        }
        if (alias.startsWith("*.")) {
            return alias;
        }
        return "/".equals(alias) ? SLASH_STAR : alias.concat(SLASH_STAR);
    }

    private List<String> normalizeUrlPatternsToAliases(Class<? extends HttpServlet> annotatedServletClass, String[] urlPatterns) {
        ArrayList<String> aliases = new ArrayList<String>(urlPatterns.length);
        String[] stringArray = urlPatterns;
        int n = urlPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String alias;
            String urlPattern = stringArray[n2];
            String string = alias = "/".equals(urlPattern) || SLASH_STAR.equals(urlPattern) || StringUtils.isBlank((String)urlPattern) ? "/" : StringUtils.removeStart((String)StringUtils.removeEnd((String)urlPattern, (String)SLASH_STAR), (String)"/");
            if (JettyDebug.applicationContext) {
                LOG.debug("{} {}: converted URL pattern {} to alias {}", new Object[]{this, annotatedServletClass.getName(), urlPattern, alias});
            }
            aliases.add(alias);
            ++n2;
        }
        return aliases;
    }

    private void registerAlias(String alias) throws NamespaceException {
        if (this.registeredAliases.contains(alias)) {
            if (JettyDebug.applicationContext) {
                LOG.debug("{} alias already taken: {}", new Object[]{this, alias, new Exception("Call Stack")});
            }
            throw new NamespaceException(alias);
        }
        this.registeredAliases.add(alias);
    }

    public void registerFilter(String alias, Filter filter, Map<String, String> initparams) throws ServletException {
        String pathSpec = this.normalizeAliasToPathSpec(alias);
        if (JettyDebug.applicationContext) {
            LOG.debug("{} registering filter: {} (normalized to {}) --> {}", new Object[]{this, alias, pathSpec, filter});
        }
        this.registryModificationLock.lock();
        try {
            this.registerFilterObject(filter);
            this.addBundleResourceMonitor(filter);
            FilterHolder holder = new FilterHolder(filter);
            if (initparams != null) {
                holder.setInitParameters(initparams);
            }
            this.applicationHandler.getServletHandler().addFilterWithMapping(holder, pathSpec, null);
        }
        finally {
            this.registryModificationLock.unlock();
        }
    }

    private void registerFilterObject(Filter filter) throws ServletException {
        if (this.registeredFilters.contains(filter)) {
            throw new ServletException(String.format("Filter object (%s) already registered.", filter));
        }
        this.registeredFilters.add(filter);
    }

    public void registerResources(String alias, String name, IResourceProvider provider) throws NamespaceException {
        String pathSpec = this.normalizeAliasToPathSpec(alias);
        if (provider == null) {
            Bundle callingBundle = HttpJettyActivator.getInstance().getCallingBundle();
            if (callingBundle == null) {
                throw new IllegalArgumentException("unable to determine the calling bundle; please specify a non-null resource provider");
            }
            provider = new BundleResourceProvider(callingBundle);
        }
        if (JettyDebug.applicationContext) {
            LOG.debug("{} registering resource: {} (normalized to {}) --> {}", new Object[]{this, alias, pathSpec, provider});
        }
        this.registryModificationLock.lock();
        try {
            this.registerAlias(alias);
            this.addBundleResourceMonitor(alias, provider.getClass());
            this.applicationHandler.addResource(pathSpec, new ResourceProviderHolder(name, provider));
            ServletHolder holder = ApplicationResourceServlet.newHolder(this.applicationHandler);
            this.applicationHandler.getServletHandler().addServletWithMapping(holder, pathSpec);
            try {
                this.initializeServletIfNecessary(alias, holder);
            }
            catch (ServletException e) {
                throw new IllegalStateException(String.format("Unhandled error registering resources. %s", e.getMessage()), e);
            }
        }
        finally {
            this.registryModificationLock.unlock();
        }
    }

    public void registerServlet(Class<? extends HttpServlet> annotatedServletClass) throws ServletException, NamespaceException {
        if (annotatedServletClass == null) {
            throw new IllegalArgumentException("Servlet class mut not be null!");
        }
        WebServlet webServlet = annotatedServletClass.getAnnotation(WebServlet.class);
        if (webServlet == null) {
            throw new IllegalArgumentException(String.format("No WebServlet annotation found on '%s'.", annotatedServletClass.getName()));
        }
        String[] urlPatterns = this.getUrlPatterns(annotatedServletClass, webServlet);
        if (JettyDebug.applicationContext) {
            LOG.debug("{} registering servlet: {} ({})", new Object[]{this, annotatedServletClass.getName(), urlPatterns});
        }
        String servletName = StringUtils.isNotBlank((String)webServlet.name()) ? webServlet.name() : annotatedServletClass.getName();
        this.registryModificationLock.lock();
        try {
            this.registerServletClass(servletName, annotatedServletClass, urlPatterns);
            this.addBundleResourceMonitor(annotatedServletClass);
            ServletHolder holder = new ServletHolder(annotatedServletClass);
            holder.setName(servletName);
            holder.setDisplayName(webServlet.displayName());
            holder.setInitOrder(webServlet.loadOnStartup());
            holder.setAsyncSupported(webServlet.asyncSupported());
            WebInitParam[] webInitParamArray = webServlet.initParams();
            int n = webInitParamArray.length;
            int n2 = 0;
            while (n2 < n) {
                WebInitParam ip = webInitParamArray[n2];
                holder.setInitParameter(ip.name(), ip.value());
                ++n2;
            }
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(holder.getName());
            mapping.setPathSpecs(urlPatterns);
            this.applicationHandler.getServletHandler().addServlet(holder);
            this.applicationHandler.getServletHandler().addServletMapping(mapping);
            this.initializeServletIfNecessary(annotatedServletClass, holder);
        }
        finally {
            this.registryModificationLock.unlock();
        }
    }

    public void registerServlet(String alias, Class<? extends Servlet> servletClass, Map<String, String> initparams) throws ServletException, NamespaceException {
        String pathSpec = this.normalizeAliasToPathSpec(alias);
        if (JettyDebug.applicationContext) {
            LOG.debug("{} registering servlet: {} (normalized to {}) --> {}", new Object[]{this, alias, pathSpec, servletClass});
        }
        this.registryModificationLock.lock();
        try {
            this.registerAlias(alias);
            this.addBundleResourceMonitor(alias, servletClass);
            ServletHolder holder = new ServletHolder(servletClass);
            if (initparams != null) {
                holder.setInitParameters(initparams);
            }
            this.applicationHandler.getServletHandler().addServletWithMapping(holder, pathSpec);
            this.initializeServletIfNecessary(alias, holder);
        }
        finally {
            this.registryModificationLock.unlock();
        }
    }

    public void registerServlet(String alias, Servlet servlet, Map<String, String> initparams) throws ServletException, NamespaceException {
        String pathSpec = this.normalizeAliasToPathSpec(alias);
        if (JettyDebug.applicationContext) {
            LOG.debug("{} registering servlet: {} (normalized to {}) --> {}", new Object[]{this, alias, pathSpec, servlet});
        }
        this.registryModificationLock.lock();
        try {
            this.registerAlias(alias);
            this.addBundleResourceMonitor(alias, servlet.getClass());
            ServletHolder holder = new ServletHolder(servlet);
            if (initparams != null) {
                holder.setInitParameters(initparams);
            }
            this.applicationHandler.getServletHandler().addServletWithMapping(holder, pathSpec);
            this.initializeServletIfNecessary(alias, holder);
        }
        finally {
            this.registryModificationLock.unlock();
        }
    }

    private void registerServletClass(String servletName, Class<? extends HttpServlet> annotatedServletClass, String[] urlPatterns) throws NamespaceException, ServletException {
        if (this.registeredServletNamesByClass.containsKey(annotatedServletClass)) {
            throw new ServletException(String.format("Servlet class '%s' already registered.", annotatedServletClass.getName()));
        }
        if (this.registeredServletNamesByClass.containsValue(servletName)) {
            throw new ServletException(String.format("Servlet with name '%s' already registered.", servletName));
        }
        List<String> aliases = this.normalizeUrlPatternsToAliases(annotatedServletClass, urlPatterns);
        for (String alias : aliases) {
            if (!this.registeredAliases.contains(alias)) continue;
            if (JettyDebug.applicationContext) {
                LOG.debug("{} alias already taken: {}", new Object[]{this, alias, new Exception("Call Stack")});
            }
            throw new NamespaceException(alias);
        }
        this.registeredServletNamesByClass.put(annotatedServletClass, servletName);
        this.registeredAliases.addAll(aliases);
    }

    private void removeBundleResourceMonitor(Object aliasOrServletClassOrFilter) {
        BundleResourceMonitor monitor = this.bundleMonitors.remove(aliasOrServletClassOrFilter);
        if (monitor != null) {
            monitor.remove();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ApplicationContext [").append(this.applicationHandler.getApplicationId()).append("]");
        return builder.toString();
    }

    public void unregister(Class<? extends HttpServlet> annotatedServletClass) {
        if (annotatedServletClass == null) {
            throw new IllegalArgumentException("Servlet class mut not be null!");
        }
        WebServlet webServlet = annotatedServletClass.getAnnotation(WebServlet.class);
        if (webServlet == null) {
            throw new IllegalArgumentException(String.format("No WebServlet annotation found on '%s'.", annotatedServletClass.getName()));
        }
        String[] urlPatterns = this.getUrlPatterns(annotatedServletClass, webServlet);
        if (JettyDebug.applicationContext) {
            LOG.debug("{} unregistering: {} ({})", new Object[]{this, annotatedServletClass, urlPatterns});
        }
        this.registryModificationLock.lock();
        try {
            String servletName = this.unregisterServletClass(annotatedServletClass, urlPatterns);
            this.removeBundleResourceMonitor(annotatedServletClass);
            ApplicationServletHandler servletHandler = this.applicationHandler.getServletHandler();
            ServletMapping[] mappings = servletHandler.getServletMappings();
            ArrayList<ServletMapping> remainingMappings = new ArrayList<ServletMapping>(mappings.length);
            ServletMapping[] servletMappingArray = mappings;
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                ServletMapping mapping = servletMappingArray[n2];
                if (!servletName.equals(mapping.getServletName())) {
                    remainingMappings.add(mapping);
                }
                ++n2;
            }
            if (mappings.length == remainingMappings.size()) {
                LOG.warn("{} Servlet class '{}' registered but no mapping for servlet name '{}' removed.", new Object[]{this, annotatedServletClass, servletName});
            }
            ServletHolder[] servlets = servletHandler.getServlets();
            ArrayList<ServletHolder> servletsToRemove = new ArrayList<ServletHolder>(servlets.length);
            ArrayList<ServletHolder> remainingServlets = new ArrayList<ServletHolder>(servlets.length);
            ServletHolder[] servletHolderArray = servlets;
            int n3 = servlets.length;
            int n4 = 0;
            while (n4 < n3) {
                ServletHolder servlet = servletHolderArray[n4];
                if (!servletName.equals(servlet.getName())) {
                    remainingServlets.add(servlet);
                } else {
                    servletsToRemove.add(servlet);
                }
                ++n4;
            }
            if (servlets.length == remainingServlets.size()) {
                LOG.warn("{} Servlet class '{}' registered but no holder for servlet name '{}' removed.", new Object[]{this, annotatedServletClass, servletName});
            }
            servletHandler.setServlets(remainingServlets.toArray(new ServletHolder[remainingServlets.size()]));
            servletHandler.setServletMappings(remainingMappings.toArray(new ServletMapping[remainingMappings.size()]));
            for (ServletHolder servlet : servletsToRemove) {
                try {
                    servlet.doStop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.registryModificationLock.unlock();
        }
    }

    public void unregister(Filter filter) {
        if (JettyDebug.applicationContext) {
            LOG.debug("{} unregistering filter: {}", new Object[]{this, filter});
        }
        this.registryModificationLock.lock();
        try {
            this.removeBundleResourceMonitor(filter);
            ApplicationServletHandler servletHandler = this.applicationHandler.getServletHandler();
            FilterHolder[] filters = servletHandler.getFilters();
            ArrayList<FilterHolder> newfilters = new ArrayList<FilterHolder>(filters.length);
            HashSet<FilterHolder> toRemove = new HashSet<FilterHolder>(filters.length);
            HashSet<String> toRemoveNames = new HashSet<String>(filters.length);
            FilterHolder[] filterHolderArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                FilterHolder filterHolder = filterHolderArray[n2];
                if (filterHolder.getFilter() == filter) {
                    toRemove.add(filterHolder);
                    toRemoveNames.add(filterHolder.getName());
                } else {
                    newfilters.add(filterHolder);
                }
                ++n2;
            }
            if (toRemove.isEmpty()) {
                throw new IllegalStateException("filter '" + filter + "' not found");
            }
            FilterMapping[] mappings = servletHandler.getFilterMappings();
            ArrayList<FilterMapping> newMappings = new ArrayList<FilterMapping>(mappings.length);
            FilterMapping[] filterMappingArray = mappings;
            int n3 = mappings.length;
            int n4 = 0;
            while (n4 < n3) {
                FilterMapping mapping = filterMappingArray[n4];
                String filterName = mapping.getFilterName();
                if (!toRemove.contains(filterName)) {
                    newMappings.add(mapping);
                }
                ++n4;
            }
            servletHandler.setFilters(newfilters.toArray(new FilterHolder[newfilters.size()]));
            servletHandler.setFilterMappings(newMappings.toArray(new FilterMapping[newMappings.size()]));
            for (FilterHolder filterHolder : toRemove) {
                try {
                    filterHolder.doStop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.registryModificationLock.unlock();
        }
    }

    public void unregister(String alias) {
        String pathSpec = this.normalizeAliasToPathSpec(alias);
        if (JettyDebug.applicationContext) {
            LOG.debug("{} unregistering: {} (normalized to {})", new Object[]{this, alias, pathSpec});
        }
        this.registryModificationLock.lock();
        try {
            this.unregisterAlias(alias);
            this.removeBundleResourceMonitor(alias);
            this.applicationHandler.removeResource(pathSpec);
            ApplicationServletHandler servletHandler = this.applicationHandler.getServletHandler();
            boolean removedSomething = false;
            ServletMapping[] mappings = servletHandler.getServletMappings();
            ArrayList<ServletMapping> newMappings = new ArrayList<ServletMapping>(mappings.length);
            HashSet<String> mappedServlets = new HashSet<String>(mappings.length);
            ServletMapping[] servletMappingArray = mappings;
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] pathSpecs;
                ServletMapping mapping = servletMappingArray[n2];
                String[] stringArray = pathSpecs = mapping.getPathSpecs();
                int n3 = pathSpecs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String spec = stringArray[n4];
                    if (pathSpec.equals(spec)) {
                        mapping.setPathSpecs((String[])ArrayUtil.removeFromArray((Object[])mapping.getPathSpecs(), (Object)spec));
                        removedSomething = true;
                    }
                    ++n4;
                }
                if (mapping.getPathSpecs().length > 0) {
                    newMappings.add(mapping);
                    mappedServlets.add(mapping.getServletName());
                }
                ++n2;
            }
            if (!removedSomething) {
                throw new IllegalStateException("alias '" + alias + "' registered but nothing removed");
            }
            ServletHolder[] servlets = servletHandler.getServlets();
            ArrayList<ServletHolder> servletsToRemove = new ArrayList<ServletHolder>(servlets.length);
            ArrayList<ServletHolder> newServlets = new ArrayList<ServletHolder>(servlets.length);
            ServletHolder[] servletHolderArray = servlets;
            int n5 = servlets.length;
            int n6 = 0;
            while (n6 < n5) {
                ServletHolder servlet = servletHolderArray[n6];
                if (!mappedServlets.contains(servlet.getName())) {
                    servletsToRemove.add(servlet);
                } else {
                    newServlets.add(servlet);
                }
                ++n6;
            }
            servletHandler.setServlets(newServlets.toArray(new ServletHolder[newServlets.size()]));
            servletHandler.setServletMappings(newMappings.toArray(new ServletMapping[newMappings.size()]));
            for (ServletHolder servlet : servletsToRemove) {
                try {
                    servlet.doStop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.registryModificationLock.unlock();
        }
    }

    private void unregisterAlias(String alias) {
        if (!this.registeredAliases.contains(alias)) {
            throw new IllegalStateException("alias '" + alias + "' not registered");
        }
        this.registeredAliases.remove(alias);
    }

    private String unregisterServletClass(Class<? extends HttpServlet> annotatedServletClass, String[] urlPatterns) {
        if (!this.registeredServletNamesByClass.containsKey(annotatedServletClass)) {
            throw new IllegalStateException(String.format("Servlet class '%s' not registered!", annotatedServletClass.getName()));
        }
        List<String> aliases = this.normalizeUrlPatternsToAliases(annotatedServletClass, urlPatterns);
        for (String alias : aliases) {
            this.registeredAliases.remove(alias);
        }
        return this.registeredServletNamesByClass.remove(annotatedServletClass);
    }

    private final class BundleResourceMonitor
    implements BundleListener {
        private final String alias;
        private BundleContext bundleContext;
        private final long bundleId;
        private final Class<? extends HttpServlet> servletClass;
        private final Filter filter;

        BundleResourceMonitor(Class<? extends HttpServlet> servletClass, BundleContext bundleContext) {
            this.servletClass = servletClass;
            this.bundleContext = bundleContext;
            this.bundleId = bundleContext.getBundle().getBundleId();
            this.alias = null;
            this.filter = null;
        }

        BundleResourceMonitor(Filter filter, BundleContext bundleContext) {
            this.filter = filter;
            this.bundleContext = bundleContext;
            this.bundleId = bundleContext.getBundle().getBundleId();
            this.alias = null;
            this.servletClass = null;
        }

        BundleResourceMonitor(String alias, BundleContext bundleContext) {
            this.alias = alias;
            this.bundleContext = bundleContext;
            this.bundleId = bundleContext.getBundle().getBundleId();
            this.servletClass = null;
            this.filter = null;
        }

        void activate() {
            try {
                this.bundleContext.addBundleListener((BundleListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void bundleChanged(BundleEvent event) {
            if (this.bundleId != event.getBundle().getBundleId()) {
                return;
            }
            if (event.getType() == 16) {
                try {
                    try {
                        if (this.alias != null) {
                            ApplicationContext.this.unregister(this.alias);
                        } else if (this.servletClass != null) {
                            ApplicationContext.this.unregister(this.servletClass);
                        } else if (this.filter != null) {
                            ApplicationContext.this.unregister(this.filter);
                        }
                    }
                    catch (Exception exception) {
                        this.remove();
                    }
                }
                finally {
                    this.remove();
                }
            }
        }

        void remove() {
            try {
                this.bundleContext.removeBundleListener((BundleListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bundleContext = null;
        }
    }
}

