/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.cloud.services.locking.IExclusiveLock;
import org.eclipse.gyrex.cloud.services.locking.ILockService;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.IJob;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.history.IJobHistory;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.manager.IJobStateWatch;
import org.eclipse.gyrex.jobs.internal.manager.JobHungDetectionHelper;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.StorageBackedJobHistory;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferncesJobHistoryStorage;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferncesJobStorage;
import org.eclipse.gyrex.jobs.internal.util.ContextHashUtil;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.jobs.spi.storage.IJobHistoryStorage;
import org.eclipse.gyrex.jobs.spi.storage.JobHistoryEntryStorable;
import org.eclipse.gyrex.preferences.ModificationConflictException;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManagerImpl
implements IJobManager {
    private static final Logger LOG = LoggerFactory.getLogger(JobManagerImpl.class);
    private static final long DEFAULT_MODIFY_LOCK_TIMEOUT = 3000L;
    private static final long modifyLockTimeout = Long.getLong("gyrex.jobs.modifyLock.timeout", 3000L);
    private static final int storageMaxNumberOfRetries = (Integer)SystemSetting.newIntegerSetting((String)"gyrex.jobs.storage.retryAttempts", (String)"The number of retries that should be performed in case a storage operation fails.").usingDefault((Object)3).create().get();
    private static final long storageRetryDelayInMs = Math.max((Long)SystemSetting.newLongSetting((String)"gyrex.jobs.storage.retryDelayInMs", (String)"The time to wait in milli-seconds between retry attempts.").usingDefault((Object)150L).create().get(), 50L);
    static final IJobHistory EMPTY_HISTORY = new IJobHistory(){

        @Override
        public Collection<IJobHistoryEntry> getEntries() {
            return Collections.emptyList();
        }

        public String toString() {
            return "No history available.";
        }
    };
    private final IRuntimeContext context;
    private final ContextHashUtil contextHash;
    private final CloudPreferncesJobHistoryStorage cloudHistoryStore;

    public static IExclusiveLock acquireLock(JobImpl job) {
        String lockId = "gyrex.jobs.modify.".concat(job.getStorageKey());
        if (JobsDebug.jobLocks) {
            LOG.debug("Requesting lock {} for job {}", new Object[]{lockId, job.getId(), new Exception("Call Stack")});
        }
        try {
            return ((ILockService)JobsActivator.getInstance().getService(ILockService.class)).acquireExclusiveLock(lockId, null, modifyLockTimeout);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to get job modify lock. %s", e.getMessage()), e);
        }
    }

    public static void cancel(JobImpl job, String trigger) {
        IExclusiveLock jobLock = null;
        String jobId = job.getId();
        try {
            jobLock = JobManagerImpl.acquireLock(job);
            job = JobManagerImpl.getJob(jobId, job.getStorageKey());
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            if (job.getState() != JobState.WAITING && job.getState() != JobState.RUNNING) {
                return;
            }
            try {
                JobManagerImpl.setJobState(job, JobState.ABORTING, jobLock);
                JobManagerImpl.setJobCancelled(job, System.currentTimeMillis(), trigger != null ? trigger : JobManagerImpl.findCaller(), jobLock);
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error canceling job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    private static String findCaller() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length == 0) {
            return "";
        }
        int i = 0;
        while (i < trace.length) {
            if (!StringUtils.startsWith((String)trace[i].getClassName(), (String)JobManagerImpl.class.getName())) {
                return trace[i].toString();
            }
            ++i;
        }
        return "";
    }

    public static JobImpl getJob(String jobId, String storageKey) throws IllegalStateException {
        block3: {
            try {
                if (CloudPreferncesJobStorage.getJobsNode().nodeExists(storageKey)) break block3;
                return null;
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
            }
        }
        return CloudPreferncesJobStorage.readJob(jobId, CloudPreferncesJobStorage.getJobsNode().node(storageKey));
    }

    private static void releaseLock(IExclusiveLock jobLock, String jobId) {
        if (jobLock != null) {
            if (JobsDebug.jobLocks) {
                LOG.debug("Releasing lock {} for job {}", new Object[]{jobLock.getId(), jobId});
            }
            try {
                jobLock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void setJobCancelled(JobImpl job, long timestamp, String trigger, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job %s due to missing or lost job lock!", job.getId()));
        }
        if (!CloudPreferncesJobStorage.getJobsNode().nodeExists(job.getStorageKey())) {
            return;
        }
        Preferences jobNode = CloudPreferncesJobStorage.getJobsNode().node(job.getStorageKey());
        jobNode.putLong("lastCancelled", timestamp);
        jobNode.put("lastCancelledTrigger", trigger);
        jobNode.flush();
    }

    private static void setJobState(JobImpl job, JobState state, IExclusiveLock lock) throws BackingStoreException {
        if (state == null) {
            throw new IllegalArgumentException("job state must not be null");
        }
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job state of job %s to %s due to missing or lost job lock!", job.getId(), state.toString()));
        }
        if (!CloudPreferncesJobStorage.getJobsNode().nodeExists(job.getStorageKey())) {
            return;
        }
        Preferences jobNode = CloudPreferncesJobStorage.getJobsNode().node(job.getStorageKey());
        if (StringUtils.equals((String)jobNode.get("status", null), (String)state.name())) {
            return;
        }
        jobNode.put("status", state.name());
        jobNode.flush();
        job.setStatus(state);
    }

    @Inject
    public JobManagerImpl(IRuntimeContext context) {
        this.context = context;
        this.contextHash = new ContextHashUtil(context);
        this.cloudHistoryStore = new CloudPreferncesJobHistoryStorage(context);
    }

    @Override
    public void cancelJob(String jobId, String trigger) throws IllegalStateException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        if (job.getState() != JobState.WAITING && job.getState() != JobState.RUNNING) {
            return;
        }
        JobManagerImpl.cancel(job, trigger);
    }

    @Override
    public JobImpl createJob(String jobTypeId, String jobId, Map<String, String> parameter) {
        JobImpl jobImpl;
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (!IdHelper.isValidId((String)jobTypeId)) {
            throw new IllegalArgumentException(String.format("Invalid type id '%s'", jobTypeId));
        }
        IExclusiveLock jobLock = null;
        try {
            String internalId = this.toInternalId(jobId);
            if (CloudPreferncesJobStorage.getJobsNode().nodeExists(internalId)) {
                throw new IllegalStateException(String.format("Job '%s' is already stored", jobId));
            }
            Preferences node = CloudPreferncesJobStorage.getJobsNode().node(internalId);
            node.put("type", jobTypeId);
            node.flush();
            JobImpl job = CloudPreferncesJobStorage.readJob(jobId, node);
            jobLock = JobManagerImpl.acquireLock(job);
            this.syncJobNode(jobId);
            job = this.getJob(jobId);
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            this.setJobParameter(job, parameter, jobLock);
            JobManagerImpl.setJobState(job, JobState.NONE, jobLock);
            CloudPreferncesJobStorage.mayTriggerCleanup();
            jobImpl = CloudPreferncesJobStorage.readJob(jobId, node);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(String.format("Error creating job data. %s", e.getMessage()), e);
            }
            catch (Throwable throwable) {
                JobManagerImpl.releaseLock(jobLock, jobId);
                throw throwable;
            }
        }
        JobManagerImpl.releaseLock(jobLock, jobId);
        return jobImpl;
    }

    private void doQueueJob(String jobTypeId, String jobId, Map<String, String> parameter, String queueId, String trigger, String scheduleInfo) {
        JobImpl job = this.getJob(jobId);
        if (job == null && jobTypeId == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        IQueue queue = this.getOrCreateQueue(StringUtils.isNotBlank((String)queueId) ? queueId : "gyrex.jobs.queue.default");
        if (queue == null) {
            throw new IllegalStateException(String.format("Queue %s does not exist!", queueId));
        }
        IExclusiveLock jobLock = null;
        try {
            if (job == null) {
                try {
                    String internalId = this.toInternalId(jobId);
                    if (CloudPreferncesJobStorage.getJobsNode().nodeExists(internalId)) {
                        throw new IllegalStateException(String.format("Job '%s' is already stored", jobId));
                    }
                    Preferences node = CloudPreferncesJobStorage.getJobsNode().node(internalId);
                    node.put("type", jobTypeId);
                    node.flush();
                    job = CloudPreferncesJobStorage.readJob(jobId, node);
                }
                catch (BackingStoreException e) {
                    throw new IllegalStateException(String.format("Error creating job data. %s", e.getMessage()), e);
                }
            }
            jobLock = JobManagerImpl.acquireLock(job);
            this.syncJobNode(jobId);
            job = this.getJob(jobId);
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            if (job.getState() != JobState.NONE) {
                if (!this.isStuck(job)) {
                    throw new IllegalStateException(String.format("Job %s cannot be queued because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
                }
                LOG.warn("Job {} is in state {}. However, it's assumed stuck. The queue request will reset the state!", (Object)job.getId(), (Object)job.getState());
            }
            try {
                if (parameter != null) {
                    this.setJobParameter(job, parameter, jobLock);
                } else {
                    parameter = job.getParameter();
                }
                JobManagerImpl.setJobState(job, JobState.WAITING, jobLock);
                String queueTrigger = trigger != null ? trigger : JobManagerImpl.findCaller();
                long queueTimestamp = System.currentTimeMillis();
                queue.sendMessage(JobInfo.asMessage(new JobInfo(job.getTypeId(), jobId, this.context.getContextPath(), parameter, queueTrigger, queueTimestamp, scheduleInfo, job.getLastSuccessfulStart())));
                try {
                    this.setJobQueued(job, queueTimestamp, queueTrigger, jobLock);
                }
                catch (Exception e) {
                    LOG.warn("Unable to set job queue time for job {}: {}", (Object)jobId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            catch (Exception e) {
                try {
                    JobManagerImpl.setJobState(job, JobState.NONE, jobLock);
                }
                catch (Exception resetException) {
                    LOG.error("Unable to reset job state for job {}: {}", (Object)jobId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
                throw new IllegalStateException(String.format("Error queuing job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
        CloudPreferncesJobStorage.mayTriggerCleanup();
    }

    private <T> T executeWithRetry(Callable<T> c) throws Exception {
        int attempt = 0;
        while (true) {
            try {
                return c.call();
            }
            catch (ModificationConflictException e) {
                if (++attempt > storageMaxNumberOfRetries) {
                    throw e;
                }
                Thread.sleep(storageRetryDelayInMs);
                continue;
            }
            break;
        }
    }

    @Override
    public IJobHistory getHistory(String jobId) throws IllegalStateException {
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job '%s' does not exist.", jobId));
        }
        IJobHistoryStorage storage = this.getJobHistoryStore();
        if (storage == null) {
            return EMPTY_HISTORY;
        }
        try {
            int count = storage.count(jobId);
            if (count > 0) {
                return new StorageBackedJobHistory(jobId, storage);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error reading history", e);
        }
        return EMPTY_HISTORY;
    }

    @Override
    public JobImpl getJob(String jobId) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        return JobManagerImpl.getJob(jobId, this.toInternalId(jobId));
    }

    public IJobHistoryStorage getJobHistoryStore() {
        try {
            IJobHistoryStorage historyStorage = (IJobHistoryStorage)this.context.get(IJobHistoryStorage.class);
            if (historyStorage != null) {
                return historyStorage;
            }
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.error("Error accessing job history storage provider (context {}). Fallback to cloud based store. {}", new Object[]{this.context.getContextPath(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
        return this.cloudHistoryStore;
    }

    @Override
    public Collection<String> getJobs() {
        try {
            String[] storageIds = CloudPreferncesJobStorage.getJobsNode().childrenNames();
            ArrayList<String> jobIds = new ArrayList<String>(storageIds.length);
            String[] stringArray = storageIds;
            int n = storageIds.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                if (this.contextHash.isInternalId(internalId)) {
                    jobIds.add(this.toExternalId(internalId));
                }
                ++n2;
            }
            return Collections.unmodifiableCollection(jobIds);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
        }
    }

    @Override
    public Collection<String> getJobsByState(JobState state) {
        if (state == null) {
            throw new IllegalArgumentException("Status must not be null");
        }
        try {
            String[] storageIds = CloudPreferncesJobStorage.getJobsNode().childrenNames();
            ArrayList<String> jobIds = new ArrayList<String>(storageIds.length);
            String[] stringArray = storageIds;
            int n = storageIds.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                if (this.contextHash.isInternalId(internalId) && StringUtils.equals((String)CloudPreferncesJobStorage.getJobsNode().node(internalId).get("status", null), (String)state.name())) {
                    jobIds.add(this.toExternalId(internalId));
                }
                ++n2;
            }
            return Collections.unmodifiableCollection(jobIds);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
        }
    }

    private IQueue getOrCreateQueue(String queueId) {
        IQueueService queueService = JobsActivator.getInstance().getQueueService();
        IQueue queue = queueService.getQueue(queueId, null);
        if (queue == null) {
            queue = queueService.createQueue(queueId, null);
        }
        return queue;
    }

    public boolean isStuck(JobImpl job) {
        return JobHungDetectionHelper.isStuck(this.toInternalId(job.getId()), job, false);
    }

    @Override
    public void queueJob(String jobId, Map<String, String> parameter, String queueId, String trigger) throws IllegalArgumentException, IllegalStateException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        this.doQueueJob(null, jobId, parameter, queueId, trigger, null);
    }

    @Override
    public void queueJob(String jobTypeId, String jobId, Map<String, String> parameter, String queueId, String trigger) throws IllegalArgumentException, IllegalStateException {
        if (!IdHelper.isValidId((String)jobTypeId)) {
            throw new IllegalArgumentException(String.format("Invalid job type id '%s'", jobTypeId));
        }
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        this.doQueueJob(jobTypeId, jobId, parameter, queueId, trigger, null);
    }

    public void queueJob(String jobTypeId, String jobId, Map<String, String> parameter, String queueId, String trigger, String scheduleInfo) throws IllegalArgumentException, IllegalStateException {
        if (!IdHelper.isValidId((String)jobTypeId)) {
            throw new IllegalArgumentException(String.format("Invalid job type id '%s'", jobTypeId));
        }
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        this.doQueueJob(jobTypeId, jobId, parameter, queueId, trigger, scheduleInfo);
    }

    @Override
    public void queueJob(String jobId, String queueId, String trigger) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        this.doQueueJob(null, jobId, null, queueId, trigger, null);
    }

    @Override
    public void removeJob(String jobId) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            return;
        }
        if (job.getState() != JobState.NONE) {
            throw new IllegalStateException(String.format("Job %s cannot be removed because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
        }
        IExclusiveLock jobLock = null;
        try {
            try {
                jobLock = JobManagerImpl.acquireLock(job);
                final String internalId = this.toInternalId(jobId);
                final IEclipsePreferences jobsNode = CloudPreferncesJobStorage.getJobsNode();
                this.executeWithRetry(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        if (jobsNode.nodeExists(internalId)) {
                            jobsNode.node(internalId).removeNode();
                            jobsNode.flush();
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Error removing job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    public void setActive(String jobId) throws Exception {
        if (JobsDebug.debug) {
            LOG.debug("Marking job {} active.", (Object)jobId);
        }
        JobHungDetectionHelper.setActive(this.toInternalId(jobId));
        final Preferences jobNode = CloudPreferncesJobStorage.getJobsNode().node(this.toInternalId(jobId));
        this.executeWithRetry(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                jobNode.sync();
                jobNode.putBoolean("active", true);
                jobNode.flush();
                return null;
            }
        });
    }

    public void setInactive(String jobId) throws Exception {
        if (JobsDebug.debug) {
            LOG.debug("Marking job {} inactive.", (Object)jobId);
        }
        JobHungDetectionHelper.setInactive(this.toInternalId(jobId));
        final Preferences jobNode = CloudPreferncesJobStorage.getJobsNode().node(this.toInternalId(jobId));
        this.executeWithRetry(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                jobNode.sync();
                jobNode.remove("active");
                jobNode.flush();
                return null;
            }
        });
    }

    private void setJobParameter(JobImpl job, Map<String, String> parameter, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update parameter of job %s due to missing or lost job lock!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!CloudPreferncesJobStorage.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = CloudPreferncesJobStorage.getJobsNode().node(internalId);
        if (parameter != null && !parameter.isEmpty()) {
            Preferences paramNode = jobNode.node("parameter");
            String[] stringArray = paramNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (StringUtils.isBlank((String)parameter.get(key))) {
                    paramNode.remove(key);
                }
                ++n2;
            }
            for (Map.Entry<String, String> entry : parameter.entrySet()) {
                if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
                paramNode.put(entry.getKey(), entry.getValue());
            }
        } else if (jobNode.nodeExists("parameter")) {
            jobNode.node("parameter").removeNode();
        }
        jobNode.flush();
        job.setParameter((Map<String, String>)(parameter != null ? new HashMap<String, String>(parameter) : null));
    }

    @Override
    public void setJobParameter(String jobId, Map<String, String> parameter) throws IllegalStateException, IllegalArgumentException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (parameter == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        if (job.getState() != JobState.NONE && !this.isStuck(job)) {
            throw new IllegalStateException(String.format("Job %s cannot be updated because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
        }
        IExclusiveLock jobLock = null;
        try {
            try {
                jobLock = JobManagerImpl.acquireLock(job);
                job = this.getJob(jobId);
                if (job == null) {
                    throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
                }
                if (job.getState() != JobState.NONE) {
                    if (!this.isStuck(job)) {
                        throw new IllegalStateException(String.format("Job %s cannot be updated because of a job state conflict (expected %s, got %s)!", jobId, JobState.NONE.toString(), job.getState().toString()));
                    }
                    LOG.warn("Job {} is in state {}. However, it's assumed stuck. The updated will reset the state!", (Object)job.getId(), (Object)job.getState());
                }
                this.setJobParameter(job, parameter, jobLock);
                JobManagerImpl.setJobState(job, JobState.NONE, jobLock);
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error updating job parameter. %s", e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    private void setJobQueued(IJob job, long timestamp, String trigger, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job %s due to missing or lost job lock!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!CloudPreferncesJobStorage.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = CloudPreferncesJobStorage.getJobsNode().node(internalId);
        jobNode.putLong("lastQueued", timestamp);
        jobNode.put("lastQueuedTrigger", trigger);
        jobNode.flush();
    }

    private void setJobResult(JobImpl job, Map<String, String> parameter, IStatus result, long resultTimestamp, long startTimestamp, String queueTrigger, long queueTimestamp, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job result of job %s due to missing or lost job lock!", job.getId()));
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Unable to update job result of job %s due to missing result!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!CloudPreferncesJobStorage.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = CloudPreferncesJobStorage.getJobsNode().node(internalId);
        jobNode.putLong("lastResultTimestamp", resultTimestamp);
        jobNode.put("lastResultMessage", StringUtils.left((String)CloudPreferncesJobHistoryStorage.getFormattedMessage(result, 0), (int)CloudPreferncesJobHistoryStorage.MAX_RESULT_MESSAGE_SIZE));
        jobNode.putInt("lastResultSeverity", result.getSeverity());
        if (!result.matches(12)) {
            jobNode.putLong("lastSuccessfulFinish", resultTimestamp);
            jobNode.putLong("lastSuccessfulStart", startTimestamp);
        }
        jobNode.flush();
        IJobHistoryStorage storage = this.getJobHistoryStore();
        if (storage != null) {
            JobHistoryEntryStorable storable = new JobHistoryEntryStorable();
            storable.setResult(result);
            storable.setTimestamp(resultTimestamp);
            storable.setParameter(parameter);
            storable.setQueuedTrigger(queueTrigger);
            if (job.getLastCancelled() > job.getLastQueued() && job.getLastQueued() < resultTimestamp) {
                storable.setCancelledTrigger(job.getLastCancelledTrigger());
            }
            try {
                storage.add(job.getId(), storable);
            }
            catch (Exception e) {
                LOG.error("Error persisting job history for job '{}' (context {}). {}", new Object[]{job.getId(), this.context.getContextPath(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
    }

    private void setJobStartTime(IJob job, long startTimestamp, IExclusiveLock lock) throws BackingStoreException {
        if (lock == null || !lock.isValid()) {
            throw new IllegalStateException(String.format("Unable to update job %s due to missing or lost job lock!", job.getId()));
        }
        String internalId = this.toInternalId(job.getId());
        if (!CloudPreferncesJobStorage.getJobsNode().nodeExists(internalId)) {
            return;
        }
        Preferences jobNode = CloudPreferncesJobStorage.getJobsNode().node(internalId);
        jobNode.putLong("lastStart", startTimestamp);
        jobNode.flush();
    }

    public boolean setJobState(String jobId, JobState expected, JobState state, IJobStateWatch stateWatch, long stateTimestamp) throws IllegalArgumentException, IllegalStateException {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        if (state == null) {
            throw new IllegalArgumentException("Job state must not be null");
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = JobManagerImpl.acquireLock(job);
            this.syncJobNode(jobId);
            job = this.getJob(jobId);
            if (job == null) {
                throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
            }
            if (expected != null && job.getState() != expected) {
                if (!this.isStuck(job)) {
                    return false;
                }
                LOG.warn("Job {} is in state {} which doesn't match the expected state {}. However, it's assumed stuck. Thus, the status will be reset to {}!", new Object[]{job.getId(), job.getState(), expected, state});
            }
            try {
                JobManagerImpl.setJobState(job, state, jobLock);
                if (state == JobState.RUNNING) {
                    this.setJobStartTime(job, stateTimestamp, jobLock);
                }
                if (stateWatch != null) {
                    ((IEclipsePreferences)CloudPreferncesJobStorage.getJobsNode().node(this.toInternalId(jobId))).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new StateWatchListener(jobId, state, stateWatch));
                }
                return true;
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error updating state of job %s to %s. %s", jobId, state.name(), e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    public void setResult(String jobId, Map<String, String> parameter, IStatus result, long resultTimestamp, long startTimestamp, String queueTrigger, long queueTimestamp) {
        if (!IdHelper.isValidId((String)jobId)) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'", jobId));
        }
        JobImpl job = this.getJob(jobId);
        if (job == null) {
            throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
        }
        IExclusiveLock jobLock = null;
        try {
            jobLock = JobManagerImpl.acquireLock(job);
            this.syncJobNode(jobId);
            try {
                this.syncJobNode(jobId);
                job = this.getJob(jobId);
                if (job == null) {
                    throw new IllegalStateException(String.format("Job %s does not exist!", jobId));
                }
                JobManagerImpl.setJobState(job, JobState.NONE, jobLock);
                this.setJobResult(job, parameter, result, resultTimestamp, startTimestamp, queueTrigger, queueTimestamp, jobLock);
            }
            catch (BackingStoreException e) {
                throw new IllegalStateException(String.format("Error setting result of job %s. %s", jobId, e.getMessage()), e);
            }
        }
        finally {
            JobManagerImpl.releaseLock(jobLock, jobId);
        }
    }

    private void syncJobNode(final String jobId) {
        try {
            this.executeWithRetry(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    CloudPreferncesJobStorage.getJobsNode().node(JobManagerImpl.this.toInternalId(jobId)).sync();
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Exception refreshing job {}. Available job data might be stale.", (Object)this.toInternalId(jobId), (Object)e);
        }
    }

    private String toExternalId(String internalId) {
        return this.contextHash.toExternalId(internalId);
    }

    private String toInternalId(String id) {
        return this.contextHash.toInternalId(id);
    }

    private static class StateWatchListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final String jobId;
        private final JobState state;
        private final IJobStateWatch stateWatch;

        public StateWatchListener(String jobId, JobState state, IJobStateWatch stateWatch) {
            this.jobId = jobId;
            this.state = state;
            this.stateWatch = stateWatch;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"status".equals(event.getKey())) {
                return;
            }
            JobState newState = JobState.toState(event.getNewValue());
            if (newState != this.state) {
                try {
                    this.stateWatch.jobStateChanged(this.jobId);
                }
                finally {
                    ((IEclipsePreferences)event.getNode()).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
                }
            }
        }
    }
}

