/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.registry;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.registry.JobProviderExtensionReader;
import org.eclipse.gyrex.jobs.provider.JobProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobProviderRegistry
extends ServiceTracker<JobProvider, JobProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(JobProviderRegistry.class);
    private final ConcurrentMap<String, JobProvider> providerById = new ConcurrentHashMap<String, JobProvider>();
    private final ConcurrentMap<String, String> nameById = new ConcurrentHashMap<String, String>();
    private JobProviderExtensionReader extensionReader;

    public JobProviderRegistry(BundleContext context) {
        super(context, JobProvider.class, null);
    }

    public JobProvider addingService(ServiceReference<JobProvider> reference) {
        JobProvider service = (JobProvider)((Object)super.addingService(reference));
        Object defaultName = reference.getProperty("service.description");
        this.addJobProvider(service, defaultName instanceof String ? (String)defaultName : null);
        return service;
    }

    void addJobProvider(JobProvider provider, String defaultName) {
        if (JobsDebug.providerRegistry) {
            LOG.debug("Adding job provider: {}", (Object)provider);
        }
        Collection<String> ids = provider.getProvidedTypeIds();
        for (String id : ids) {
            JobProvider existing = this.providerById.putIfAbsent(id, provider);
            if (existing != null) {
                LOG.warn("Job provider with id {} already registered. Registration of job provider {} ignored.", (Object)id, (Object)provider);
                continue;
            }
            String name = provider.getName(id);
            this.nameById.putIfAbsent(id, name != null ? name : (defaultName != null ? defaultName : id));
        }
    }

    public void close() {
        this.extensionReader.close();
        this.extensionReader = null;
        super.close();
    }

    public String getName(String jobTypeId) {
        return (String)this.nameById.get(jobTypeId);
    }

    public JobProvider getProvider(String id) {
        return (JobProvider)((Object)this.providerById.get(id));
    }

    public Collection<String> getProviders() {
        return this.providerById.keySet();
    }

    public void open() {
        super.open();
        IExtensionRegistry extensionRegistry = (IExtensionRegistry)JobsActivator.getInstance().getService(IExtensionRegistry.class);
        this.extensionReader = new JobProviderExtensionReader(this, extensionRegistry);
    }

    public void removedService(ServiceReference<JobProvider> reference, JobProvider service) {
        this.removeJobProvider(service);
        super.removedService(reference, (Object)service);
    }

    void removeJobProvider(JobProvider provider) {
        if (JobsDebug.providerRegistry) {
            LOG.debug("Removing jobs provider: {}", (Object)provider);
        }
        Collection<String> ids = provider.getProvidedTypeIds();
        for (String id : ids) {
            this.providerById.remove(id, (Object)provider);
            this.nameById.remove(id);
        }
    }
}

