/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.diagnostics;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class StatusTracker
extends ServiceTracker<IStatus, IStatus> {
    private static final IStatus UNINITIALIZED = new Status(8, "org.eclipse.gyrex.monitoring", "Not Initialized.");
    private final CopyOnWriteArrayList<IStatus> statusList = new CopyOnWriteArrayList();
    private volatile IStatus systemStatus = UNINITIALIZED;

    public StatusTracker(BundleContext context) {
        super(context, IStatus.class, null);
    }

    public final IStatus addingService(ServiceReference<IStatus> reference) {
        IStatus status = (IStatus)super.addingService(reference);
        if (status != null) {
            this.statusList.add(status);
            this.updateStatus();
        }
        return status;
    }

    public final IStatus getSystemStatus() {
        return this.systemStatus;
    }

    public final void modifiedService(ServiceReference<IStatus> reference, IStatus service) {
        this.updateStatus();
    }

    public final void removedService(ServiceReference<IStatus> reference, IStatus service) {
        this.statusList.remove(service);
        this.updateStatus();
        super.removedService(reference, (Object)service);
    }

    protected void setSystemStatus(IStatus systemStatus) {
        this.systemStatus = systemStatus != null ? systemStatus : UNINITIALIZED;
    }

    private void updateStatus() {
        MultiStatus systemStatus = new MultiStatus("org.eclipse.gyrex.monitoring", 0, "System Status", null);
        for (IStatus status : this.statusList) {
            systemStatus.add(status);
        }
        this.setSystemStatus((IStatus)systemStatus);
    }
}

