/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.internal.mbeans;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricAttribute;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.osgi.framework.ServiceReference;

public class MetricSetMBean
implements DynamicMBean {
    private static final String RESET_STATS = "resetStats";
    private static final String PROPERTIES = "properties";
    private static final String DESCRIPTION = "description";
    private static final String ID = "id";
    private final MetricSet metricSet;
    private final ServiceReference<MetricSet> reference;
    private MBeanInfo beanInfo;
    private TabularDataSupport properties;
    private CompositeType propertyType;
    private TabularType propertyTableType;
    private Map<String, CompositeType> metricTypesByAttributeName;
    private Map<String, BaseMetric> metricByAttributeName;

    public MetricSetMBean(MetricSet metricSet, ServiceReference<MetricSet> reference) {
        this.metricSet = metricSet;
        this.reference = reference;
        this.initialize();
    }

    private OpenType detectType(Class type) {
        if (Long.class == type || Long.TYPE == type) {
            return SimpleType.LONG;
        }
        if (Integer.class == type || Integer.TYPE == type) {
            return SimpleType.INTEGER;
        }
        if (Double.class == type || Double.TYPE == type) {
            return SimpleType.DOUBLE;
        }
        if (Float.class == type || Float.TYPE == type) {
            return SimpleType.FLOAT;
        }
        if (Byte.class == type || Byte.TYPE == type) {
            return SimpleType.BYTE;
        }
        if (Short.class == type || Short.TYPE == type) {
            return SimpleType.SHORT;
        }
        if (Boolean.class == type || Boolean.TYPE == type) {
            return SimpleType.BOOLEAN;
        }
        if (BigDecimal.class == type) {
            return SimpleType.BIGDECIMAL;
        }
        if (BigInteger.class == type) {
            return SimpleType.BIGINTEGER;
        }
        if (Character.class == type || Character.TYPE == type) {
            return SimpleType.CHARACTER;
        }
        if (this.isConvertibleToString(type)) {
            return SimpleType.STRING;
        }
        return null;
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (ID.equals(attributeName)) {
            return this.metricSet.getId();
        }
        if (DESCRIPTION.equals(attributeName)) {
            return this.metricSet.getDescription();
        }
        if (PROPERTIES.equals(attributeName)) {
            return this.properties;
        }
        if (this.metricTypesByAttributeName.containsKey(attributeName)) {
            CompositeType type = this.metricTypesByAttributeName.get(attributeName);
            BaseMetric metric = this.metricByAttributeName.get(attributeName);
            if (type != null && metric != null) {
                Map<String, ?> rawValues = metric.getAttributeValues();
                String[] metricAttributeNames = type.keySet().toArray(new String[0]);
                Object[] metricValues = new Object[metricAttributeNames.length];
                int i = 0;
                while (i < metricValues.length) {
                    OpenType detectedTyp;
                    Object rawValue = rawValues.get(metricAttributeNames[i]);
                    if (rawValue != null && SimpleType.STRING == (detectedTyp = this.detectType(rawValue.getClass())) && !(rawValue instanceof String)) {
                        rawValue = String.valueOf(rawValue);
                    }
                    metricValues[i] = rawValue;
                    ++i;
                }
                try {
                    return new CompositeDataSupport(type, metricAttributeNames, metricValues);
                }
                catch (OpenDataException e) {
                    throw new MBeanException(e);
                }
            }
        }
        throw new AttributeNotFoundException(String.format("attribute %s not found", attributeName));
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = new AttributeList();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            try {
                attributeList.add(new Attribute(attributeName, this.getAttribute(attributeName)));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return attributeList;
    }

    public String getId() {
        return this.metricSet.getId();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    private CompositeType getType(BaseMetric metric) throws OpenDataException {
        List<MetricAttribute> attributes = metric.getAttributes();
        ArrayList<String> names = new ArrayList<String>(attributes.size());
        ArrayList<String> descriptions = new ArrayList<String>(attributes.size());
        ArrayList<OpenType> types = new ArrayList<OpenType>(attributes.size());
        for (MetricAttribute attribute : attributes) {
            OpenType openType = this.detectType(attribute.getType());
            if (openType == null) continue;
            names.add(attribute.getName());
            descriptions.add(attribute.getDescription());
            types.add(openType);
        }
        return new CompositeType(metric.getClass().getSimpleName(), "Metric of type " + metric.getClass().getName(), names.toArray(new String[names.size()]), descriptions.toArray(new String[descriptions.size()]), types.toArray(new OpenType[types.size()]));
    }

    private void initialize() {
        ArrayList<OpenMBeanAttributeInfoSupport> attributes = new ArrayList<OpenMBeanAttributeInfoSupport>();
        OpenMBeanConstructorInfo[] constructors = new OpenMBeanConstructorInfoSupport[]{};
        ArrayList<OpenMBeanOperationInfoSupport> operations = new ArrayList<OpenMBeanOperationInfoSupport>(1);
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{};
        attributes.add(new OpenMBeanAttributeInfoSupport(ID, "MetricSet Id", SimpleType.STRING, true, false, false));
        attributes.add(new OpenMBeanAttributeInfoSupport(DESCRIPTION, "MetricSet Description", SimpleType.STRING, true, false, false));
        try {
            String[] propertyKeys;
            String[] propertyTypeNames = new String[]{"key", "value"};
            this.propertyType = new CompositeType("property", "A property with name and value.", propertyTypeNames, new String[]{"Name", "Value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            this.propertyTableType = new TabularType(PROPERTIES, "A lst of properties.", this.propertyType, new String[]{"key"});
            attributes.add(new OpenMBeanAttributeInfoSupport(PROPERTIES, "MetricSet Properties", this.propertyTableType, true, false, false));
            this.properties = new TabularDataSupport(this.propertyTableType);
            String[] stringArray = propertyKeys = this.reference.getPropertyKeys();
            int n = propertyKeys.length;
            int n2 = 0;
            while (n2 < n) {
                Object value;
                String serviceProperty = stringArray[n2];
                if ((serviceProperty.startsWith("gyrex.") || serviceProperty.equals("service.description") || serviceProperty.equals("service.vendor")) && (value = this.reference.getProperty(serviceProperty)) != null && this.isConvertibleToString(value.getClass())) {
                    Object[] values = new Object[]{serviceProperty, String.valueOf(value)};
                    this.properties.put(new CompositeDataSupport(this.propertyType, propertyTypeNames, values));
                }
                ++n2;
            }
        }
        catch (OpenDataException e) {
            attributes.add(new OpenMBeanAttributeInfoSupport("propertiesError", "Exception occured while determining properties. " + e.toString(), SimpleType.STRING, true, false, false));
        }
        List<BaseMetric> metrics = this.metricSet.getMetrics();
        this.metricTypesByAttributeName = new HashMap<String, CompositeType>(metrics.size());
        this.metricByAttributeName = new HashMap<String, BaseMetric>(metrics.size());
        for (BaseMetric metric : metrics) {
            String attributeName = StringUtils.removeStart((String)metric.getId(), (String)(String.valueOf(this.metricSet.getId()) + "."));
            try {
                CompositeType type = this.getType(metric);
                if (type == null) continue;
                this.metricTypesByAttributeName.put(attributeName, type);
                this.metricByAttributeName.put(attributeName, metric);
                attributes.add(new OpenMBeanAttributeInfoSupport(attributeName, metric.getId(), type, true, false, false));
            }
            catch (OpenDataException e) {
                attributes.add(new OpenMBeanAttributeInfoSupport(String.valueOf(attributeName) + "Error", "Exception occured while determining properties. " + e.toString(), SimpleType.STRING, true, false, false));
            }
        }
        operations.add(new OpenMBeanOperationInfoSupport(RESET_STATS, "reset the metric statistics", null, SimpleType.VOID, 1));
        this.beanInfo = new OpenMBeanInfoSupport(this.getClass().getName(), this.metricSet.getDescription(), attributes.toArray(new OpenMBeanAttributeInfoSupport[attributes.size()]), constructors, operations.toArray(new OpenMBeanOperationInfoSupport[operations.size()]), notifications);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (RESET_STATS.equals(actionName)) {
            this.metricSet.resetStats();
        }
        return null;
    }

    private boolean isConvertibleToString(Class type) {
        return type == String.class || type.isPrimitive() || type == Boolean.class || Number.class.isAssignableFrom(type);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }
}

