/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricAttribute;

public class CapacityMetric
extends BaseMetric {
    private volatile long channelsUsed;
    private volatile long channelsCapacity;
    private volatile long channelsStatsHigh;
    private volatile long channelsStatsRequests;
    private volatile long channelsStatsDenied;
    private volatile long channelsStatsWaitTime;
    private volatile long channelsStatsWaitTimeAverage;

    public CapacityMetric(String id, long initialChannelsCapacity) {
        super(id);
        this.channelsCapacity = initialChannelsCapacity;
    }

    public void channelDenied() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            ++this.channelsStatsDenied;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void channelFinished() {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            --this.channelsUsed;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void channelStarted(long waitTime) {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            ++this.channelsUsed;
            if (this.channelsUsed > this.channelsStatsHigh) {
                this.channelsStatsHigh = this.channelsUsed;
            }
            ++this.channelsStatsRequests;
            this.channelsStatsWaitTime += waitTime;
            this.channelsStatsWaitTimeAverage = this.channelsStatsWaitTime / this.channelsStatsRequests;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    void doResetStats() {
        this.channelsStatsHigh = 0L;
        this.channelsStatsRequests = 0L;
        this.channelsStatsDenied = 0L;
        this.channelsStatsWaitTime = 0L;
        this.channelsStatsWaitTimeAverage = 0L;
    }

    @Override
    Object[] dumpMetrics() {
        return new Object[]{"used|capacity|high|requests|denied|wait|average wait", this.getChannelsUsed(), this.getChannelsCapacity(), this.getChannelsStatsHigh(), this.getChannelsStatsRequests(), this.getChannelsStatsDenied(), this.getChannelsStatsWaitTime(), this.getChannelsStatsWaitTimeAverage()};
    }

    public long getChannelsCapacity() {
        return this.channelsCapacity;
    }

    public long getChannelsStatsDenied() {
        return this.channelsStatsDenied;
    }

    public long getChannelsStatsHigh() {
        return this.channelsStatsHigh;
    }

    public long getChannelsStatsRequests() {
        return this.channelsStatsRequests;
    }

    public long getChannelsStatsWaitTime() {
        return this.channelsStatsWaitTime;
    }

    public long getChannelsStatsWaitTimeAverage() {
        return this.channelsStatsWaitTimeAverage;
    }

    public long getChannelsUsed() {
        return this.channelsUsed;
    }

    @Override
    void populateAttributes(List<MetricAttribute> attributes) {
        super.populateAttributes(attributes);
        attributes.add(new MetricAttribute("channelsUsed", "the number of channels in use", Long.class));
        attributes.add(new MetricAttribute("channelsCapacity", "the total number of channels available", Long.class));
        attributes.add(new MetricAttribute("channelsStatsHigh", "the high water mark since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("channelsStatsRequests", "the total number of processed requests since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("channelsStatsDenied", "the total number of requests denied since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("channelsStatsWaitTime", "the total time in milliseconds requests had to wait for a channel", Long.class));
        attributes.add(new MetricAttribute("channelsStatsWaitTimeAverage", "the average time in milliseconds a request had to wait for a channel", Long.class));
    }

    @Override
    void populateAttributeValues(Map<String, Object> values) {
        super.populateAttributeValues(values);
        values.put("channelsUsed", this.getChannelsUsed());
        values.put("channelsCapacity", this.getChannelsCapacity());
        values.put("channelsStatsHigh", this.getChannelsStatsHigh());
        values.put("channelsStatsRequests", this.getChannelsStatsRequests());
        values.put("channelsStatsDenied", this.getChannelsStatsDenied());
        values.put("channelsStatsWaitTime", this.getChannelsStatsWaitTime());
        values.put("channelsStatsWaitTimeAverage", this.getChannelsStatsWaitTimeAverage());
    }

    public void setChannelsCapacity(long channelsCapacity) {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            this.channelsCapacity = channelsCapacity;
        }
        finally {
            writeLock.unlock();
        }
    }
}

