/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.Counter;
import org.eclipse.gyrex.monitoring.metrics.MetricAttribute;
import org.eclipse.gyrex.monitoring.metrics.StopWatch;

public class TimerMetric
extends BaseMetric {
    private final TimeUnit timeUnit;
    private final Counter duration = new Counter();
    private final StopWatch.StopCallback stopCallback = new StopWatch.StopCallback(){

        @Override
        public void stopped(StopWatch stopWatch) {
            TimerMetric.this.processFinished(stopWatch.getDuration(TimerMetric.this.getTimeUnit()));
        }
    };

    public TimerMetric(String id) {
        this(id, TimeUnit.MILLISECONDS);
    }

    public TimerMetric(String id, TimeUnit timeUnit) {
        super(id);
        if (timeUnit == null) {
            throw new IllegalArgumentException("no time unit specified");
        }
        this.timeUnit = timeUnit;
    }

    @Override
    void doResetStats() {
        this.duration.reset();
    }

    @Override
    Object[] dumpMetrics() {
        return new Object[]{"count|time|time average|time high|time low|time stddev", this.getProcessingCount(), this.getProcessingTime(), this.getProcessingTimeAverage(), this.getProcessingTimeHigh(), this.getProcessingTimeLow(), this.getProcessingTimeStandardDeviation()};
    }

    public long getProcessingCount() {
        return this.duration.getNumberOfSamples();
    }

    public long getProcessingTime() {
        return this.duration.getValue();
    }

    public long getProcessingTimeAverage() {
        return this.duration.getAverage();
    }

    public long getProcessingTimeHigh() {
        return this.duration.getHigh();
    }

    public long getProcessingTimeLow() {
        return this.duration.getLow();
    }

    public double getProcessingTimeStandardDeviation() {
        return Math.sqrt(this.getProcessingTimeVariance());
    }

    public double getProcessingTimeVariance() {
        Lock lock = this.getReadLock();
        lock.lock();
        try {
            double d = this.duration.getVariance();
            return d;
        }
        finally {
            lock.unlock();
        }
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    void populateAttributes(List<MetricAttribute> attributes) {
        super.populateAttributes(attributes);
        attributes.add(new MetricAttribute("processingCount", "the number of finished processed since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("processingTime", "the total number of time consumed processing requests (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("processingTime", "the total number of time consumed processing requests (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("processingTimeAverage", "the average number of time consumed processing a request (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("processingTimeHigh", "the highest number of time consumed processing a request (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("processingTimeLow", "the lowest number of time consumed processing a request (excluding failed requests) since the last statistics reset", Long.class));
        attributes.add(new MetricAttribute("processingTimeStandardDeviation", "the standard deviation for the total number of time consumed processing requests (excluding failed requests) since the last statistics reset", Double.class));
        attributes.add(new MetricAttribute("timeUnit", "the time unit used in the metric", String.class));
    }

    @Override
    void populateAttributeValues(Map<String, Object> values) {
        super.populateAttributeValues(values);
        values.put("processingCount", this.getProcessingCount());
        values.put("processingTime", this.getProcessingTime());
        values.put("processingTimeAverage", this.getProcessingTimeAverage());
        values.put("processingTimeHigh", this.getProcessingTimeHigh());
        values.put("processingTimeLow", this.getProcessingTimeLow());
        values.put("processingTimeStandardDeviation", this.getProcessingTimeStandardDeviation());
        values.put("timeUnit", this.getTimeUnit().toString());
    }

    public void processFinished(long processingTime) {
        Lock writeLock = this.getWriteLock();
        writeLock.lock();
        try {
            this.duration.increment(processingTime);
        }
        finally {
            writeLock.unlock();
        }
    }

    public StopWatch processStarted() {
        StopWatch watch = new StopWatch(this.stopCallback);
        watch.start();
        return watch;
    }

    public static final class TimerMetricFactory
    implements BaseMetric.MetricFactory<TimerMetric> {
        public static final TimerMetricFactory MILLISECONDS = new TimerMetricFactory();
        public static final TimerMetricFactory NANOSECONDS = new TimerMetricFactory(TimeUnit.NANOSECONDS);
        private final TimeUnit timeUnit;

        public TimerMetricFactory() {
            this(TimeUnit.MILLISECONDS);
        }

        public TimerMetricFactory(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        @Override
        public TimerMetric create(String id) {
            return new TimerMetric(id, this.timeUnit);
        }
    }
}

