/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.profiling;

import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;

public class Transaction {
    public static final int COLLECT_THREAD_CPU_TIME = 2;
    static final DateFormat ISO_8601_UTC = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private final String id;
    private final long created;
    private final long threadCpuTimeStart;
    private final TimeUnit timeUnit;
    private final Map<String, BaseMetric> metricsById;
    private volatile long duration;
    private volatile long consumedThreadCpuTime;

    public Transaction(String id, int hints, TimeUnit timeUnit) {
        if (!BaseMetric.isValidId(id)) {
            throw new IllegalArgumentException("id is invalid (see BaseMetric#isValidId): " + id);
        }
        this.id = id;
        if (timeUnit == null) {
            throw new IllegalArgumentException("no time unit specified");
        }
        this.timeUnit = timeUnit;
        this.metricsById = new HashMap<String, BaseMetric>(5);
        this.threadCpuTimeStart = (hints & 2) != 0 && ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported() ? ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() : 0L;
        this.created = System.currentTimeMillis();
    }

    public boolean containsMetric(String id) {
        return this.metricsById.containsKey(id);
    }

    public void finished() {
        this.duration = System.currentTimeMillis() - this.created;
        if (this.threadCpuTimeStart > 0L) {
            this.consumedThreadCpuTime = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() - this.threadCpuTimeStart;
        }
    }

    public final String getCreationTime() {
        return ISO_8601_UTC.format(new Date(this.created));
    }

    protected final long getCreationTimeTS() {
        return this.created;
    }

    public long getDurationTime() {
        return this.timeUnit.convert(this.duration, TimeUnit.MILLISECONDS);
    }

    public final String getId() {
        return this.id;
    }

    public <T extends BaseMetric> T getMetric(String id) {
        return (T)this.metricsById.get(id);
    }

    public <T extends BaseMetric> T getOrCreateMetric(String id, BaseMetric.MetricFactory<T> factory) {
        BaseMetric metric = this.metricsById.get(id);
        if (metric == null) {
            metric = factory.create(id);
            this.metricsById.put(id, metric);
        }
        return (T)metric;
    }

    public long getThreadCpuTimeConsumed() {
        if (this.threadCpuTimeStart <= 0L) {
            return 0L;
        }
        return this.timeUnit.convert(this.consumedThreadCpuTime, TimeUnit.NANOSECONDS);
    }

    public double getThreadCpuUtilizationAverage() {
        if (this.threadCpuTimeStart <= 0L || this.duration <= 0L) {
            return 0.0;
        }
        return (double)TimeUnit.NANOSECONDS.toMillis(this.consumedThreadCpuTime) / (double)this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public <T extends BaseMetric> void putMetric(T metric) {
        this.metricsById.put(metric.getId(), metric);
    }

    public <T extends BaseMetric> T removeMetric(String id) {
        return (T)this.metricsById.remove(id);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append(this.getClass().getSimpleName()).append('(').append(this.getId()).append(')');
        return toString.toString();
    }
}

