/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.context.preferences.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.persistence.context.preferences.ContextPreferencesRepository;
import org.eclipse.gyrex.persistence.context.preferences.IContextPreferencesRepositoryConstants;
import org.eclipse.gyrex.persistence.context.preferences.internal.ContextPreferencesRepositoryImpl;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.eclipse.osgi.util.NLS;

public class ContextPreferencesRepositoryType
extends RepositoryProvider
implements IContextPreferencesRepositoryConstants {
    private IRuntimeContextRegistry contextRegistry;

    public ContextPreferencesRepositoryType() {
        super("org.eclipse.gyrex.persistence.context.preferences", ContextPreferencesRepository.class);
    }

    public Repository createRepositoryInstance(String repositoryId, IRepositoryPreferences repositoryPreferences) {
        String contextPathStr = repositoryPreferences.get("contextPath", null);
        if (contextPathStr == null) {
            throw new IllegalStateException(NLS.bind((String)"No context path configured for repository {0}.", (Object)repositoryId));
        }
        Path path = new Path(contextPathStr);
        IRuntimeContext context = this.getContextRegistry().get((IPath)path);
        if (context == null) {
            throw new IllegalStateException(NLS.bind((String)"No context accessible with context path {0} configured for repository {1}.", (Object)path.toString(), (Object)repositoryId));
        }
        return new ContextPreferencesRepositoryImpl(repositoryId, this, context);
    }

    public IRuntimeContextRegistry getContextRegistry() {
        IRuntimeContextRegistry registry = this.contextRegistry;
        if (registry == null) {
            throw new IllegalStateException("Context registry not available!");
        }
        return registry;
    }

    public void setContextRegistry(IRuntimeContextRegistry contextRegistry) {
        this.contextRegistry = contextRegistry;
    }
}

