/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.jdbc.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.eclipse.gyrex.persistence.jdbc.internal.SimplePooledJdbcRepositoryMetrics;
import org.eclipse.gyrex.persistence.jdbc.storage.JdbcRepository;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;

public class SimpledPooledJdbcRepositoryImpl
extends JdbcRepository {
    private final ConnectionPoolDataSource connectionPoolDataSource;
    private final ReentrantLock poolLock = new ReentrantLock();
    private volatile int maxPoolCapacity;
    private volatile int activeConnectionsCount;
    private final Set<PooledConnection> pooledConnections = new HashSet<PooledConnection>();
    private final Set<PooledConnection> activeConnections = new HashSet<PooledConnection>();
    private final Queue<PooledConnection> availableConnections = new ArrayDeque<PooledConnection>();
    private final ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

        @Override
        public void connectionClosed(ConnectionEvent event) {
            SimpledPooledJdbcRepositoryImpl.this.pooledConnectionClosed((PooledConnection)event.getSource(), false);
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            SimpledPooledJdbcRepositoryImpl.this.pooledConnectionClosed((PooledConnection)event.getSource(), true);
            SimpledPooledJdbcRepositoryImpl.this.getJdbcRepositoryMetrics().setSQLError("unknown", event.getSQLException());
        }
    };

    public SimpledPooledJdbcRepositoryImpl(String repositoryId, RepositoryProvider repositoryType, ConnectionPoolDataSource connectionPoolDataSource, int poolCapacity) {
        super(repositoryId, repositoryType, new SimplePooledJdbcRepositoryMetrics(SimpledPooledJdbcRepositoryImpl.createMetricsId((RepositoryProvider)repositoryType, (String)repositoryId), repositoryId, "open", "repository instance created", poolCapacity, 0L));
        this.connectionPoolDataSource = connectionPoolDataSource;
        this.maxPoolCapacity = poolCapacity;
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("repository '" + this.getRepositoryId() + "' closed");
        }
    }

    private void close(PooledConnection pooledConnection) {
        pooledConnection.removeConnectionEventListener(this.connectionEventListener);
        this.pooledConnections.remove(pooledConnection);
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private PooledConnection create() throws SQLException {
        PooledConnection pooledConnection = this.connectionPoolDataSource.getPooledConnection();
        this.pooledConnections.add(pooledConnection);
        pooledConnection.addConnectionEventListener(this.connectionEventListener);
        return pooledConnection;
    }

    protected void doClose() {
        ReentrantLock lock = this.poolLock;
        lock.lock();
        try {
            PooledConnection[] connections;
            PooledConnection[] pooledConnectionArray = connections = this.pooledConnections.toArray(new PooledConnection[0]);
            int n = connections.length;
            int n2 = 0;
            while (n2 < n) {
                PooledConnection pooledConnection = pooledConnectionArray[n2];
                this.markInactive(pooledConnection);
                this.close(pooledConnection);
                ++n2;
            }
        }
        finally {
            lock.unlock();
        }
        this.getJdbcRepositoryMetrics().getPoolStatusMetric().setStatus("closed", "repository closed through API call");
    }

    public int getActiveConnectionsCount() {
        return this.activeConnectionsCount;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        long start = System.currentTimeMillis();
        ReentrantLock lock = this.poolLock;
        lock.lock();
        try {
            Connection connection = this.getPooledConnection();
            if (connection != null) {
                this.getJdbcRepositoryMetrics().getPoolMetric().channelStarted(System.currentTimeMillis() - start);
            } else {
                this.getJdbcRepositoryMetrics().getPoolMetric().channelDenied();
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Connection getConnection(long timeout, TimeUnit timeUnit) throws SQLException {
        this.checkClosed();
        long start = System.currentTimeMillis();
        ReentrantLock lock = this.poolLock;
        try {
            if (!lock.tryLock(timeout, timeUnit)) {
                this.getJdbcRepositoryMetrics().getPoolMetric().channelDenied();
                return null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getJdbcRepositoryMetrics().getPoolMetric().channelDenied();
            return null;
        }
        try {
            Connection connection = this.getPooledConnection();
            if (connection != null) {
                this.getJdbcRepositoryMetrics().getPoolMetric().channelStarted(System.currentTimeMillis() - start);
            } else {
                this.getJdbcRepositoryMetrics().getPoolMetric().channelDenied();
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            lock.unlock();
        }
    }

    private Connection getConnection(PooledConnection pooledConnection) throws SQLException {
        return pooledConnection.getConnection();
    }

    public SimplePooledJdbcRepositoryMetrics getJdbcRepositoryMetrics() {
        return (SimplePooledJdbcRepositoryMetrics)this.getMetrics();
    }

    private Connection getPooledConnection() throws SQLException {
        PooledConnection pooledConnection = null;
        if (this.activeConnectionsCount < this.maxPoolCapacity) {
            pooledConnection = this.availableConnections.poll();
            this.getJdbcRepositoryMetrics().getPoolMetric().channelBusy();
        }
        if (pooledConnection == null) {
            pooledConnection = this.create();
        }
        this.markActive(pooledConnection);
        Connection connection = this.getConnection(pooledConnection);
        return connection;
    }

    private void markActive(PooledConnection pooledConnection) {
        try {
            this.activeConnections.add(pooledConnection);
        }
        finally {
            this.activeConnectionsCount = this.activeConnections.size();
        }
    }

    private void markInactive(PooledConnection pooledConnection) {
        try {
            this.activeConnections.remove(pooledConnection);
        }
        finally {
            this.activeConnectionsCount = this.activeConnections.size();
        }
    }

    void pooledConnectionClosed(PooledConnection pooledConnection, boolean forceRemoveFromPool) {
        ReentrantLock lock = this.poolLock;
        lock.lock();
        try {
            this.markInactive(pooledConnection);
            if (forceRemoveFromPool || this.activeConnectionsCount >= this.maxPoolCapacity) {
                this.close(pooledConnection);
            } else {
                this.availableConnections.add(pooledConnection);
                this.getJdbcRepositoryMetrics().getPoolMetric().channelIdle();
            }
        }
        finally {
            lock.unlock();
        }
        this.getJdbcRepositoryMetrics().getPoolMetric().channelFinished();
    }

    public void setPoolCapacity(int maximumPoolSize) {
        this.maxPoolCapacity = maximumPoolSize;
        this.getJdbcRepositoryMetrics().getPoolMetric().setChannelsCapacity((long)maximumPoolSize);
    }
}

