/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.eclipse.gyrex.persistence.solr.internal.SolrActivator;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SolrServerFactory.class);
    private static Constructor<?> commonsHttpSolrServerConstructor;
    private static Constructor<?> httpSolrServerConstructor;
    private static Constructor<?> cloudSolrServerConstructor;

    static {
        Bundle bundle = SolrActivator.getInstance().getBundle();
        try {
            commonsHttpSolrServerConstructor = bundle.loadClass("org.apache.solr.client.solrj.impl.CommonsHttpSolrServer").getConstructor(String.class);
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.debug("Error loading SolrJ 3 CommonsHttpSolrServer!", (Throwable)e);
        }
        try {
            httpSolrServerConstructor = bundle.loadClass("org.apache.solr.client.solrj.impl.HttpSolrServer").getConstructor(String.class);
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.debug("Error loading SolrJ 4 HttpSolrServer!", (Throwable)e);
        }
        try {
            cloudSolrServerConstructor = bundle.loadClass("org.apache.solr.client.solrj.impl.CloudSolrServer").getConstructor(String.class);
            LOG.info("SolrJ 4 Cloud client successfully loaded.");
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.debug("Error loading SolrJ 4 CloudSolrServer!", (Throwable)e);
        }
    }

    public static SolrServer createCloudSolrServer(String zkHost, String collection) throws MalformedURLException {
        if (cloudSolrServerConstructor != null) {
            SolrServer server = SolrServerFactory.createSolrServer(zkHost, cloudSolrServerConstructor);
            try {
                Method defaultCollectionSetter = server.getClass().getMethod("setDefaultCollection", String.class);
                defaultCollectionSetter.invoke((Object)server, collection);
            }
            catch (Exception e) {
                throw new IllegalStateException("No CloudSolrServer available!", e);
            }
            return server;
        }
        throw new IllegalStateException("No CloudSolrServer available!");
    }

    public static SolrServer createDefaultSolrServer(String urlString) throws MalformedURLException {
        if (httpSolrServerConstructor != null) {
            return SolrServerFactory.createSolrServer(urlString, httpSolrServerConstructor);
        }
        if (commonsHttpSolrServerConstructor != null) {
            return SolrServerFactory.createSolrServer(urlString, commonsHttpSolrServerConstructor);
        }
        throw new IllegalStateException("No compatible SolrJ API available!");
    }

    public static SolrServer createEmbeddedServer(String repositoryId) {
        String coreName = SolrActivator.getEmbeddedSolrCoreName(repositoryId);
        CoreContainer coreContainer = SolrActivator.getInstance().getEmbeddedCoreContainer();
        SolrCore core = coreContainer.getCore(coreName);
        if (core == null) {
            throw new IllegalStateException("Solr core '" + coreName + "' not found");
        }
        core.close();
        return new EmbeddedSolrServer(coreContainer, coreName);
    }

    public static SolrServer createLoadBalancingReadOptimizedServer(String[] readUrls) throws MalformedURLException {
        LBHttpSolrServer solrServerForRead = new LBHttpSolrServer(readUrls);
        SolrServerFactory.optimizeForRead((SolrServer)solrServerForRead);
        return solrServerForRead;
    }

    public static SolrServer createReadOptimizedServer(String urlString) throws MalformedURLException {
        SolrServer solrServerForRead = SolrServerFactory.createDefaultSolrServer(urlString);
        SolrServerFactory.optimizeForRead(solrServerForRead);
        return solrServerForRead;
    }

    private static SolrServer createSolrServer(String urlString, Constructor<?> solrServerConstructor) throws MalformedURLException {
        try {
            return (SolrServer)solrServerConstructor.newInstance(urlString);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof MalformedURLException) {
                throw (MalformedURLException)t;
            }
            throw new IllegalStateException("Unhandled exception creating SolrJ server instance. " + t.getMessage(), t);
        }
        catch (AssertionError | Exception | LinkageError e) {
            throw new IllegalStateException("Error creating SolrJ server instance. " + ((Throwable)e).getMessage(), (Throwable)e);
        }
    }

    private static void optimizeForRead(SolrServer solrServerForRead) {
        try {
            BeanUtils.setProperty((Object)solrServerForRead, (String)"connectionTimeout", (Object)new Integer(1000));
            BeanUtils.setProperty((Object)solrServerForRead, (String)"connectionManagerTimeout", (Object)new Integer(1000));
            BeanUtils.setProperty((Object)solrServerForRead, (String)"soTimeout", (Object)new Integer(5000));
        }
        catch (AssertionError | Exception | LinkageError e) {
            LOG.error("Unable to optimize Solr server object ({}) for read. {}", new Object[]{solrServerForRead, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    private SolrServerFactory() {
    }
}

