/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal;

import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.persistence.internal.storage.ContentTypeTracker;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryProviderRegistry;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryRegistry;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PersistenceActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.persistence";
    private static PersistenceActivator sharedInstance;
    private volatile RepositoryProviderRegistry repositoryProviderRegistry;
    private volatile RepositoryRegistry repositoryRegistry;
    private volatile ContentTypeTracker contentTypeTracker;
    private ServiceRegistration repositoryRegistryRegistration;

    public static PersistenceActivator getInstance() {
        PersistenceActivator instance = sharedInstance;
        if (instance == null) {
            throw new IllegalStateException("The Persistence bundle has not been started.");
        }
        return instance;
    }

    public PersistenceActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        sharedInstance = this;
        this.repositoryRegistry = new RepositoryRegistry(context);
        this.repositoryRegistryRegistration = this.getServiceHelper().registerService(IRepositoryRegistry.class.getName(), (Object)this.repositoryRegistry, "Eclipse.org", "Gyrex Repository Registry", null, null);
    }

    protected synchronized void doStop(BundleContext context) throws Exception {
        sharedInstance = null;
        this.repositoryRegistryRegistration.unregister();
        this.repositoryRegistryRegistration = null;
        this.repositoryRegistry.stop();
        this.repositoryRegistry = null;
        if (this.repositoryProviderRegistry != null) {
            this.repositoryProviderRegistry.close();
            this.repositoryProviderRegistry = null;
        }
        if (this.contentTypeTracker != null) {
            this.contentTypeTracker.close();
            this.contentTypeTracker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentTypeTracker getContentTypeTracker() {
        ContentTypeTracker tracker = this.contentTypeTracker;
        if (tracker == null) {
            PersistenceActivator persistenceActivator = this;
            synchronized (persistenceActivator) {
                if (this.contentTypeTracker != null) {
                    return this.contentTypeTracker;
                }
                if (!this.isActive()) {
                    throw this.createBundleInactiveException();
                }
                tracker = this.contentTypeTracker = new ContentTypeTracker(this.getBundle().getBundleContext());
                tracker.open();
            }
        }
        return tracker;
    }

    public RepositoryRegistry getRepositoriesManager() {
        RepositoryRegistry registry = this.repositoryRegistry;
        if (registry == null) {
            throw this.createBundleInactiveException();
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryProviderRegistry getRepositoryProviderRegistry() {
        RepositoryProviderRegistry registry = this.repositoryProviderRegistry;
        if (registry == null) {
            PersistenceActivator persistenceActivator = this;
            synchronized (persistenceActivator) {
                if (this.repositoryProviderRegistry != null) {
                    return this.repositoryProviderRegistry;
                }
                if (!this.isActive()) {
                    throw this.createBundleInactiveException();
                }
                registry = this.repositoryProviderRegistry = new RepositoryProviderRegistry();
                registry.start(this.getBundle().getBundleContext());
            }
        }
        return registry;
    }
}

