/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.console;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.persistence.internal.console.BaseRepoSelectingCommand;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryDefinition;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class ConfigRepo
extends BaseRepoSelectingCommand {
    @Argument(index=0, metaVar="ID-SUB-STRING", usage="repository sub-string id filter", required=true)
    protected String repositoryIdFilterArg;
    @Option(name="-set", aliases={"--set-preference"}, metaVar="KEY=VALUE", usage="a preference option to set", multiValued=true)
    protected Map<String, String> prefsToSet;
    @Option(name="-rm", aliases={"--remove-preference"}, metaVar="KEY", usage="a preference option to set", multiValued=true)
    protected List<String> prefsToRemove;
    @Option(name="-t", aliases={"--tags"}, metaVar="TAG", usage="tags to set", multiValued=true)
    protected List<String> tags;

    public ConfigRepo() {
        super("<repoIdFilter> -set <key>=value - sets a repository preference");
    }

    @Override
    protected String getRepositoryIdFilter() {
        if (this.repositoryIdFilterArg != null) {
            return this.repositoryIdFilterArg;
        }
        return super.getRepositoryIdFilter();
    }

    @Override
    protected void processRepository(String repositoryId) throws Exception {
        RepositoryDefinition definition = this.getRegistry().getRepositoryDefinition(repositoryId);
        IRepositoryPreferences preferences = definition.getRepositoryPreferences();
        preferences.sync();
        boolean modified = false;
        if (this.prefsToSet != null && !this.prefsToSet.isEmpty()) {
            modified = true;
            for (Map.Entry entry : this.prefsToSet.entrySet()) {
                if (entry.getValue() != null) {
                    preferences.put((String)entry.getKey(), (String)entry.getValue(), false);
                    continue;
                }
                preferences.putBoolean((String)entry.getKey(), true, false);
            }
        }
        if (this.prefsToRemove != null && !this.prefsToRemove.isEmpty()) {
            modified = true;
            for (String string : this.prefsToRemove) {
                preferences.remove(string);
            }
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            modified = true;
            for (String string : this.tags) {
                if (!StringUtils.isNotBlank((String)string)) continue;
                definition.addTag(string);
            }
        }
        if (modified) {
            preferences.flush();
            this.printf("Updated repository %s!", new Object[]{repositoryId});
        } else {
            this.printf("Nothing to update for repository %s!", new Object[]{repositoryId});
        }
    }
}

