/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.persistence.storage.content.IRepositoryContentTypeProvider;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ContentTypeTracker
extends ServiceTracker<IRepositoryContentTypeProvider, IRepositoryContentTypeProvider> {
    public ContentTypeTracker(BundleContext context) {
        super(context, IRepositoryContentTypeProvider.class, null);
    }

    public Collection<RepositoryContentType> getContentTypes(String mediaType) {
        ArrayList<RepositoryContentType> types = new ArrayList<RepositoryContentType>(2);
        Object[] providers = this.getServices();
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                IRepositoryContentTypeProvider provider = (IRepositoryContentTypeProvider)providers[i];
                Collection<RepositoryContentType> contentTypes = provider.getContentTypes();
                for (RepositoryContentType type : contentTypes) {
                    if (mediaType != null && !StringUtils.equals((String)type.getMediaType(), (String)mediaType)) continue;
                    types.add(type);
                }
                ++i;
            }
        }
        return types;
    }

    public Collection<RepositoryContentType> getContentTypes(String mediaTypeType, String mediaTypeSubtype) {
        ArrayList<RepositoryContentType> types = new ArrayList<RepositoryContentType>(2);
        Object[] providers = this.getServices();
        int i = 0;
        while (i < providers.length) {
            IRepositoryContentTypeProvider provider = (IRepositoryContentTypeProvider)providers[i];
            Collection<RepositoryContentType> contentTypes = provider.getContentTypes();
            for (RepositoryContentType type : contentTypes) {
                if (mediaTypeType != null && !StringUtils.equals((String)type.getMediaTypeType(), (String)mediaTypeType) || mediaTypeSubtype != null && !StringUtils.equals((String)type.getMediaTypeSubType(), (String)mediaTypeSubtype)) continue;
                types.add(type);
            }
            ++i;
        }
        return types;
    }
}

