/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.application;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gyrex.rap.application.Category;
import org.eclipse.gyrex.rap.application.PageHandle;
import org.eclipse.gyrex.rap.application.PageProvider;
import org.eclipse.gyrex.rap.widgets.DropDownItem;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

abstract class DropDownNavigation
extends DropDownItem {
    private static final long serialVersionUID = 1L;
    private final Category category;
    private final List<PageHandle> pages;
    private final Menu pullDownMenu;

    public DropDownNavigation(Composite parent, Category category, PageProvider pageProvider) {
        super(parent, category.getName(), "navigation");
        this.category = category;
        this.pages = pageProvider.getPages(category);
        Collections.sort(this.pages);
        this.pullDownMenu = new Menu((Decorations)parent.getShell(), 8);
        this.pullDownMenu.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getCustomVariant());
        for (PageHandle page : this.pages) {
            this.createMenuItem(page);
        }
    }

    private void createMenuItem(final PageHandle page) {
        MenuItem menuItem = new MenuItem(this.pullDownMenu, 16392);
        menuItem.setText(page.getName().replace("&", "&&"));
        menuItem.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getCustomVariant());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                DropDownNavigation.this.openPage(page);
            }
        });
    }

    PageHandle findFirstPage() {
        Iterator<PageHandle> iterator = this.pages.iterator();
        if (iterator.hasNext()) {
            PageHandle page = iterator.next();
            return page;
        }
        return null;
    }

    Category getCategory() {
        return this.category;
    }

    @Override
    protected void openDropDown(Point location) {
        if (this.pullDownMenu.getItemCount() == 0) {
            return;
        }
        this.setOpen(true);
        this.pullDownMenu.addMenuListener((MenuListener)new MenuAdapter(){
            private static final long serialVersionUID = 1L;

            public void menuHidden(MenuEvent e) {
                DropDownNavigation.this.setOpen(false);
                DropDownNavigation.this.pullDownMenu.removeMenuListener((MenuListener)this);
            }
        });
        this.pullDownMenu.setLocation(location);
        this.pullDownMenu.setVisible(true);
    }

    protected abstract void openPage(PageHandle var1);
}

