/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.application;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.eclipse.gyrex.rap.application.Category;
import org.eclipse.gyrex.rap.application.DropDownNavigation;
import org.eclipse.gyrex.rap.application.PageHandle;
import org.eclipse.gyrex.rap.application.PageProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

abstract class NavigationBar
extends Composite {
    private static final long serialVersionUID = 1L;
    private final List<Category> categories;
    private final PageProvider pageProvider;

    public NavigationBar(Composite parent, PageProvider pageProvider) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(5).create());
        this.setData("org.eclipse.rap.rwt.customVariant", "navigation");
        Preconditions.checkArgument((pageProvider != null ? 1 : 0) != 0, (Object)"PageProvider must not be null!");
        this.pageProvider = pageProvider;
        this.categories = this.getPageProvider().getCategories();
        Collections.sort(this.categories);
        for (Category category : this.categories) {
            this.createNavigationDropDown(category);
        }
    }

    private void changeSelectedDropDownEntry(PageHandle page, DropDownNavigation navEntry) {
        navEntry.setSelected(this.pageBelongsToDropDownNav(page, navEntry));
    }

    private void createNavigationDropDown(Category category) {
        new DropDownNavigation(this, category, this.getPageProvider()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void openPage(PageHandle page) {
                NavigationBar.this.openPage(page);
            }
        };
    }

    PageHandle findInitialPage() {
        Control[] children;
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof DropDownNavigation) {
                return ((DropDownNavigation)control).findFirstPage();
            }
            ++n2;
        }
        return null;
    }

    PageProvider getPageProvider() {
        return this.pageProvider;
    }

    protected abstract void openPage(PageHandle var1);

    private boolean pageBelongsToDropDownNav(PageHandle page, DropDownNavigation navEntry) {
        Category category = navEntry.getCategory();
        return category.getId().equals(page.getCategoryId());
    }

    void selectNavigationEntry(PageHandle page) {
        Control[] children;
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof DropDownNavigation) {
                this.changeSelectedDropDownEntry(page, (DropDownNavigation)control);
            }
            ++n2;
        }
    }
}

