/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.application;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.rap.application.RapApplicationEntryPoint;
import org.eclipse.gyrex.rap.internal.RapActivator;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.application.EntryPointFactory;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RapApplicationConfiguration
implements ApplicationConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(BundleResourceLoader.class);

    public void configure(Application application) {
        BundleResourceLoader webresourcesLoader = new BundleResourceLoader(this.getBundle(), (IPath)new Path("webresources"));
        application.addEntryPoint(this.getEntryPointPath(), new EntryPointFactory(){

            public EntryPoint create() {
                return RapApplicationConfiguration.this.createEntryPoint();
            }
        }, this.getEntryPointProperties());
        application.addStyleSheet("org.eclipse.rap.rwt.theme.Default", "theme/style.css", (ResourceLoader)webresourcesLoader);
        application.addResource("images/loading.gif", (ResourceLoader)webresourcesLoader);
    }

    protected abstract RapApplicationEntryPoint createEntryPoint();

    private Bundle getBundle() {
        return RapActivator.getInstance().getBundle();
    }

    protected String getEntryPointPath() {
        return "/";
    }

    protected Map<String, String> getEntryPointProperties() {
        HashMap<String, String> brandingProps = new HashMap<String, String>(4);
        brandingProps.put("org.eclipse.rap.rwt.webclient.pageTitle", this.getPageTitle());
        brandingProps.put("org.eclipse.rap.rwt.webclient.bodyHtml", this.readBundleResource("webresources/static/body.html", "UTF-8"));
        brandingProps.put("org.eclipse.rap.rwt.webclient.additionalHeaders", "<link href='http://fonts.googleapis.com/css?family=Open+Sans:400,800,600' rel='stylesheet' type='text/css'>");
        return brandingProps;
    }

    protected String getPageTitle() {
        return "Gyrex RAP Application";
    }

    private String readBundleResource(String resourceName, String charset) {
        URL entry = this.getBundle().getEntry(resourceName);
        if (entry == null) {
            throw new IllegalStateException(String.format("Bundle resource '%s' not available!", resourceName));
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream in = entry.openStream();){
                return IOUtils.toString((InputStream)in, (String)charset);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to read bundle resource '%s': %s", resourceName, e.getMessage()), e);
        }
    }

    protected static final class BundleResourceLoader
    implements ResourceLoader {
        private final Bundle bundle;
        private final IPath basePath;

        public BundleResourceLoader(Bundle bundle) {
            this(bundle, (IPath)Path.ROOT);
        }

        public BundleResourceLoader(Bundle bundle, IPath basePath) {
            Preconditions.checkArgument((bundle != null ? 1 : 0) != 0, (Object)"bundle must not be null");
            Preconditions.checkArgument((basePath != null ? 1 : 0) != 0, (Object)"basePath must not be null");
            this.bundle = bundle;
            this.basePath = basePath;
        }

        public InputStream getResourceAsStream(String resourceName) throws IOException {
            if (((String)Preconditions.checkNotNull((Object)resourceName)).indexOf("../") > -1) {
                LOG.debug("Detected illegal '..' in resource name '{}'.", (Object)resourceName);
                return null;
            }
            return FileLocator.openStream((Bundle)this.bundle, (IPath)this.basePath.append(resourceName), (boolean)true);
        }
    }
}

