/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.application;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.rap.application.FilteredPage;
import org.eclipse.gyrex.rap.application.IApplicationService;
import org.eclipse.gyrex.rap.application.NavigationBar;
import org.eclipse.gyrex.rap.application.Page;
import org.eclipse.gyrex.rap.application.PageHandle;
import org.eclipse.gyrex.rap.application.PageProvider;
import org.eclipse.gyrex.rap.internal.RapActivator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.BrowserNavigationEvent;
import org.eclipse.rap.rwt.client.service.BrowserNavigationListener;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RapApplicationEntryPoint
implements EntryPoint {
    private PageProvider pageProvider;
    private static final int CONTENT_MIN_HEIGHT = 800;
    private static final int CENTER_AREA_WIDTH = 998;
    private static final String HISTORY_TOKEN_SEPARATOR = "--";
    private static final String GYREX_WEBSITE_URL = "http://eclipse.org/gyrex/";
    private static final Logger LOG = LoggerFactory.getLogger(RapApplicationEntryPoint.class);
    private final IApplicationService applicationService = new IApplicationService(){

        @Override
        public void openPage(String pageId, String ... args) {
            RapApplicationEntryPoint.this.open(pageId, args);
        }
    };
    private Composite centerArea;
    private NavigationBar navigation;
    private Composite navBar;
    private final Map<String, Page> pagesById = new HashMap<String, Page>();
    private Page current;
    private Composite filterContainer;
    private Composite headerCenterArea;
    private Image logo;

    private static Label createHeadlineLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text.replace("&", "&&"));
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)"pageHeadline");
        return label;
    }

    private static FormData createLogoFormData(Image logo) {
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        return data;
    }

    private static FormData createNavBarFormData() {
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, 5);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private static void makeLink(Label control, final String url) {
        control.setCursor(control.getDisplay().getSystemCursor(21));
        control.addMouseListener((MouseListener)new MouseAdapter(){
            private static final long serialVersionUID = 1L;

            public void mouseDown(MouseEvent e) {
                JavaScriptExecutor service = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
                if (service != null) {
                    service.execute("window.location.href = '" + url + "'");
                }
            }
        });
    }

    private void activate(Page page, PageHandle contribution, String[] args) {
        Control child;
        Control[] controlArray = this.centerArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        controlArray = this.filterContainer.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (args == null || args.length == 0) {
            args = new String[]{contribution.getId()};
        }
        page.setArguments(args);
        String historyText = StringUtils.isNotBlank((String)page.getTitleToolTip()) ? String.format("%s - %s - Gyrex Admin", contribution.getName(), page.getTitleToolTip()) : String.format("%s - Gyrex Admin", contribution.getName());
        BrowserNavigation browserNavigation = (BrowserNavigation)RWT.getClient().getService(BrowserNavigation.class);
        if (browserNavigation != null) {
            browserNavigation.pushState(StringUtils.join((Object[])args, (String)HISTORY_TOKEN_SEPARATOR), historyText);
        }
        this.create(page, contribution, this.centerArea);
        this.headerCenterArea.layout(true, true);
        this.centerArea.layout(true, true);
        page.activate();
    }

    private void attachHistoryListener() {
        BrowserNavigation browserNavigation = (BrowserNavigation)RWT.getClient().getService(BrowserNavigation.class);
        if (browserNavigation != null) {
            browserNavigation.addBrowserNavigationListener(new BrowserNavigationListener(){
                private static final long serialVersionUID = 1L;

                public void navigated(BrowserNavigationEvent event) {
                    String[] tokens = StringUtils.splitByWholeSeparator((String)event.getState(), (String)RapApplicationEntryPoint.HISTORY_TOKEN_SEPARATOR);
                    PageHandle contribution = RapApplicationEntryPoint.this.getPageProvider().getPage(tokens[0]);
                    if (contribution != null) {
                        RapApplicationEntryPoint.this.open(contribution, tokens);
                    }
                }
            });
        }
    }

    private void create(Page page, PageHandle contribution, Composite parent) {
        String title;
        Composite pageComp = new Composite(parent, 0);
        pageComp.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        if (page instanceof FilteredPage) {
            ((FilteredPage)page).createFilterControls(this.filterContainer);
        }
        if (StringUtils.isBlank((String)(title = page.getTitle()))) {
            title = contribution.getName();
        }
        if (StringUtils.isNotBlank((String)title)) {
            Label label = RapApplicationEntryPoint.createHeadlineLabel(pageComp, page.getTitle());
            GridData layoutData = new GridData();
            layoutData.verticalIndent = 30;
            label.setLayoutData((Object)layoutData);
        }
        Composite contentComp = new Composite(pageComp, 0);
        contentComp.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        contentComp.setLayout((Layout)new FillLayout());
        page.createControl(contentComp);
        Control[] controlArray = contentComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getLayoutData() != null) {
                LOG.warn("Programming error in page {}: child composites ({}) should not make any assumptions about the parent layout!", (Object)contribution.getId(), (Object)child);
                child.setLayoutData(null);
            }
            ++n2;
        }
    }

    private Composite createCenterArea(Composite parent, Control topControl, Control bottomControl) {
        Composite centerArea = new Composite(parent, 0);
        centerArea.setLayout((Layout)new FillLayout());
        centerArea.setLayoutData((Object)this.createCenterAreaFormData(topControl, bottomControl));
        centerArea.setData("org.eclipse.rap.rwt.customVariant", (Object)"centerArea");
        return centerArea;
    }

    private FormData createCenterAreaFormData(Control topAttachment, Control bottomAttachment) {
        FormData data = new FormData();
        data.top = new FormAttachment(topAttachment, 0, 1024);
        data.bottom = new FormAttachment(bottomAttachment, -10, 128);
        data.left = new FormAttachment(50, -489);
        data.width = 988;
        return data;
    }

    private Composite createContent(ScrolledComposite scrolledArea) {
        Composite comp = new Composite((Composite)scrolledArea, 0);
        comp.setLayout((Layout)new FormLayout());
        Composite header = this.createHeader(comp);
        header.setLayoutData((Object)this.createHeaderFormData(this.getLogo().getBounds().height));
        this.createContentBody(comp, header);
        return comp;
    }

    private void createContentBody(Composite parent, Composite header) {
        Composite separator = new Composite(parent, 0);
        separator.setData("org.eclipse.rap.rwt.customVariant", (Object)"mainContentAreaHeaderSeparator");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)header, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 2;
        separator.setLayoutData((Object)data);
        Composite composite = new Composite(parent, 0);
        composite.setData("org.eclipse.rap.rwt.customVariant", (Object)"mainContentArea");
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)this.createContentBodyFormData((Control)separator));
        Composite footer = this.createFooter(composite);
        this.centerArea = this.createCenterArea(composite, (Control)separator, (Control)footer);
    }

    private FormData createContentBodyFormData(Control topControlToAttachTo) {
        FormData data = new FormData();
        data.top = new FormAttachment(topControlToAttachTo, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private Composite createFilterContainer(Composite parent, Control left) {
        Composite filterContainer = new Composite(parent, 0);
        filterContainer.setData("org.eclipse.rap.rwt.customVariant", (Object)"filter-container");
        FormData data = new FormData();
        data.bottom = new FormAttachment(100, 5);
        data.left = new FormAttachment(left, 5);
        filterContainer.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        filterContainer.setLayout((Layout)layout);
        return filterContainer;
    }

    private Composite createFooter(Composite contentComposite) {
        Composite footer = new Composite(contentComposite, 0);
        footer.setLayout((Layout)new FormLayout());
        footer.setData("org.eclipse.rap.rwt.customVariant", (Object)"footer");
        footer.setLayoutData((Object)this.createFooterFormData());
        footer.setBackgroundMode(2);
        Label label = new Label(footer, 0);
        label.setData("org.eclipse.rap.rwt.customVariant", (Object)"footerLabel");
        label.setText(this.getFooterText());
        label.setLayoutData((Object)this.createFooterLabelFormData(footer));
        return footer;
    }

    private FormData createFooterFormData() {
        FormData data = new FormData();
        data.left = new FormAttachment(50, -499);
        data.top = new FormAttachment(100, -40);
        data.bottom = new FormAttachment(100);
        data.width = 986;
        return data;
    }

    private FormData createFooterLabelFormData(Composite footer) {
        FormData data = new FormData();
        data.top = new FormAttachment(50, -10);
        data.right = new FormAttachment(100, -15);
        return data;
    }

    private Composite createHeader(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setData("org.eclipse.rap.rwt.customVariant", (Object)"header");
        comp.setBackgroundMode(1);
        comp.setLayout((Layout)new FormLayout());
        this.headerCenterArea = this.createHeaderCenterArea(comp);
        Label logoLabel = new Label(this.headerCenterArea, 0);
        logoLabel.setImage(this.getLogo());
        logoLabel.setLayoutData((Object)RapApplicationEntryPoint.createLogoFormData(this.getLogo()));
        RapApplicationEntryPoint.makeLink(logoLabel, GYREX_WEBSITE_URL);
        this.filterContainer = this.createFilterContainer(this.headerCenterArea, (Control)logoLabel);
        this.navigation = this.createNavigation(this.headerCenterArea);
        return comp;
    }

    private Composite createHeaderCenterArea(Composite parent) {
        Composite headerCenterArea = new Composite(parent, 0);
        headerCenterArea.setLayout((Layout)new FormLayout());
        headerCenterArea.setLayoutData((Object)this.createHeaderCenterAreaFormData());
        return headerCenterArea;
    }

    private FormData createHeaderCenterAreaFormData() {
        FormData data = new FormData();
        data.left = new FormAttachment(50, -499);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.width = 998;
        return data;
    }

    private FormData createHeaderFormData(int height) {
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = height;
        return data;
    }

    private Shell createMainShell(Display display) {
        Shell shell = new Shell(display, 8);
        shell.setMaximized(true);
        shell.setData("org.eclipse.rap.rwt.customVariant", (Object)"mainshell");
        return shell;
    }

    private NavigationBar createNavigation(Composite parent) {
        this.navBar = new Composite(parent, 0);
        this.navBar.setLayoutData((Object)RapApplicationEntryPoint.createNavBarFormData());
        this.navBar.setData("org.eclipse.rap.rwt.customVariant", (Object)"nav-bar");
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.navBar.setLayout((Layout)layout);
        NavigationBar navigation = new NavigationBar(this.navBar, this.getPageProvider()){
            private static final long serialVersionUID = 1L;

            @Override
            protected void openPage(PageHandle page) {
                RapApplicationEntryPoint.this.open(page, null);
            }
        };
        return navigation;
    }

    private ScrolledComposite createScrolledArea(Composite parent) {
        ScrolledComposite scrolledComp = new ScrolledComposite(parent, 768);
        scrolledComp.setMinHeight(800);
        scrolledComp.setMinWidth(998);
        scrolledComp.setExpandVertical(true);
        scrolledComp.setExpandHorizontal(true);
        return scrolledComp;
    }

    public int createUI() {
        Display display = new Display();
        Shell shell = this.createMainShell(display);
        shell.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledArea = this.createScrolledArea((Composite)shell);
        Composite content = this.createContent(scrolledArea);
        scrolledArea.setContent((Control)content);
        this.attachHistoryListener();
        shell.open();
        this.openInitial();
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                if (RapApplicationEntryPoint.this.current != null) {
                    RapApplicationEntryPoint.this.deactivate(RapApplicationEntryPoint.this.current);
                }
            }
        });
        return 0;
    }

    private void deactivate(Page page) {
        page.deactivate();
    }

    private Page get(PageHandle pageHandle) throws Exception {
        if (!this.pagesById.containsKey(pageHandle.getId())) {
            Page page = this.getPageProvider().createPage(pageHandle);
            page.setApplicationService(this.applicationService);
            this.pagesById.put(pageHandle.getId(), page);
        }
        return this.pagesById.get(pageHandle.getId());
    }

    protected String getFooterText() {
        return "Gyrex RAP Application";
    }

    protected Image getLogo() {
        if (this.logo == null) {
            ImageDescriptor imageDescriptor = RapActivator.getImageDescriptor("webresources/images/logo.png");
            this.logo = imageDescriptor.createImage((Device)Display.getCurrent());
        }
        return this.logo;
    }

    public PageProvider getPageProvider() {
        PageProvider provider = this.pageProvider;
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)"No page provioder set. Please set a page provider before using the application.");
        return provider;
    }

    private void open(PageHandle contribution, String[] args) {
        try {
            Page page = this.get(contribution);
            if (page == null) {
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.rap", String.format(" '%s' not found!", contribution.getId())), "Error Opening ");
                return;
            }
            if (this.current != null) {
                this.deactivate(this.current);
            }
            this.current = page;
            this.navigation.selectNavigationEntry(contribution);
            this.activate(page, contribution, args);
        }
        catch (AssertionError | Exception | LinkageError e) {
            Policy.getStatusHandler().show((IStatus)(e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, "org.eclipse.gyrex.rap", String.format("Unable to open page '%s (id %s)'. Please check the server logs.", contribution.getName(), contribution.getId()), (Throwable)e)), "Error Opening ");
        }
    }

    void open(String pageId, String ... args) {
        String[] argsWithId;
        if (StringUtils.isBlank((String)pageId)) {
            throw new IllegalArgumentException("invalid page id");
        }
        PageHandle contribution = this.getPageProvider().getPage(pageId);
        if (contribution == null) {
            return;
        }
        if (args != null) {
            argsWithId = new String[args.length + 1];
            argsWithId[0] = pageId;
            System.arraycopy(args, 0, argsWithId, 1, args.length);
        } else {
            argsWithId = new String[]{pageId};
        }
        this.open(contribution, argsWithId);
    }

    private void openInitial() {
        PageHandle contribution = this.navigation.findInitialPage();
        if (contribution != null) {
            this.open(contribution, null);
        }
    }

    public void setPageProvider(PageProvider pageProvider) {
        Preconditions.checkArgument((pageProvider != null ? 1 : 0) != 0, (Object)"PageProvider must not be null");
        this.pageProvider = pageProvider;
    }
}

