/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.application.http;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.application.context.IResourceProvider;
import org.eclipse.gyrex.rap.application.RapApplicationConfiguration;
import org.eclipse.gyrex.rap.internal.RapActivator;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.application.ApplicationRunner;
import org.eclipse.rap.rwt.engine.RWTServlet;
import org.osgi.framework.Bundle;

public class RapApplication
extends Application {
    private static final String ALIAS_RWT_SERVLET = "/";
    private static final String ALIAS_RWT_RESOURCES = "/rwt-resources";
    private final RapApplicationConfiguration applicationConfiguration;
    private ApplicationRunner applicationRunner;

    protected RapApplication(String id, IRuntimeContext context, RapApplicationConfiguration applicationConfiguration) {
        super(id, context);
        Preconditions.checkArgument((applicationConfiguration != null ? 1 : 0) != 0, (Object)"application configuration must not be null");
        this.applicationConfiguration = applicationConfiguration;
    }

    protected void doDestroy() {
        this.getApplicationContext().unregister(ALIAS_RWT_RESOURCES);
        this.getApplicationContext().unregister(ALIAS_RWT_SERVLET);
        if (this.applicationRunner != null) {
            this.applicationRunner.stop();
            this.applicationRunner = null;
        }
    }

    protected void doInit() throws IllegalStateException, Exception {
        final IPath contextBase = this.getResourceRootLocation();
        this.getApplicationContext().getServletContext().setAttribute("resource_root_location", (Object)contextBase.toString());
        this.applicationRunner = new ApplicationRunner((ApplicationConfiguration)this.getApplicationConfiguration(), this.getApplicationContext().getServletContext());
        this.applicationRunner.start();
        this.getApplicationContext().registerServlet(ALIAS_RWT_SERVLET, (Servlet)new RWTServlet(), null);
        this.getApplicationContext().registerResources(ALIAS_RWT_RESOURCES, "rwt-resources", new IResourceProvider(){

            public URL getResource(String path) throws MalformedURLException {
                String canonicalPath = URIUtil.canonicalPath((String)path);
                if (canonicalPath == null) {
                    return null;
                }
                return contextBase.append(canonicalPath).toFile().toURI().toURL();
            }

            public Set<String> getResourcePaths(String path) {
                return null;
            }
        });
    }

    protected RapApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    private Bundle getBundle() {
        return RapActivator.getInstance().getBundle();
    }

    private IPath getResourceRootLocation() {
        String resourceRootLocation = (String)this.getApplicationContext().getInitProperties().get("resource_root_location");
        if (resourceRootLocation != null && resourceRootLocation.length() > 0) {
            return new Path(resourceRootLocation);
        }
        return Platform.getStateLocation((Bundle)this.getBundle()).append("contexts").append(this.getId()).append(this.getContext().getContextPath().toString().replace('/', '_'));
    }
}

