/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.rap.internal;

import com.google.common.base.Preconditions;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ILogger;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.StatusHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RapActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.rap";
    private static RapActivator instance;

    public static ImageDescriptor getImageDescriptor(String path) {
        return ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)RapActivator.getInstance().getBundle(), (IPath)new Path(path), null));
    }

    public static RapActivator getInstance() {
        RapActivator activator = instance;
        Preconditions.checkState((activator != null ? 1 : 0) != 0, (Object)"The bundle org.eclipse.gyrex.rap is inactive!");
        return activator;
    }

    public RapActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        instance = this;
        this.setupJFacePolicy();
    }

    protected void doStop(BundleContext context) throws Exception {
        instance = null;
    }

    private void setupJFacePolicy() {
        Policy.setLog((ILogger)new ILogger(){
            final Logger LOG = LoggerFactory.getLogger((String)"org.eclipse.gyrex.rap.JFaceLog");

            public void log(IStatus status) {
                if (status.matches(8) || status.matches(4)) {
                    this.LOG.error(status.getMessage(), status.getException());
                } else if (status.matches(2)) {
                    this.LOG.warn(status.getMessage(), status.getException());
                } else {
                    this.LOG.info(status.getMessage(), status.getException());
                }
            }
        });
        final StatusHandler defaultStatusHandler = Policy.getStatusHandler();
        Policy.setStatusHandler((StatusHandler)new StatusHandler(){

            public void show(IStatus status, String title) {
                Policy.getLog().log(status);
                defaultStatusHandler.show(status, title);
            }
        });
    }
}

