/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.JaxbPreferences;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.SchemaEntry;
import org.eclipse.jpt.jaxb.core.SchemaLibrary;
import org.eclipse.jpt.jaxb.core.internal.SchemaEntryImpl;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaLibraryImpl
implements SchemaLibrary {
    private JaxbProject project;
    private final List<SchemaEntryImpl> schemaEntries;
    private final Map<String, SchemaEntryImpl> impliedEntries;

    SchemaLibraryImpl(JaxbProject project) {
        this.project = project;
        this.schemaEntries = new Vector<SchemaEntryImpl>();
        this.impliedEntries = new Hashtable<String, SchemaEntryImpl>();
        this.readProjectPreferences();
    }

    @Override
    public List<SchemaEntry> getSchemaEntries() {
        return Collections.unmodifiableList(this.schemaEntries);
    }

    @Override
    public List<String> getSchemaLocations() {
        return Collections.unmodifiableList(ListTools.list((Iterable)IterableTools.transform(this.schemaEntries, SchemaEntry.LOCATION_TRANSFORMER)));
    }

    @Override
    public void setSchemaLocations(List<String> schemaLocations) {
        for (SchemaEntryImpl entry : this.schemaEntries) {
            entry.dispose();
        }
        this.schemaEntries.clear();
        JaxbPreferences.setSchemaLocations(this.project.getProject(), schemaLocations);
        this.readProjectPreferences();
    }

    @Override
    public XsdSchema getSchema(String namespace) {
        for (SchemaEntry schemaEntry : this.schemaEntries) {
            if (!ObjectTools.equals((Object)namespace, (Object)schemaEntry.getNamespace())) continue;
            return schemaEntry.getXsdSchema(namespace);
        }
        if (!this.impliedEntries.containsKey(namespace)) {
            if (!ObjectTools.equals((Object)XsdUtil.getResolvedUri(namespace), (Object)namespace)) {
                this.impliedEntries.put(namespace, new SchemaEntryImpl(namespace));
            } else {
                return null;
            }
        }
        return this.impliedEntries.get(namespace).getXsdSchema(namespace);
    }

    protected void readProjectPreferences() {
        List<String> schemas = JaxbPreferences.getSchemaLocations(this.project.getProject());
        for (String schemaLocation : schemas) {
            SchemaEntryImpl entry = new SchemaEntryImpl(schemaLocation);
            this.schemaEntries.add(entry);
        }
    }

    @Override
    public void refreshSchema(String namespace) {
        for (SchemaEntryImpl entry : this.schemaEntries) {
            if (!ObjectTools.equals((Object)namespace, (Object)entry.getNamespace())) continue;
            entry.refresh();
        }
    }

    @Override
    public void refreshAllSchemas() {
        for (SchemaEntryImpl entry : this.schemaEntries) {
            entry.refresh();
        }
    }

    void dispose() {
        for (SchemaEntryImpl entry : this.schemaEntries) {
            entry.dispose();
        }
        for (SchemaEntryImpl entry : this.impliedEntries.values()) {
            entry.dispose();
        }
        this.schemaEntries.clear();
        this.impliedEntries.clear();
    }

    public void validate(List<IMessage> messages) {
        HashBag namespaces = new HashBag();
        for (SchemaEntry schemaEntry : this.schemaEntries) {
            namespaces.add((Object)schemaEntry.getNamespace());
            if (schemaEntry.isLoaded()) continue;
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.project.getProject(), (ValidationMessage)JptJaxbCoreValidationMessages.PROJECT__UNRESOLVED_SCHEMA, (Object[])new Object[]{schemaEntry.getLocation()}));
        }
        Iterator iterator = namespaces.uniqueIterator();
        while (iterator.hasNext()) {
            String namespace = (String)iterator.next();
            if (namespaces.count((Object)namespace) <= 1) continue;
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.project.getProject(), (ValidationMessage)JptJaxbCoreValidationMessages.PROJECT__DUPLICATE_NAMESPACE, (Object[])new Object[]{namespace}));
        }
    }
}

