/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jpt.common.ui.internal.PartAdapter2;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.DoubleModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.DoublePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaWindowSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.SetJpaSelectionJob;
import org.eclipse.jpt.jpa.ui.selection.JpaEditorManager;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.jpt.jpa.ui.selection.JpaViewManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JpaPageSelectionManager
implements JpaSelectionManager,
JpaViewManager.PageManager,
SetJpaSelectionJob.Manager {
    private final JpaWindowSelectionManager windowManager;
    private final IWorkbenchPage page;
    private final HashMap<IEditorPart, JpaEditorManager> editorManagers = new HashMap();
    private final SimplePropertyValueModel<JpaEditorManager> editorManagerModel = new SimplePropertyValueModel();
    private final PropertyValueModel<JpaFile> jpaFileModel;
    private final ModifiablePropertyValueModel<JpaStructureNode> jpaSelectionModel;
    private final PropertyChangeListener jpaSelectionListener = new PropertyChangeAdapter();
    private final IPartListener2 partListener = new PartListener();
    private final HashSet<JpaViewManager> viewManagers = new HashSet();
    private volatile boolean disposed = false;
    private static final Transformer<JpaEditorManager, PropertyValueModel<JpaFile>> JPA_FILE_MODEL_TRANSFORMER = new JpaFileModelTransformer();
    private static final Transformer<JpaEditorManager, ModifiablePropertyValueModel<JpaStructureNode>> JPA_SELECTION_MODEL_TRANSFORMER = new JpaSelectionModelTransformer();
    private static final String TRACE_OPTION = JpaSelectionManager.class.getSimpleName();

    JpaPageSelectionManager(JpaWindowSelectionManager windowManager, IWorkbenchPage page) {
        if (page == null) {
            throw new NullPointerException();
        }
        this.windowManager = windowManager;
        this.page = page;
        this.jpaFileModel = this.buildJpaFileModel();
        this.jpaSelectionModel = this.buildJpaSelectionModel();
        this.jpaSelectionModel.addPropertyChangeListener("value", this.jpaSelectionListener);
        this.page.addPartListener(this.partListener);
        this.updateEditorManagerModel();
    }

    @Override
    public PropertyValueModel<JpaFile> getJpaFileModel() {
        return this.jpaFileModel;
    }

    private PropertyValueModel<JpaFile> buildJpaFileModel() {
        return new DoublePropertyValueModel(this.buildEditorManagerJpaFileModel());
    }

    private PropertyValueModel<PropertyValueModel<JpaFile>> buildEditorManagerJpaFileModel() {
        return new TransformationPropertyValueModel(this.editorManagerModel, JPA_FILE_MODEL_TRANSFORMER);
    }

    @Override
    public ModifiablePropertyValueModel<JpaStructureNode> getJpaSelectionModel() {
        return this.jpaSelectionModel;
    }

    private ModifiablePropertyValueModel<JpaStructureNode> buildJpaSelectionModel() {
        return new DoubleModifiablePropertyValueModel(this.buildEditorManagerJpaSelectionModel());
    }

    private PropertyValueModel<ModifiablePropertyValueModel<JpaStructureNode>> buildEditorManagerJpaSelectionModel() {
        return new TransformationPropertyValueModel(this.editorManagerModel, JPA_SELECTION_MODEL_TRANSFORMER);
    }

    @Override
    public void setSelection(JpaStructureNode selection) {
        new SetJpaSelectionJob(this, selection).schedule();
    }

    @Override
    public void setSelection_(JpaStructureNode selection) {
        this.jpaSelectionModel.setValue((Object)selection);
    }

    @Override
    public JpaEditorManager getEditorManager(IEditorPart editor) {
        return editor == null ? null : this.getEditorManager_(editor);
    }

    private synchronized JpaEditorManager getEditorManager_(IEditorPart editor) {
        JpaEditorManager editorManager = this.editorManagers.get(editor);
        if (editorManager == null && (editorManager = this.buildEditorManager(editor)) != null) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "add editor manager: {0}", new Object[]{editor});
            this.editorManagers.put(editor, editorManager);
        }
        return editorManager;
    }

    private JpaEditorManager buildEditorManager(IEditorPart editor) {
        return (JpaEditorManager)editor.getAdapter(JpaEditorManager.class);
    }

    @Override
    public synchronized void addViewManager(JpaViewManager viewManager) {
        JptJpaUiPlugin.instance().trace(TRACE_OPTION, "add view manager: {0}", new Object[]{viewManager});
        if (this.disposed) {
            throw new IllegalStateException("page manager is disposed: " + this);
        }
        if (!this.viewManagers.add(viewManager)) {
            throw new IllegalArgumentException("duplicate view manager: " + viewManager);
        }
    }

    @Override
    public synchronized void removeViewManager(JpaViewManager viewManager) {
        JptJpaUiPlugin.instance().trace(TRACE_OPTION, "remove view manager: {0}", new Object[]{viewManager});
        if (!this.viewManagers.remove(viewManager)) {
            throw new IllegalArgumentException("missing view manager: " + viewManager);
        }
        if (this.viewManagers.isEmpty()) {
            this.dispose();
        }
    }

    private void dispose() {
        this.disposed = true;
        this.page.removePartListener(this.partListener);
        this.jpaSelectionModel.removePropertyChangeListener("value", this.jpaSelectionListener);
        for (JpaEditorManager editorManager : this.editorManagers.values()) {
            editorManager.dispose();
        }
        this.windowManager.removePageManager(this.page);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.page);
    }

    synchronized void partClosed(IWorkbenchPart part) {
        JpaEditorManager editorManager = this.editorManagers.remove(part);
        if (editorManager != null) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "removed editor manager: {0}", new Object[]{part});
            editorManager.dispose();
        }
        this.updateEditorManagerModel();
    }

    void updateEditorManagerModel() {
        this.editorManagerModel.setValue((Object)this.getEditorManager(this.page.getActiveEditor()));
    }

    static JpaPageSelectionManager forPage(IWorkbenchPage page) {
        JpaWindowSelectionManager manager = JpaWindowSelectionManager.forWindow(page.getWorkbenchWindow());
        return manager == null ? null : manager.getPageManager(page);
    }

    static JpaPageSelectionManager forPage_(IWorkbenchPage page) {
        JpaWindowSelectionManager wsm = JpaWindowSelectionManager.forWindow_(page.getWorkbenchWindow());
        return wsm == null ? null : wsm.getPageManager_(page);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaFileModelTransformer
    extends AbstractTransformer<JpaEditorManager, PropertyValueModel<JpaFile>> {
        JpaFileModelTransformer() {
        }

        public PropertyValueModel<JpaFile> transform_(JpaEditorManager editorManager) {
            return editorManager.getJpaFileModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaSelectionModelTransformer
    extends AbstractTransformer<JpaEditorManager, ModifiablePropertyValueModel<JpaStructureNode>> {
        JpaSelectionModelTransformer() {
        }

        public ModifiablePropertyValueModel<JpaStructureNode> transform_(JpaEditorManager editorManager) {
            return editorManager.getJpaSelectionModel();
        }
    }

    class PartListener
    extends PartAdapter2 {
        PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            JpaPageSelectionManager.this.updateEditorManagerModel();
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
            JpaPageSelectionManager.this.updateEditorManagerModel();
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null) {
                JpaPageSelectionManager.this.partClosed(part);
            }
        }
    }
}

