/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.remote.dialogs;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.remote.dialogs.ChooseCheckModeDialog;
import org.eclipse.jubula.autagent.remote.dialogs.ObservationConsoleBP;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.message.CAPRecordedMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.communication.internal.message.ServerShowDialogResponseMessage;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChooseCheckModeDialogBP {
    private static final Logger LOG = LoggerFactory.getLogger(ChooseCheckModeDialogBP.class);
    private static ChooseCheckModeDialog dialog = null;
    private static ChooseCheckModeDialogBP instance = null;
    private Map<String, Action> m_actionsObj = new HashMap<String, Action>();
    private List<String> m_actionsNames = new ArrayList<String>();
    private IComponentIdentifier m_compId;
    private String m_logName;

    private ChooseCheckModeDialogBP() {
    }

    public void create(final Component component, IComponentIdentifier ci, Point point, final Map checkValues, String logName) {
        this.m_compId = ci;
        this.m_logName = logName;
        if (dialog != null) {
            this.closeDialog(3);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog = new ChooseCheckModeDialog();
                dialog.setCheckValues(checkValues);
                ChooseCheckModeDialogBP.this.initValues(component);
                ChooseCheckModeDialogBP.this.initialize();
                dialog.createParameterPanel((Action)ChooseCheckModeDialogBP.this.m_actionsObj.get(ChooseCheckModeDialogBP.this.m_actionsNames.get(dialog.getAction())));
                ChooseCheckModeDialogBP.this.addListener();
                ChooseCheckModeDialogBP.this.addListenerStopCheckMode();
                dialog.getOkAndCheckOnButton().requestFocus();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension frameSize = dialog.getSize();
                if (frameSize.height > screenSize.height) {
                    frameSize.height = screenSize.height;
                }
                if (frameSize.width > screenSize.width) {
                    frameSize.width = screenSize.width;
                }
                dialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                dialog.setVisible(true);
                dialog.toFront();
            }
        });
    }

    private void addListener() {
        dialog.getOkAndCheckOnButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChooseCheckModeDialogBP.this.createCAP();
                ChooseCheckModeDialogBP.this.closeDialog(4);
            }
        });
        dialog.getOkAndCheckOnButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ChooseCheckModeDialogBP.this.createCAP();
                    ChooseCheckModeDialogBP.this.closeDialog(4);
                }
            }
        });
        dialog.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChooseCheckModeDialogBP.this.closeDialog(4);
            }
        });
        dialog.getCancelButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ChooseCheckModeDialogBP.this.closeDialog(4);
                }
            }
        });
        dialog.getActionCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.createParameterPanel((Action)ChooseCheckModeDialogBP.this.m_actionsObj.get(ChooseCheckModeDialogBP.this.m_actionsNames.get(dialog.getAction())));
                int i = 0;
                while (i < dialog.getTextFields().size()) {
                    JTextField field = (JTextField)dialog.getTextFields().get(i);
                    field.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (e.getKeyCode() == 10) {
                                ChooseCheckModeDialogBP.this.createCAP();
                                int i1 = 0;
                                while (i1 < dialog.getTextFields().size()) {
                                    JTextField field1 = (JTextField)dialog.getTextFields().get(i1);
                                    field1.removeKeyListener(this);
                                    ++i1;
                                }
                                ChooseCheckModeDialogBP.this.closeDialog(4);
                            }
                        }
                    });
                    ++i;
                }
            }
        });
        int i = 0;
        while (i < dialog.getTextFields().size()) {
            JTextField field = (JTextField)dialog.getTextFields().get(i);
            field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ChooseCheckModeDialogBP.this.createCAP();
                        int i1 = 0;
                        while (i1 < dialog.getTextFields().size()) {
                            JTextField field1 = (JTextField)dialog.getTextFields().get(i1);
                            field1.removeKeyListener(this);
                            ++i1;
                        }
                        ChooseCheckModeDialogBP.this.closeDialog(4);
                    }
                }
            });
            ++i;
        }
    }

    private void addListenerStopCheckMode() {
        dialog.getOkButStopCheckButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChooseCheckModeDialogBP.this.createCAP();
                ChooseCheckModeDialogBP.this.closeDialog(3);
            }
        });
        dialog.getOkButStopCheckButton().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ChooseCheckModeDialogBP.this.createCAP();
                    ChooseCheckModeDialogBP.this.closeDialog(3);
                }
            }
        });
    }

    private void createCAP() {
        MessageCap messageCap = new MessageCap();
        Action action = this.m_actionsObj.get(this.m_actionsNames.get(dialog.getAction()));
        messageCap.setMethod(action.getMethod());
        messageCap.setAction(action);
        messageCap.setCi(this.m_compId);
        messageCap.setLogicalName(this.m_logName);
        List parameterValues = dialog.getParameter();
        List params = this.m_actionsObj.get(this.m_actionsNames.get(dialog.getAction())).getParams();
        int i = 0;
        while (i < params.size()) {
            String value;
            Param param = (Param)params.get(i);
            MessageParam messageParam = new MessageParam();
            messageParam.setType(param.getType());
            String emptyString = "";
            String string = value = emptyString.equals(parameterValues.get(i)) ? null : (String)parameterValues.get(i);
            if (value.length() > 3999) {
                String extraMsg = "Actions with Strings larger than 3999 are not supported";
                ObservationConsoleBP.getInstance().setExtraMessage(extraMsg);
                return;
            }
            messageParam.setValue(value);
            messageCap.addMessageParam(messageParam);
            ++i;
        }
        CAPRecordedMessage capTestMessage = new CAPRecordedMessage(messageCap);
        try {
            AutStarter.getInstance().getCommunicator().send((Message)capTestMessage);
        }
        catch (CommunicationException communicationException) {}
    }

    private void initValues(Component comp) {
        Component component = comp;
        while (component != null && !component.isVisible() && !component.getRealized().isEmpty()) {
            List realizedComponents = component.getRealized();
            component = (Component)realizedComponents.get(0);
        }
        if (component.getType() != null) {
            dialog.setNameLabel(CompSystemI18n.getString((String)component.getType()));
        } else {
            dialog.setNameLabel(CompSystemI18n.getString((String)this.m_compId.getSupportedClassName()));
        }
        this.m_actionsObj.clear();
        Iterator iter = component.getActions().iterator();
        LinkedList<String> names = new LinkedList<String>();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (action.isDeprecated() || action.getName().indexOf("Verify") == -1 || action.getName().equals("CompSystem.VerifyTableCellTextAtMousePosition") || action.getName().endsWith("Indexpath") || action.getName().endsWith("Indexpath (Specify Position)") || action.getName().endsWith("Index") || action.getName().endsWith("Indices")) continue;
            names.add(CompSystemI18n.getString((String)action.getName()));
            this.m_actionsObj.put(CompSystemI18n.getString((String)action.getName()), action);
        }
        this.m_actionsNames = names;
        Collections.sort(this.m_actionsNames, Collections.reverseOrder());
        dialog.setActions(this.m_actionsNames);
    }

    private void initialize() {
        dialog.setSize(320, 250);
        dialog.setResizable(false);
    }

    public void closeDialog(int mode) {
        if (dialog != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dialog.dispose();
                    dialog = null;
                }
            });
            this.m_actionsNames.clear();
            this.m_actionsObj.clear();
            try {
                ServerShowDialogResponseMessage responseMsg = new ServerShowDialogResponseMessage(false, mode);
                responseMsg.setBelongsToDialog(true);
                Communicator autCommunicator = AutStarter.getInstance().getAutCommunicator();
                if (autCommunicator != null && autCommunicator.getConnection() != null) {
                    autCommunicator.send((Message)responseMsg);
                }
            }
            catch (CommunicationException e) {
                LOG.error("Error sending message!", (Throwable)e);
            }
        }
    }

    public void closeDialog() {
        if (dialog != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dialog.dispose();
                    dialog = null;
                }
            });
            this.m_actionsNames.clear();
            this.m_actionsObj.clear();
        }
    }

    public static ChooseCheckModeDialogBP getInstance() {
        if (instance == null) {
            instance = new ChooseCheckModeDialogBP();
        }
        return instance;
    }
}

