/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestResult;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.model.TestResultParameter;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXMLReportGenerator {
    public static final String EXPECTED_NUM_STEPS = "expectedNumSteps";
    public static final String NUM_STEPS_TESTED = "numStepsTested";
    public static final String NUM_FAILED_STEPS = "numFailedSteps";
    public static final String NUM_EVENT_HANDLER_STEPS = "numEventHandlerSteps";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXMLReportGenerator.class);
    private Document m_document = DocumentHelper.createDocument();
    private ITestResult m_testResult;

    public AbstractXMLReportGenerator(ITestResult testResult) {
        this.setTestResult(testResult);
    }

    public abstract Document generateXmlReport();

    protected Element generateHeader() {
        Date endTime;
        if (LOG.isInfoEnabled()) {
            LOG.info("Generating Result XML Report");
        }
        this.m_document.normalize();
        this.m_document.addComment("<?xml-stylesheet type=\"text/xsl\" href=\"format.xsl\"?>");
        Element root = this.m_document.addElement("report");
        root.addAttribute("style", this.getStyleName());
        Element general = root.addElement("project");
        ITestResult testResult = this.getTestResult();
        general.addElement("name").addText(testResult.getProjectName());
        ProjectVersion version = new ProjectVersion(testResult.getProjectMajorVersion(), testResult.getProjectMinorVersion(), testResult.getProjectMicroVersion(), testResult.getProjectVersionQualifier());
        general.addElement("version").addText(version.toString());
        Date startTime = testResult.getStartTime();
        if (startTime != null) {
            general.addElement("test-start").addText(startTime.toString());
        }
        if ((endTime = testResult.getEndTime()) != null) {
            general.addElement("test-end").addText(endTime.toString());
        }
        if (startTime != null && endTime != null) {
            general.addElement("test-length").addText(TimeUtil.getDurationString((Date)startTime, (Date)endTime));
            int executedCAPs = testResult.getNumberOfTestedSteps();
            String averageCAPExecutionTime = Messages.Na;
            if (executedCAPs > 0) {
                averageCAPExecutionTime = String.valueOf((endTime.getTime() - startTime.getTime()) / (long)executedCAPs);
            }
            general.addElement("average-cap-duration").addText(averageCAPExecutionTime);
        }
        this.addStepCountElements(testResult, general);
        general.addElement("language").addText(testResult.getTestLanguage());
        return general;
    }

    private void addStepCountElements(ITestResult result, Element general) {
        int expectedNumberOfSteps = result.getExpectedNumberOfSteps();
        int numberOfStepsExecuted = result.getNumberOfTestedSteps();
        int numberOfEventHandlerSteps = result.getNumberOfEventHandlerSteps();
        int numberOfFailedTestSteps = result.getNumberOfFailedSteps();
        general.addElement(EXPECTED_NUM_STEPS).addText(String.valueOf(expectedNumberOfSteps));
        general.addElement(NUM_STEPS_TESTED).addText(String.valueOf(numberOfStepsExecuted));
        general.addElement(NUM_EVENT_HANDLER_STEPS).addText(String.valueOf(numberOfEventHandlerSteps));
        general.addElement(NUM_FAILED_STEPS).addText(String.valueOf(numberOfFailedTestSteps));
    }

    protected Element buildRootElement(Element parent) {
        return this.buildElement(parent, this.getTestResult().getRootResultNode());
    }

    protected Element buildElement(Element element, TestResultNode resultNode) {
        Element insertInto = element;
        INodePO node = resultNode.getNode();
        if (node instanceof ITestSuitePO) {
            Element suite;
            ITestSuitePO ts = (ITestSuitePO)node;
            insertInto = suite = element.addElement("testsuite");
            this.addGeneralElements(resultNode, insertInto);
            IAUTMainPO aut = ts.getAut();
            Element autEl = suite.addElement("aut");
            autEl.addElement("name").addText(aut.getName());
            autEl.addElement("config").addText(this.getTestResult().getAutConfigName());
            autEl.addElement("server").addText(this.getTestResult().getAutAgentHostName());
            autEl.addElement("cmdline-parameter").setText(this.getTestResult().getAutArguments());
            insertInto = suite.addElement("test-run");
        } else if (node instanceof IEventExecTestCasePO) {
            insertInto = element.addElement("eventhandler");
            this.addGeneralElements(resultNode, insertInto);
            Element typeEl = insertInto.addElement("type");
            typeEl.addText(I18n.getString((String)((IEventExecTestCasePO)node).getEventType()));
            Element reentryEl = insertInto.addElement("reentry-property");
            reentryEl.addText(((IEventExecTestCasePO)node).getReentryProp().toString());
        } else if (node instanceof ITestCasePO) {
            insertInto = element.addElement("testcase");
            this.addGeneralElements(resultNode, insertInto);
        } else if (node instanceof ICapPO) {
            insertInto = element.addElement("step");
            this.addGeneralElements(resultNode, insertInto);
            this.addCapElements(resultNode, insertInto, (ICapPO)node);
        }
        this.addParamNodeElements(resultNode, insertInto);
        return insertInto;
    }

    protected void addParamNodeElements(TestResultNode resultNode, Element insertInto) {
        for (TestResultParameter parameter : resultNode.getParameters()) {
            String name = parameter.getName();
            String type = parameter.getType();
            String value = parameter.getValue();
            Element paramEl = insertInto.addElement("parameter");
            if (name != null) {
                Element paramNameEl = paramEl.addElement("parameter-name");
                paramNameEl.addText(name);
            }
            if (type != null) {
                Element paramTypeEl = paramEl.addElement("parameter-type");
                paramTypeEl.addText(type);
            }
            if (value != null) {
                Element paramValueEl = paramEl.addElement("parameter-value");
                paramValueEl.addText(value);
            }
            if (paramEl.hasContent()) continue;
            insertInto.remove(paramEl);
        }
    }

    protected void addCapElements(TestResultNode resultNode, Element insertInto, ICapPO node) {
        ICapPO cap = node;
        this.getTimestampFromResultNode(resultNode, insertInto);
        Element compEl = insertInto.addElement("component-name");
        compEl.addText(StringUtils.defaultString((String)resultNode.getComponentName()));
        Element compTypeEl = insertInto.addElement("component-type");
        compTypeEl.addText(CompSystemI18n.getString((String)cap.getComponentType(), (boolean)true));
        double heuristicMatch = resultNode.getOmHeuristicEquivalence();
        if (heuristicMatch >= 0.0) {
            Element heuristicMatchElement = insertInto.addElement("component-heuristic-match");
            heuristicMatchElement.addText(String.valueOf(heuristicMatch));
        }
        Element actionEl = insertInto.addElement("action-type");
        actionEl.addText(CompSystemI18n.getString((String)cap.getActionName(), (boolean)true));
        if (resultNode.getStatus() == 2 || resultNode.getStatus() == 7) {
            byte[] screenshotData;
            Element error = insertInto.addElement("error");
            Element errorType = error.addElement("type");
            TestErrorEvent event = resultNode.getEvent();
            if (event != null) {
                errorType.addText(I18n.getString((String)event.getId(), (boolean)true));
                Map eventProps = event.getProps();
                if (eventProps.containsKey("guidancerErrorDescription")) {
                    String key = (String)eventProps.get("guidancerErrorDescription");
                    Object[] args = (Object[])eventProps.get("guidancerErrorParameter");
                    args = args != null ? args : new Object[]{};
                    Element mapEntry = error.addElement("description");
                    if (mapEntry != null && key != null) {
                        mapEntry.addText(resultNode.hasBackingNode() ? String.valueOf(I18n.getString((String)key, (Object[])args)) : key);
                    }
                } else {
                    for (Map.Entry entry : eventProps.entrySet()) {
                        if ("guidancerErrorDescription".equals(entry.getKey())) continue;
                        Element mapEntry = error.addElement((String)entry.getKey());
                        mapEntry.addText(String.valueOf(entry.getValue()));
                    }
                }
            }
            if (ClientTest.instance().isScreenshotForXML() && (screenshotData = resultNode.getScreenshot()) != null) {
                Element screenshotElement = error.addElement("screenshot");
                screenshotElement.addText(new String(Base64.encodeBase64((byte[])screenshotData, (boolean)false)));
            }
        }
    }

    private void getTimestampFromResultNode(TestResultNode resultNode, Element insertInto) {
        Element timestampEL = insertInto.addElement("timestamp");
        Date time = resultNode.getTimeStamp();
        if (time != null) {
            String timestamp = time.toString();
            timestampEL.addText(timestamp);
        } else {
            timestampEL.addText("");
        }
    }

    protected void addGeneralElements(TestResultNode resultNode, Element insertInto) {
        Element name = insertInto.addElement("name");
        INodePO resNode = resultNode.getNode();
        name.addText(resNode.getName());
        if (resNode.getComment() != null) {
            Element comment = insertInto.addElement("comment");
            comment.addText(resNode.getComment());
        }
        Element status = insertInto.addElement("status");
        status.addText(String.valueOf(resultNode.getStatus()));
        long durationMillis = resultNode.getDuration(this.getTestResult().getEndTime());
        if (durationMillis != -1L) {
            insertInto.addAttribute("duration", DurationFormatUtils.formatDurationHMS((long)durationMillis));
        }
    }

    protected Document getDocument() {
        return this.m_document;
    }

    protected abstract String getStyleName();

    public ITestResult getTestResult() {
        return this.m_testResult;
    }

    private void setTestResult(ITestResult testResult) {
        this.m_testResult = testResult;
    }
}

