/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;

public class CapBP {
    private CapBP() {
    }

    public static ICapPO createCapWithDefaultParams(String capName, String componentName, String componentType, String actionName) {
        ICapPO cap = null;
        cap = NodeMaker.createCapPO(capName, componentName, componentType, actionName);
        IProjectPO project = GeneralStorage.getInstance().getProject();
        Action action = CapBP.getAction(cap);
        String[] stringArray = action.getParamNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            Param parameter = action.findParam(paramName);
            String defaultValue = parameter.getDefaultValue();
            ITestDataPO testData = PoMaker.createTestDataPO();
            for (Locale locale : project.getLangHelper().getLanguageList()) {
                testData.setValue(locale, defaultValue, project);
            }
            cap.getDataManager().updateCell(testData, 0, paramName);
            ++n2;
        }
        return cap;
    }

    public static Component getComponent(ICapPO cap) {
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        String compType = cap.getComponentType();
        return compSystem.findComponent(compType);
    }

    public static Action getAction(ICapPO cap) {
        Component component = CapBP.getComponent(cap);
        return component.findAction(cap.getActionName());
    }

    public static void getCaps(INodePO nodePo, List<ICapPO> resultList) {
        if (nodePo instanceof ICapPO) {
            resultList.add((ICapPO)nodePo);
        } else {
            Iterator<INodePO> nodeListIterator = nodePo.getNodeListIterator();
            while (nodeListIterator.hasNext()) {
                INodePO currNodePo = nodeListIterator.next();
                CapBP.getCaps(currNodePo, resultList);
            }
        }
    }
}

