/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.businessprocess.AbstractNameBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.CheckIfComponentNameIsReusedOp;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.FindNodesForComponentNameOp;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IComponentNameData;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentNamesBP
extends AbstractNameBP<IComponentNamePO>
implements IComponentNameCache {
    public static final String UNKNOWN_COMPONENT_TYPE = "guidancer.abstract.Unknown";
    private static Logger log = LoggerFactory.getLogger(ComponentNamesBP.class);
    private static ComponentNamesBP instance = null;

    private ComponentNamesBP() {
    }

    public static final ComponentNamesBP getInstance() {
        if (instance == null) {
            instance = new ComponentNamesBP();
        }
        return instance;
    }

    public final void addComponentNamePO(IComponentNamePO compName) {
        this.addNamePO(compName);
    }

    public final void removeComponentNamePO(String guid) {
        this.removeNamePO(guid);
    }

    @Override
    public String getGuidForName(String name, Long parentProjectId) {
        for (IComponentNamePO compName : this.getAllNamePOs()) {
            if (!compName.getName().equals(name) || !parentProjectId.equals(compName.getParentProjectId())) continue;
            return compName.getGuid();
        }
        return null;
    }

    @Override
    public final String getName(String guid) {
        return this.getName(guid, GeneralStorage.getInstance().getProject().getId());
    }

    @Override
    public final String getName(String guid, Long rootProjId) {
        String name = guid;
        IComponentNamePO namePO = (IComponentNamePO)this.getNamePO(guid);
        if (namePO == null) {
            IProjectPO currProj = GeneralStorage.getInstance().getProject();
            try {
                namePO = this.getCompNamePoImpl(currProj.getGuid(), guid, null, currProj.getMajorProjectVersion(), currProj.getMinorProjectVersion(), currProj.getMicroProjectVersion(), currProj.getProjectVersionQualifier());
                this.addComponentNamePO(namePO);
            }
            catch (JBException e) {
                throw new JBFatalException((Throwable)e, MessageIDs.E_DATABASE_GENERAL);
            }
        }
        if (namePO != null) {
            if (namePO.getReferencedGuid() != null) {
                return this.getName(namePO.getReferencedGuid(), rootProjId);
            }
            name = namePO.getName();
        } else if (log.isDebugEnabled()) {
            log.debug(String.valueOf(Messages.EmptyComponentName) + " " + "=" + " " + rootProjId + " uniqueId = " + guid);
        }
        return name;
    }

    public final void init() throws PMException {
        this.clearAllNamePOs();
        IProjectPO currProject = GeneralStorage.getInstance().getProject();
        this.initCompNamesTransitive(currProject.getId(), new HashSet<Long>());
    }

    private void initCompNamesTransitive(Long projectID, Set<Long> loadedProjectIds) throws PMException {
        if (projectID == null) {
            return;
        }
        this.readCompNamesForProjectID(projectID);
        for (IReusedProjectPO usedProj : ProjectPM.getReusedProjectsForProject(projectID)) {
            String reusedGuid = usedProj.getProjectGuid();
            Integer reuseMajVers = usedProj.getMajorNumber();
            Integer reuseMinVers = usedProj.getMinorNumber();
            Integer reuseMicVers = usedProj.getMicroNumber();
            String reuseQualVers = usedProj.getVersionQualifier();
            try {
                Long usedProjPo = ProjectPM.findProjectIDByGuidAndVersion(reusedGuid, reuseMajVers, reuseMinVers, reuseMicVers, reuseQualVers);
                if (usedProjPo == null || !loadedProjectIds.add(usedProjPo)) continue;
                this.initCompNamesTransitive(usedProjPo, loadedProjectIds);
            }
            catch (JBException jBException) {}
        }
    }

    private void readCompNamesForProjectID(Long projId) throws PMException {
        List<IComponentNamePO> names = CompNamePM.readAllCompNames(projId);
        for (IComponentNamePO compNamePO : names) {
            this.addNamePO(compNamePO);
        }
    }

    public final void refreshNames(Long projId) throws PMException {
        this.readCompNamesForProjectID(projId);
    }

    public final Collection<IComponentNamePO> getAllComponentNamePOs() {
        return this.getAllNamePOs();
    }

    public final Collection<IComponentNamePO> getAllComponentNamePOs(Long projId) throws PMException {
        return CompNamePM.readAllCompNamesRO(projId);
    }

    public final Collection<IComponentNamePO> getAllNonRefCompNamePOs(Long projId) throws PMException {
        Collection<IComponentNamePO> allCompNamePOs = this.getAllComponentNamePOs(projId);
        CollectionUtils.filter(allCompNamePOs, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                if (object instanceof IComponentNamePO) {
                    return ((IComponentNamePO)object).getReferencedGuid() == null;
                }
                return false;
            }
        });
        return allCompNamePOs;
    }

    public final IComponentNamePO createComponentNamePO(String guid, String name, String type, CompNameCreationContext ctx) {
        String nameGuid = guid;
        if (guid == null) {
            nameGuid = PersistenceUtil.generateGuid();
        }
        IComponentNamePO newComponentNamePO = PoMaker.createComponentNamePO(nameGuid, name, type, ctx, GeneralStorage.getInstance().getProject().getId());
        this.addComponentNamePO(newComponentNamePO);
        return newComponentNamePO;
    }

    public final IComponentNamePO getCompNamePo(String compNameGuid, String compNameParentProjGuid) throws JBException {
        IProjectPO currProject = GeneralStorage.getInstance().getProject();
        String currGuid = currProject.getGuid();
        if (currGuid.equals(compNameParentProjGuid)) {
            return this.loadCompNamePoImpl(compNameGuid, currGuid, currProject.getMajorProjectVersion(), currProject.getMinorProjectVersion(), currProject.getMicroProjectVersion(), currProject.getProjectVersionQualifier());
        }
        return this.getCompNamePoImpl(currProject.getGuid(), compNameGuid, compNameParentProjGuid, currProject.getMajorProjectVersion(), currProject.getMinorProjectVersion(), currProject.getMicroProjectVersion(), currProject.getProjectVersionQualifier());
    }

    private IComponentNamePO getCompNamePoImpl(String projToSearchGuid, String compNameGuid, String compNameParentProjGuid, Integer projMajVers, Integer projMinVers, Integer projMicVers, String projVersQual) throws JBException {
        IComponentNamePO compNamePo;
        if (compNameParentProjGuid != null && (compNamePo = this.loadCompNamePoImpl(compNameGuid, compNameParentProjGuid, projMajVers, projMinVers, projMicVers, projVersQual)) != null) {
            return compNamePo;
        }
        List<IReusedProjectPO> reusedProjList = ProjectPM.loadReusedProjectsRO(projToSearchGuid, projMajVers, projMinVers, projMicVers, projVersQual);
        for (IReusedProjectPO reusedProj : reusedProjList) {
            Integer reusedMajVers = reusedProj.getMajorNumber();
            Integer reusedMinVers = reusedProj.getMinorNumber();
            Integer reusedMicVers = reusedProj.getMicroNumber();
            String reusedQualVers = reusedProj.getVersionQualifier();
            String reusedGuid = reusedProj.getProjectGuid();
            IComponentNamePO compNamePo2 = null;
            if (StringUtils.equals((String)compNameParentProjGuid, (String)reusedGuid) && (compNamePo2 = this.loadCompNamePoImpl(compNameGuid, reusedGuid, reusedMajVers, reusedMinVers, reusedMicVers, reusedQualVers)) != null) {
                return compNamePo2;
            }
            compNamePo2 = this.getCompNamePoImpl(reusedGuid, compNameGuid, reusedGuid, reusedMajVers, reusedMinVers, reusedMicVers, reusedQualVers);
            if (compNamePo2 == null) continue;
            return compNamePo2;
        }
        return null;
    }

    private IComponentNamePO loadCompNamePoImpl(String compNameGuid, String compNameParentProjGuid, Integer projMajVers, Integer projMinVers, Integer projMicVers, String projVersQual) throws JBException {
        IComponentNamePO compNamePO = null;
        Long projId = ProjectPM.findProjectId(compNameParentProjGuid, projMajVers, projMinVers, projMicVers, projVersQual);
        if (projId != null) {
            compNamePO = CompNamePM.loadCompName(compNameGuid, projId);
        }
        return compNamePO;
    }

    @Override
    public final IComponentNamePO getCompNamePo(String guid) {
        return this.getCompNamePo(guid, true);
    }

    @Override
    public final IComponentNamePO getCompNamePo(String guid, boolean resolveRefs) {
        IComponentNamePO compNamePO = (IComponentNamePO)this.getNamePO(guid);
        if (compNamePO != null) {
            if (resolveRefs && compNamePO.getReferencedGuid() != null) {
                return this.getCompNamePo(compNamePO.getReferencedGuid(), resolveRefs);
            }
            return compNamePO;
        }
        return null;
    }

    public final IComponentNamePO getCompNamePoByName(String name) {
        for (IComponentNamePO compNamePO : this.getAllComponentNamePOs()) {
            if (!name.equals(compNamePO.getName())) continue;
            return compNamePO;
        }
        return null;
    }

    public void updateType(String guid, String componentType) {
        IComponentNamePO compNamePo = this.getCompNamePo(guid);
        compNamePo.setComponentType(componentType);
    }

    public String computeComponentType(String componentName, Set<String> types) {
        Component mostConcreteComponent;
        if (types.contains(null) || types.contains("")) {
            return UNKNOWN_COMPONENT_TYPE;
        }
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        HashSet<Component> components = new HashSet<Component>();
        for (String compType : types) {
            Component comp = compSystem.findComponent(compType);
            comp = this.getMostConcreteVisibleAncestor(comp, compSystem);
            components.add(comp);
        }
        if (components.isEmpty()) {
            components.add(compSystem.getMostAbstractComponent());
        }
        if ((mostConcreteComponent = compSystem.getMostConcrete(components.toArray(new Component[components.size()]))) == null) {
            return null;
        }
        String compType = mostConcreteComponent.getType();
        if ((mostConcreteComponent = this.getMostConcreteVisibleAncestor(mostConcreteComponent, compSystem)) != null) {
            compType = mostConcreteComponent.getType();
        }
        return compType;
    }

    private Component getMostConcreteVisibleAncestor(Component component, CompSystem compSystem) {
        Component comp = component;
        while (comp != null && !comp.isVisible()) {
            Set realized = comp.getAllRealized();
            comp = compSystem.getMostConcrete(realized.toArray(new Component[realized.size()]));
        }
        return comp;
    }

    public String isCompatible(String originalCompType, String checkableName, IComponentNameMapper compNameMapper, Long projectId, boolean isSimpleMatch) {
        boolean currProj;
        IComponentNameCache compNameCache = compNameMapper.getCompNameCache();
        Set<IComponentNameData> componentNameDataSet = compNameCache.getComponentNameData();
        IComponentNameData compNameData = null;
        for (IComponentNameData cnd : componentNameDataSet) {
            if (projectId != null && cnd.getParentProjectId() != null && !cnd.getParentProjectId().equals(projectId) || !cnd.getName().equals(checkableName)) continue;
            compNameData = cnd;
            break;
        }
        if (compNameData == null) {
            return null;
        }
        Set<String> usedTypes = compNameMapper.getUsedTypes(compNameData.getGuid());
        String computedType = ComponentNamesBP.getInstance().computeComponentType(checkableName, usedTypes);
        Component originalComponent = this.getComponent(originalCompType);
        Component checkableComponent = this.getComponent(computedType);
        if (checkableComponent.isCompatibleWith(originalComponent.getType())) {
            return null;
        }
        if (isSimpleMatch) {
            return NLS.bind((String)Messages.CompNameIncompatibleTypeDetail, (Object[])new Object[]{checkableName, StringHelper.getInstance().get(checkableComponent.getType(), true), StringHelper.getInstance().get(originalComponent.getType(), true)});
        }
        String compNameGuid = compNameCache.getGuidForName(checkableName);
        IComponentNamePO namePO = compNameCache.getCompNamePo(compNameGuid);
        boolean bl = namePO == null ? false : (currProj = namePO.getParentProjectId() == null || GeneralStorage.getInstance().getProject().getId().equals(namePO.getParentProjectId()));
        if (currProj && originalComponent.isCompatibleWith(checkableComponent.getType())) {
            return null;
        }
        if (UNKNOWN_COMPONENT_TYPE.equals(computedType)) {
            return NLS.bind((String)Messages.CompNameUnknownTypeDetail, (Object)(namePO != null ? namePO.getName() : checkableName));
        }
        return NLS.bind((String)Messages.CompNameIncompatibleTypeDetail, (Object[])new Object[]{namePO != null ? namePO.getName() : checkableName, StringHelper.getInstance().get(checkableComponent.getType(), true), StringHelper.getInstance().get(originalComponent.getType(), true)});
    }

    public String isCompatible(String originalCompType, String checkableName, IComponentNameMapper compNameMapper, Long projectId) {
        return this.isCompatible(originalCompType, checkableName, compNameMapper, projectId, false);
    }

    private Component getComponent(String typeName) {
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        if (typeName == null) {
            return compSystem.getMostAbstractComponent();
        }
        return compSystem.findComponent(typeName);
    }

    public void setCompName(ICapPO capPo, String compName, CompNameCreationContext ctx, IWritableComponentNameMapper compMapper) throws IncompatibleTypeException, PMException {
        String oldName = capPo.getComponentName();
        String oldGuid = compMapper.getCompNameCache().getGuidForName(oldName);
        if (StringUtils.isBlank((String)compName)) {
            compMapper.changeReuse(capPo, oldGuid, null);
        } else {
            String guidToSet = compMapper.getCompNameCache().getGuidForName(compName, GeneralStorage.getInstance().getProject().getId());
            if (guidToSet == null) {
                IComponentNamePO newComponentNamePO = compMapper.getCompNameCache().createComponentNamePO(compName, capPo.getComponentType(), ctx);
                if (capPo.getParentProjectId() != null) {
                    newComponentNamePO.setParentProjectId(capPo.getParentProjectId());
                }
                guidToSet = newComponentNamePO.getGuid();
            }
            compMapper.changeReuse(capPo, oldGuid, guidToSet);
        }
    }

    @Override
    public void clear() {
        this.clearAllNamePOs();
    }

    @Override
    public Set<IComponentNameData> getComponentNameData() {
        HashSet<IComponentNameData> retVal = new HashSet<IComponentNameData>();
        retVal.addAll(this.getAllComponentNamePOs());
        return retVal;
    }

    @Override
    public Set<IComponentNameData> getLocalComponentNameData() {
        return Collections.emptySet();
    }

    @Override
    public void updateStandardMapperAndCleanup(Long activeProjectId) {
    }

    public boolean isCompNameReused(Collection<ISpecPersistable> specsToSearch, Collection<ITestSuitePO> suitesToSearch, Collection<IAUTMainPO> autsToSearch, String compNameGuid) {
        return !this.findAssocsOfReuse(autsToSearch, compNameGuid).isEmpty() || this.isCompNameReused(specsToSearch, suitesToSearch, compNameGuid);
    }

    public boolean isCompNameReused(Collection<ISpecPersistable> specsToSearch, Collection<ITestSuitePO> suitesToSearch, String compNameGuid) {
        TreeTraverser traverser;
        CheckIfComponentNameIsReusedOp op;
        for (ISpecPersistable node : specsToSearch) {
            op = new CheckIfComponentNameIsReusedOp(compNameGuid);
            traverser = new TreeTraverser(node, op);
            traverser.traverse(true);
            if (!op.hasFoundReuse()) continue;
            return true;
        }
        for (ITestSuitePO ts : suitesToSearch) {
            op = new CheckIfComponentNameIsReusedOp(compNameGuid);
            traverser = new TreeTraverser(ts, op);
            traverser.traverse(true);
            if (!op.hasFoundReuse()) continue;
            return true;
        }
        return false;
    }

    public Set<INodePO> findNodesOfReuse(Collection<ISpecPersistable> specsToSearch, Collection<ITestSuitePO> suitesToSearch, String compNameGuid, IProgressMonitor monitor) {
        TreeTraverser traverser;
        FindNodesForComponentNameOp op;
        HashSet<INodePO> reuse = new HashSet<INodePO>();
        monitor.beginTask(Messages.ShowWhereUsedSearching, specsToSearch.size() + suitesToSearch.size());
        for (ISpecPersistable node : specsToSearch) {
            op = new FindNodesForComponentNameOp(compNameGuid);
            traverser = new TreeTraverser(node, op);
            traverser.traverse(true);
            reuse.addAll(op.getNodes());
            monitor.worked(1);
        }
        for (ITestSuitePO ts : suitesToSearch) {
            op = new FindNodesForComponentNameOp(compNameGuid);
            traverser = new TreeTraverser(ts, op);
            traverser.traverse(true);
            reuse.addAll(op.getNodes());
            monitor.worked(1);
        }
        return reuse;
    }

    public Set<IObjectMappingAssoziationPO> findAssocsOfReuse(Collection<IAUTMainPO> autsToSearch, String compNameGuid) {
        HashSet<IObjectMappingAssoziationPO> reuse = new HashSet<IObjectMappingAssoziationPO>();
        for (IAUTMainPO aut : autsToSearch) {
            for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                if (assoc.getTechnicalName() == null || !assoc.getLogicalNames().contains(compNameGuid)) continue;
                reuse.add(assoc);
            }
        }
        return reuse;
    }

    public static void handleFirstReference(EntityManager sess, IComponentNamePO refCompName, boolean isReferencedByThisAction) throws PMDirtyVersionException, PMObjectDeletedException, PMAlreadyLockedException {
        IComponentNamePO name = refCompName;
        if (name.getId() != null) {
            int minSize = 0;
            if (isReferencedByThisAction) {
                minSize = 1;
            }
            if (CompNamePM.getNumReuseInstances(sess, GeneralStorage.getInstance().getProject().getId(), name.getGuid()) <= minSize) {
                EntityManager lockSession = sess;
                try {
                    lockSession.detach((Object)refCompName);
                    name = (IComponentNamePO)lockSession.find(name.getClass(), (Object)name.getId());
                }
                catch (PersistenceException he) {
                    log.error(String.valueOf(Messages.StrayPersistenceException) + "." + ".", (Throwable)he);
                }
                if (!LockManager.instance().lockPO(lockSession, name, false)) {
                    throw new PMAlreadyLockedException(name, String.valueOf(Messages.OrginalTestcaseLocked) + ".", MessageIDs.E_OBJECT_IN_USE);
                }
            }
        }
    }

    public static enum CompNameCreationContext {
        OBJECT_MAPPING,
        OVERRIDDEN_NAME,
        STEP;

        private static final String OBJECT_MAPPING_CTX = "OBJECT_MAPPING";
        private static final String OVERRIDDEN_NAME_CTX = "OVERRIDDEN_NAME";
        private static final String STEP_CTX = "STEP";

        public String toString() {
            switch (this) {
                case OBJECT_MAPPING: {
                    return OBJECT_MAPPING_CTX;
                }
                case OVERRIDDEN_NAME: {
                    return OVERRIDDEN_NAME_CTX;
                }
                case STEP: {
                    return STEP_CTX;
                }
            }
            Assert.notReached((String)"Missing toString representation for CompNameCreationContext");
            return "";
        }

        public static CompNameCreationContext forName(String name) {
            if (OBJECT_MAPPING_CTX.equalsIgnoreCase(name)) {
                return OBJECT_MAPPING;
            }
            if (OVERRIDDEN_NAME_CTX.equalsIgnoreCase(name)) {
                return OVERRIDDEN_NAME;
            }
            if (STEP_CTX.equalsIgnoreCase(name)) {
                return STEP;
            }
            Assert.notReached((String)("No CompNameCreationContext for '" + String.valueOf(name) + "'"));
            return null;
        }
    }
}

