/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TestDataCubePM;

public class TestDataCubeBP {
    private TestDataCubeBP() {
    }

    public static IParameterInterfacePO getTestDataCubeByName(String cubeName, IProjectPO containingProject) {
        Validate.notNull((Object)cubeName);
        Validate.notNull((Object)containingProject);
        ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor(containingProject);
        int n = iTestDataCubePOArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestDataCubePO testDataCube = iTestDataCubePOArray[n2];
            if (cubeName.equals(testDataCube.getName())) {
                return testDataCube;
            }
            ++n2;
        }
        return null;
    }

    public static ITestDataCubePO[] getAllTestDataCubesFor(IProjectPO project) {
        if (project == null) {
            return new ITestDataCubePO[0];
        }
        HashSet<ITestDataCubePO> dataCollection = new HashSet<ITestDataCubePO>();
        TestDataCubeBP.getAllTestDataCubesFor(project.getTestDataCubeCont(), dataCollection);
        return dataCollection.toArray(new ITestDataCubePO[dataCollection.size()]);
    }

    private static void getAllTestDataCubesFor(ITestDataCategoryPO category, Set<ITestDataCubePO> dataCollection) {
        if (category != null) {
            for (ITestDataCubePO testData : category.getTestDataChildren()) {
                dataCollection.add(testData);
            }
            for (ITestDataCategoryPO subCategory : category.getCategoryChildren()) {
                TestDataCubeBP.getAllTestDataCubesFor(subCategory, dataCollection);
            }
        }
    }

    public static boolean isCubeReused(IParameterInterfacePO pio) {
        GeneralStorage gs = GeneralStorage.getInstance();
        return TestDataCubePM.computeReuser(pio, gs.getMasterSession()).size() > 0;
    }

    public static List<IParamNodePO> getReuser(IParameterInterfacePO pio) {
        GeneralStorage gs = GeneralStorage.getInstance();
        IProjectPO proj = gs.getProject();
        return TestDataCubePM.computeParamNodeReuser(pio, gs.getMasterSession(), proj);
    }
}

