/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.importfilter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.eclipse.jubula.client.core.businessprocess.importfilter.DataTable;
import org.eclipse.jubula.client.core.businessprocess.importfilter.IDataImportFilter;
import org.eclipse.jubula.client.core.businessprocess.importfilter.exceptions.DataReadException;
import org.eclipse.jubula.client.core.businessprocess.importfilter.exceptions.NoSupportForLocaleException;

public class ExcelImportFilter
implements IDataImportFilter {
    private static String[] fileExtensions = new String[]{"xls"};

    @Override
    public String[] getFileExtensions() {
        return fileExtensions;
    }

    /*
     * Handled impossible loop by duplicating code
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataTable parse(File dataDir, String file, Locale locale) throws IOException, NoSupportForLocaleException, DataReadException {
        DataTable filledDataTable;
        block15: {
            block14: {
                FileInputStream inStream = this.findDataFile(dataDir, file);
                POIFSFileSystem fs = new POIFSFileSystem((InputStream)inStream);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                int index = wb.getSheetIndex(locale.toString());
                if (index == -1) {
                    throw new NoSupportForLocaleException();
                }
                HSSFSheet sheet = wb.getSheetAt(index);
                int lastRowNum = sheet.getLastRowNum();
                int firstRowNum = sheet.getFirstRowNum();
                if (sheet.getRow(firstRowNum) == null) {
                    DataTable dataTable = new DataTable(0, 0);
                    return dataTable;
                }
                int height = lastRowNum - firstRowNum + 1;
                int width = sheet.getRow(firstRowNum).getLastCellNum() - sheet.getRow(firstRowNum).getFirstCellNum();
                filledDataTable = new DataTable(height, width);
                int rowNum = firstRowNum;
                while (rowNum <= lastRowNum) {
                    int firstCellNum;
                    HSSFRow row = sheet.getRow(rowNum);
                    short lastCellNum = row.getLastCellNum();
                    int cellNr = firstCellNum = row.getFirstCellNum();
                    while (cellNr < lastCellNum) {
                        HSSFCell cell = row.getCell(cellNr);
                        String cellString = this.getExcelCellString(cell);
                        filledDataTable.updateDataEntry(rowNum, cellNr, cellString);
                        ++cellNr;
                    }
                    ++rowNum;
                }
                if (!true) break block14;
                if (filledDataTable.getColumnCount() <= 0) return filledDataTable;
                if (!StringUtils.isBlank((String)filledDataTable.getData(0, filledDataTable.getColumnCount() - 1))) break block15;
                {
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Throwable t) {}
                    throw new DataReadException(t);
                }
                finally {
                    inStream.close();
                }
            }
            do {
                int newHeight = filledDataTable.getRowCount();
                int newWidth = filledDataTable.getColumnCount() - 1;
                DataTable cleanedFilledDataTable = new DataTable(newHeight, newWidth);
                int i = 0;
                while (i < newHeight) {
                    int j = 0;
                    while (j < newWidth) {
                        cleanedFilledDataTable.updateDataEntry(i, j, filledDataTable.getData(i, j));
                        ++j;
                    }
                    ++i;
                }
                filledDataTable = cleanedFilledDataTable;
                if (filledDataTable.getColumnCount() <= 0) return filledDataTable;
            } while (StringUtils.isBlank((String)filledDataTable.getData(0, filledDataTable.getColumnCount() - 1)));
        }
        return filledDataTable;
    }

    private FileInputStream findDataFile(File dataDir, String file) throws FileNotFoundException {
        File dataFile = new File(file);
        File infile = dataFile.isAbsolute() ? dataFile : new File(dataDir, file);
        return new FileInputStream(infile);
    }

    private String getExcelCellString(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        int type = cell.getCellType();
        switch (type) {
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 0: {
                return this.getDoubleString(cell.getNumericCellValue());
            }
            case 2: {
                switch (cell.getCachedFormulaResultType()) {
                    case 1: {
                        return cell.getRichStringCellValue().getString();
                    }
                    case 0: {
                        return this.getDoubleString(cell.getNumericCellValue());
                    }
                }
            }
        }
        return null;
    }

    private String getDoubleString(double value) {
        if ((double)Math.round(value) - value == 0.0) {
            return String.valueOf(Math.round(value));
        }
        return String.valueOf(value);
    }
}

