/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.List;
import javax.persistence.Basic;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.TestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.FindNodeParentOperation;
import org.eclipse.jubula.client.core.utils.SpecTreeTraverser;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DiscriminatorValue(value="S")
class SpecTestCasePO
extends TestCasePO
implements ISpecTestCasePO,
PersistenceWeaved,
PersistenceObject {
    private static final Logger LOG = LoggerFactory.getLogger(SpecTestCasePO.class);
    private Boolean m_isInterfaceLocked = false;
    static final long serialVersionUID = -8240605696406410613L;

    SpecTestCasePO() {
    }

    SpecTestCasePO(String testCaseName, boolean isGenerated) {
        super(testCaseName, isGenerated);
        this.addTrackedChange("created", false);
    }

    SpecTestCasePO(String testCaseName, String guid, boolean isGenerated) {
        super(testCaseName, guid, isGenerated);
    }

    @Override
    public IParamDescriptionPO addParameter(String type, String name, String guid, IParamNameMapper mapper) {
        Validate.notEmpty((String)type, (String)(String.valueOf(Messages.MissingParameterTypeForTestcase) + " " + this.getName()));
        Validate.notEmpty((String)name, (String)(String.valueOf(Messages.MissingNameForParameterInTestcase) + this.getName()));
        IParamDescriptionPO desc = PoMaker.createTcParamDescriptionPO(type, name, guid, mapper);
        super.addParameter(desc);
        return desc;
    }

    @Override
    public IParamDescriptionPO addParameter(String type, String name, boolean always, IParamNameMapper mapper) {
        IParamDescriptionPO desc = null;
        if (always || this.getParameterForName(name) == null) {
            desc = this.addParameter(type, name, mapper);
        }
        return desc;
    }

    @Override
    public void removeParameter(String uniqueId) {
        IParamDescriptionPO desc = this.getParameterForUniqueId(uniqueId);
        if (desc != null) {
            this.removeParameter(desc);
            ((TcParamDescriptionPO)desc).getParamNameMapper().removeParamNamePO(desc.getUniqueId());
        }
    }

    @Override
    public final void moveParameter(String guId, int index) {
        IParamDescriptionPO parameter = this.getParameterForUniqueId(guId);
        List<IParamDescriptionPO> paramList = this.getHbmParameterList();
        int currIdx = paramList.indexOf(parameter);
        paramList.remove(currIdx);
        paramList.add(index, parameter);
    }

    @Override
    @Transient
    public INodePO getParentNode() {
        INodePO parent = super.getParentNode();
        if (parent == null) {
            try {
                parent = ProjectPM.loadProjectById(this.getParentProjectId(), GeneralStorage.getInstance().getMasterSession());
                FindNodeParentOperation op = new FindNodeParentOperation(this);
                SpecTreeTraverser traverser = new SpecTreeTraverser(parent, op);
                traverser.traverse(true);
                if (op.getParent() != null) {
                    parent = op.getParent();
                    this.setParentNode(parent);
                }
            }
            catch (JBException e) {
                StringBuilder msg = new StringBuilder();
                msg.append(Messages.CouldNotFindParentForTestCase);
                msg.append(":");
                msg.append(" ");
                msg.append(this);
                msg.append(";");
                msg.append(" ");
                msg.append(Messages.ReturningNull);
                msg.append(".");
                LOG.error(msg.toString(), (Throwable)e);
            }
        }
        return parent;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ISpecTestCasePO) {
            ISpecTestCasePO otherSpecTC = (ISpecTestCasePO)obj;
            return this.getGuid().equals(otherSpecTC.getGuid());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getGuid().hashCode();
    }

    @Override
    @Basic
    public Boolean isInterfaceLocked() {
        return this.m_isInterfaceLocked;
    }

    @Override
    public void setInterfaceLocked(Boolean isInterfaceLocked) {
        this.m_isInterfaceLocked = isInterfaceLocked;
    }

    @Override
    public IParamDescriptionPO addParameter(String type, String name, IParamNameMapper mapper) {
        Validate.notEmpty((String)type, (String)(String.valueOf(Messages.MissingParameterTypeForTestcase) + " " + this.getName()));
        Validate.notEmpty((String)name, (String)(String.valueOf(Messages.MissingNameForParameterInTestcase) + this.getName()));
        IParamDescriptionPO desc = PoMaker.createTcParamDescriptionPO(type, name, PersistenceUtil.generateGuid(), mapper);
        super.addParameter(desc);
        return desc;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SpecTestCasePO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "interfaceLocked") {
            return this.interfaceLocked;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "interfaceLocked") {
            this.interfaceLocked = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

