/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.actions.CutTreeItemActionJBEditor;
import org.eclipse.jubula.client.ui.rcp.actions.PasteTreeItemActionTCEditor;
import org.eclipse.jubula.client.ui.rcp.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.rcp.controllers.AbstractPartListener;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.rcp.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.client.ui.rcp.utils.UIIdentitiyElementComparer;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.services.IEvaluationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJBEditor
extends EditorPart
implements IJBEditor,
ISelectionProvider,
ITreeViewerContainer,
IJBPart,
DataEventDispatcher.IPropertyChangedListener {
    public static final String ADD_ID = "org.eclipse.ui.AddSubMenu";
    public static final String REFACTOR_ID = "org.eclipse.ui.RefactorSubMenu";
    public static final String BLANK = " ";
    protected static final String ADD = "_ADD";
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractJBEditor.class);
    private List<ISelectionChangedListener> m_selectionChangedListenerList = new ArrayList<ISelectionChangedListener>();
    private TreeViewer m_mainTreeViewer;
    private Composite m_parentComposite;
    private JBEditorHelper m_editorHelper;
    private Control m_control;
    private CutTreeItemActionJBEditor m_cutTreeItemAction = new CutTreeItemActionJBEditor();
    private PasteTreeItemActionTCEditor m_pasteTreeItemAction = new PasteTreeItemActionTCEditor();
    private PartListener m_partListener = new PartListener();

    protected void createMainPart(Composite parent) {
        this.setMainTreeViewer(new TreeViewer(parent));
        DecoratingLabelProvider lp = new DecoratingLabelProvider((ILabelProvider)new GeneralLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.getMainTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
        this.getMainTreeViewer().setUseHashlookup(true);
        this.getMainTreeViewer().setComparer((IElementComparer)new UIIdentitiyElementComparer());
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.firePropertyChange(258);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == this.getClass()) {
            return this;
        }
        if (adapter == NodeEditorInput.class) {
            return this.getEditorInput();
        }
        Object superAdapter = super.getAdapter(adapter);
        if (superAdapter != null) {
            return superAdapter;
        }
        return this.getEditorHelper().getAdapter(adapter);
    }

    protected void setParentComposite(Composite parentComposite) {
        this.m_parentComposite = parentComposite;
    }

    @Override
    public Composite getParentComposite() {
        return this.m_parentComposite;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.getSelectionChangedListenerList().contains(listener)) {
            this.getSelectionChangedListenerList().add(listener);
        }
    }

    public ISelection getSelection() {
        if (this.getMainTreeViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.getMainTreeViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionChangedListenerList().remove(listener);
    }

    public void setSelection(ISelection selection) {
        Object firstElement;
        ISelection newSelection = this.getMainTreeViewer().getSelection();
        if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof INodePO) {
            INodePO node = (INodePO)firstElement;
            IPersistentObject editorRoot = this.getWorkVersion();
            if (editorRoot.getId().equals(node.getId())) {
                newSelection = new StructuredSelection((Object)editorRoot);
            } else {
                Iterator<? extends INodePO> nodeListIterator = this.getIteratorForNode(node);
                while (nodeListIterator.hasNext()) {
                    INodePO child = nodeListIterator.next();
                    if (!node.getGuid().equals(child.getGuid())) continue;
                    newSelection = new StructuredSelection((Object)child);
                    break;
                }
            }
        }
        this.setSelectionImpl(newSelection);
    }

    protected IPersistentObject getWorkVersion() {
        return this.getEditorHelper().getEditSupport().getWorkVersion();
    }

    protected Iterator<? extends INodePO> getIteratorForNode(INodePO node) {
        return ((INodePO)this.getWorkVersion()).getNodeListIterator();
    }

    protected void setSelectionImpl(ISelection selection) {
        UINodeBP.setFocusAndSelection(selection, this.getMainTreeViewer());
    }

    protected void setMainTreeViewer(TreeViewer mainTreeViewer) {
        this.m_mainTreeViewer = mainTreeViewer;
    }

    protected TreeViewer getMainTreeViewer() {
        return this.m_mainTreeViewer;
    }

    protected void setSelectionChangedListenerList(List<ISelectionChangedListener> selectionChangedListenerList) {
        this.m_selectionChangedListenerList = selectionChangedListenerList;
    }

    protected List<ISelectionChangedListener> getSelectionChangedListenerList() {
        return this.m_selectionChangedListenerList;
    }

    public TreeViewer getTreeViewer() {
        return this.getMainTreeViewer();
    }

    public void handlePropertyChanged(boolean isCompNameChanged) {
        this.createPartName();
        this.getTreeViewer().refresh();
    }

    protected void createPartName() {
        String nodeName = this.getWorkVersion().getName();
        if (nodeName == null) {
            nodeName = "";
        }
        this.setPartName(String.valueOf(this.getEditorPrefix()) + nodeName);
    }

    protected abstract void setHelp(Composite var1);

    public final void createPartControl(Composite parent) {
        if (this.getEditorHelper() == null) {
            this.setEditorHelper(new JBEditorHelper(this));
        }
        this.checkMasterSessionUpToDate();
        this.createPartName();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.getEditorSite().getPage().addPartListener((IPartListener)this.m_partListener);
        this.setHelp(parent);
        this.createPartControlImpl(parent);
        this.createContextMenu();
        this.addInternalSelectionListeners(new EditorSelectionChangedListener());
    }

    protected abstract void createPartControlImpl(Composite var1);

    protected void addInternalSelectionListeners(ISelectionChangedListener editorSelectionChangedListener) {
        this.getMainTreeViewer().addSelectionChangedListener(editorSelectionChangedListener);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.getEditorHelper() == null) {
            this.setEditorHelper(new JBEditorHelper(this));
        }
        this.getEditorHelper().init(site, input);
    }

    @Override
    public void reOpenEditor(IPersistentObject node) throws PMException {
        ISelection previousSelection = this.getSelection();
        this.getEditorHelper().setDirty(false);
        this.getEditorHelper().getEditSupport().reloadEditSession();
        ((PersistableEditorInput)this.getEditorInput()).refreshNode();
        try {
            this.init(this.getEditorSite(), this.getEditorInput());
            this.setInitialInput();
            this.setSelection(previousSelection);
        }
        catch (PartInitException partInitException) {
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        }
    }

    protected abstract void setInitialInput();

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void initTextAndInput(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.createPartName();
        this.getEditorSite().getActionBars().getMenuManager();
    }

    @Override
    public void fireDirtyProperty(boolean isDirty) {
        this.firePropertyChange(257);
        if (!isDirty) {
            this.firePropertyChange(258);
        }
    }

    public void setFocus() {
        this.getTreeViewer().getTree().setFocus();
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.getEditorHelper().isDirty();
    }

    protected abstract void fillContextMenu(IMenuManager var1);

    protected Menu createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractJBEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.getMainTreeViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        return menu;
    }

    protected void handlePMCompNameException(IncompatibleTypeException pmce) {
        ErrorHandlingUtil.createMessageDialog((Integer)pmce.getErrorId(), (Object[])pmce.getErrorMessageParams(), null);
        try {
            ComponentNamesBP.getInstance().init();
        }
        catch (PMException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
        }
    }

    public void dispose() {
        try {
            DataEventDispatcher ded = DataEventDispatcher.getInstance();
            ded.removePropertyChangedListener((DataEventDispatcher.IPropertyChangedListener)this);
            if (this.getEditorSite() != null && this.getEditorSite().getPage() != null) {
                GuiEventDispatcher.getInstance().removeEditorDirtyStateListener(this);
            }
            if (this.getSite() != null) {
                this.getSite().setSelectionProvider(null);
            }
            if (this.getEditorSite() != null && this.getEditorSite().getPage() != null) {
                this.getEditorSite().getPage().removePartListener((IPartListener)this.m_partListener);
            }
            if (this.getEditorHelper() != null) {
                this.getEditorHelper().dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    protected void checkMasterSessionUpToDate() {
    }

    protected void addDoubleClickListener(final String commandId, StructuredViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommandHelper.executeCommand((String)commandId, (IWorkbenchPartSite)AbstractJBEditor.this.getSite());
            }
        });
    }

    protected void setEditorHelper(JBEditorHelper editorHelper) {
        this.m_editorHelper = editorHelper;
    }

    @Override
    public JBEditorHelper getEditorHelper() {
        return this.m_editorHelper;
    }

    protected void setControl(Control control) {
        this.m_control = control;
    }

    private Control getControl() {
        return this.m_control;
    }

    protected void setCutTreeItemAction(CutTreeItemActionJBEditor cutTreeItemAction) {
        this.m_cutTreeItemAction = cutTreeItemAction;
    }

    protected CutTreeItemActionJBEditor getCutTreeItemAction() {
        return this.m_cutTreeItemAction;
    }

    protected void setPasteTreeItemAction(PasteTreeItemActionTCEditor pasteTreeItemAction) {
        this.m_pasteTreeItemAction = pasteTreeItemAction;
    }

    protected PasteTreeItemActionTCEditor getPasteTreeItemAction() {
        return this.m_pasteTreeItemAction;
    }

    protected void setActionHandlers() {
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.getCutTreeItemAction());
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.getPasteTreeItemAction());
        this.getEditorSite().getActionBars().updateActionBars();
    }

    @Override
    public void handleEditorDirtyStateChanged(IJBEditor gdEditor, boolean isDirty) {
        if (gdEditor == this) {
            IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
            service.requestEvaluation("org.eclipse.jubula.client.ui.rcp.propertytester.EditorPart.isDirty");
        }
    }

    public EntityManager getEntityManager() {
        return this.getEditorHelper().getEditSupport().getSession();
    }

    public void refresh() {
        this.getTreeViewer().refresh(true);
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Iterator<ISelectionChangedListener> iter = AbstractJBEditor.this.getSelectionChangedListenerList().iterator();
            SelectionChangedEvent selChangedEvent = new SelectionChangedEvent((ISelectionProvider)AbstractJBEditor.this, event.getSelection());
            while (iter.hasNext()) {
                ISelectionChangedListener listener = iter.next();
                listener.selectionChanged(selChangedEvent);
            }
        }
    }

    private class PartListener
    extends AbstractPartListener {
        private PartListener() {
        }

        @Override
        public void partActivated(IWorkbenchPart part) {
            if (part == AbstractJBEditor.this) {
                AbstractJBEditor.this.setActionHandlers();
            }
            super.partActivated(part);
        }
    }
}

