/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.TreeOpsBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractRefactorHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExtractTestCaseHandler
extends AbstractRefactorHandler {
    public Object executeImpl(ExecutionEvent event) {
        AbstractTestCaseEditor editor = (AbstractTestCaseEditor)HandlerUtil.getActivePart((ExecutionEvent)event);
        String newTestCaseName = this.getNewTestCaseName(event);
        if (newTestCaseName == null) {
            return null;
        }
        INodePO node = (INodePO)editor.getEditorHelper().getEditSupport().getOriginal();
        if (node != null) {
            this.validateNode(node);
            IStructuredSelection selection = this.getSelection();
            ExtractionReturn extractRet = this.performExtraction(newTestCaseName, node, selection);
            if (extractRet.getErrorMessage() != null) {
                ErrorHandlingUtil.createMessageDialog((JBException)new JBException(extractRet.getErrorMessage(), MessageIDs.E_UNEXPECTED_EXCEPTION), null, (String[])new String[]{extractRet.getErrorMessage()});
            }
            try {
                editor.reOpenEditor((IPersistentObject)node);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForEditor(e, editor);
            }
        } else {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(Messages.EditorWillBeClosed, MessageIDs.E_DELETED_TC), null, null);
            try {
                GeneralStorage.getInstance().reloadMasterSession((IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
            }
        }
        return null;
    }

    private void validateNode(INodePO node) {
        Assert.verify((node instanceof ISpecTestCasePO || node instanceof ITestSuitePO ? 1 : 0) != 0, (String)Messages.ExtractTestCaseOperateISpecTestCasePO);
    }

    private ExtractionReturn performExtraction(String newTcName, INodePO node, IStructuredSelection selection) {
        ArrayList<IParamNodePO> modNodes = new ArrayList<IParamNodePO>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            modNodes.add((IParamNodePO)it.next());
        }
        try {
            ExtractionReturn extractionRet = this.persistExtraction(node, newTcName, modNodes);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)extractionRet.getExecTestCasePO(), DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
            ISpecTestCasePO newSpecTc = extractionRet.getExecTestCasePO().getSpecTestCase();
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newSpecTc, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
            TestCaseBrowser tcb = MultipleTCBTracker.getInstance().getMainTCB();
            if (tcb != null) {
                tcb.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newSpecTc), true);
            }
            return extractionRet;
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        return new ExtractionReturn();
    }

    private ExtractionReturn persistExtraction(final INodePO ownerNode, final String newTcName, final List<IParamNodePO> modNodes) throws PMException, ProjectDeletedException {
        final ExtractionReturn extractionRet = new ExtractionReturn();
        final ParamNameBPDecorator mapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
        TransactionSupport.ITransactAction op = new TransactionSupport.ITransactAction(){

            public void run(EntityManager s) throws PMException, ProjectDeletedException {
                IExecTestCasePO obj = null;
                try {
                    Persistor.instance().refreshPO(s, (IPersistentObject)ownerNode, LockModeType.PESSIMISTIC_WRITE);
                    ArrayList<IParamNodePO> nodesToRef = new ArrayList<IParamNodePO>();
                    this.getModNodesFromCurrentSession(s, nodesToRef);
                    IExecTestCasePO newExecTc = TreeOpsBP.extractTestCase((String)newTcName, (INodePO)ownerNode, nodesToRef, (EntityManager)s, (ParamNameBPDecorator)mapper);
                    extractionRet.setExecTestCasePO(newExecTc);
                    obj = newExecTc;
                    s.persist((Object)newExecTc);
                    ISpecTestCasePO newSpecTc = newExecTc.getSpecTestCase();
                    ExtractTestCaseHandler.registerParamNamesToSave(newSpecTc, mapper);
                    obj = newSpecTc;
                    s.merge((Object)newSpecTc);
                    mapper.persist(s, GeneralStorage.getInstance().getProject().getId());
                }
                catch (TreeOpsBP.TreeOpFailedException e) {
                    ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
                }
                catch (PersistenceException e) {
                    PersistenceManager.handleDBExceptionForMasterSession(obj, (PersistenceException)e);
                }
            }

            private void getModNodesFromCurrentSession(EntityManager s, List<IParamNodePO> nodesToRef) {
                for (IParamNodePO node : modNodes) {
                    IParamNodePO object = (IParamNodePO)s.find(node.getClass(), (Object)node.getId());
                    if (object == null) continue;
                    nodesToRef.add(object);
                }
            }
        };
        new TransactionSupport().transact(op);
        mapper.updateStandardMapperAndCleanup(ownerNode.getParentProjectId());
        return extractionRet;
    }

    private static class ExtractionReturn {
        private String m_errorMessage = null;
        private IExecTestCasePO m_execTestCasePO = null;

        private ExtractionReturn() {
        }

        public String getErrorMessage() {
            return this.m_errorMessage;
        }

        public IExecTestCasePO getExecTestCasePO() {
            return this.m_execTestCasePO;
        }

        public void setExecTestCasePO(IExecTestCasePO execTestCasePO) {
            this.m_execTestCasePO = execTestCasePO;
        }
    }
}

