/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class DecoratingCellLabelProvider
extends CellLabelProvider
implements ILabelProvider,
IViewerLabelProvider,
IColorProvider,
IFontProvider,
ITreePathLabelProvider {
    private ILabelProvider m_provider;
    private ILabelDecorator m_decorator;
    private ListenerList m_listeners = new ListenerList();
    private IDecorationContext m_decorationContext;

    public DecoratingCellLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
        Assert.isNotNull((Object)provider);
        this.m_provider = provider;
        this.m_decorator = decorator;
        this.m_decorationContext = this.createDefaultDecorationContext();
    }

    private IDecorationContext createDefaultDecorationContext() {
        return new DecorationContext();
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.m_provider.addListener(listener);
        if (this.m_decorator != null) {
            this.m_decorator.addListener(listener);
        }
        this.m_listeners.add((Object)listener);
    }

    public void dispose() {
        this.m_provider.dispose();
        if (this.m_decorator != null) {
            this.m_decorator.dispose();
        }
    }

    public Image getImage(Object element) {
        Image image = this.m_provider.getImage(element);
        if (this.m_decorator != null) {
            if (this.m_decorator instanceof LabelDecorator) {
                LabelDecorator ld2 = (LabelDecorator)this.m_decorator;
                Image decorated = ld2.decorateImage(image, element, this.getDecorationContext());
                if (decorated != null) {
                    return decorated;
                }
            } else {
                Image decorated = this.m_decorator.decorateImage(image, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return image;
    }

    public ILabelDecorator getLabelDecorator() {
        return this.m_decorator;
    }

    public ILabelProvider getLabelProvider() {
        return this.m_provider;
    }

    public String getText(Object element) {
        String text = this.m_provider.getText(element);
        if (this.m_decorator != null) {
            if (this.m_decorator instanceof LabelDecorator) {
                LabelDecorator ld2 = (LabelDecorator)this.m_decorator;
                String decorated = ld2.decorateText(text, element, this.getDecorationContext());
                if (decorated != null) {
                    return decorated;
                }
            } else {
                String decorated = this.m_decorator.decorateText(text, element);
                if (decorated != null) {
                    return decorated;
                }
            }
        }
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (this.m_provider.isLabelProperty(element, property)) {
            return true;
        }
        return this.m_decorator != null && this.m_decorator.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.m_provider.removeListener(listener);
        if (this.m_decorator != null) {
            this.m_decorator.removeListener(listener);
        }
        this.m_listeners.remove((Object)listener);
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
        ILabelDecorator oldDecorator = this.m_decorator;
        if (oldDecorator != decorator) {
            int i;
            Object[] listenerList = this.m_listeners.getListeners();
            if (oldDecorator != null) {
                i = 0;
                while (i < listenerList.length) {
                    oldDecorator.removeListener((ILabelProviderListener)listenerList[i]);
                    ++i;
                }
            }
            this.m_decorator = decorator;
            if (decorator != null) {
                i = 0;
                while (i < listenerList.length) {
                    decorator.addListener((ILabelProviderListener)listenerList[i]);
                    ++i;
                }
            }
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void updateLabel(ViewerLabel settings, Object element) {
        IDelayedLabelDecorator delayedDecorator;
        ILabelDecorator currentDecorator = this.getLabelDecorator();
        String oldText = settings.getText();
        boolean decorationReady = true;
        if (currentDecorator instanceof IDelayedLabelDecorator && !(delayedDecorator = (IDelayedLabelDecorator)currentDecorator).prepareDecoration(element, oldText)) {
            decorationReady = false;
        }
        if (decorationReady || oldText == null || settings.getText().length() == 0) {
            settings.setText(this.getText(element));
        }
        Image oldImage = settings.getImage();
        if (decorationReady || oldImage == null) {
            settings.setImage(this.getImage(element));
        }
        if (decorationReady) {
            this.updateForDecorationReady(settings, element);
        }
    }

    protected void updateForDecorationReady(ViewerLabel settings, Object element) {
        Font font;
        if (this.m_decorator instanceof IColorDecorator) {
            IColorDecorator colorDecorator = (IColorDecorator)this.m_decorator;
            Color color = colorDecorator.decorateBackground(element);
            if (color != null) {
                settings.setBackground(color);
            }
            if ((color = colorDecorator.decorateForeground(element)) != null) {
                settings.setForeground(color);
            }
        }
        if (this.m_decorator instanceof IFontDecorator && (font = ((IFontDecorator)this.m_decorator).decorateFont(element)) != null) {
            settings.setFont(font);
        }
    }

    public Color getBackground(Object element) {
        if (this.m_provider instanceof IColorProvider) {
            return ((IColorProvider)this.m_provider).getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element) {
        if (this.m_provider instanceof IFontProvider) {
            return ((IFontProvider)this.m_provider).getFont(element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (this.m_provider instanceof IColorProvider) {
            return ((IColorProvider)this.m_provider).getForeground(element);
        }
        return null;
    }

    public Color getToolTipBackgroundColor(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipBackgroundColor(object);
        }
        return super.getToolTipBackgroundColor(object);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipDisplayDelayTime(object);
        }
        return super.getToolTipDisplayDelayTime(object);
    }

    public Font getToolTipFont(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipFont(object);
        }
        return super.getToolTipFont(object);
    }

    public Color getToolTipForegroundColor(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipForegroundColor(object);
        }
        return super.getToolTipForegroundColor(object);
    }

    public Image getToolTipImage(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipImage(object);
        }
        return super.getToolTipImage(object);
    }

    public Point getToolTipShift(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipShift(object);
        }
        return super.getToolTipShift(object);
    }

    public int getToolTipStyle(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipStyle(object);
        }
        return super.getToolTipStyle(object);
    }

    public String getToolTipText(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipText(object);
        }
        return super.getToolTipText(object);
    }

    public int getToolTipTimeDisplayed(Object object) {
        if (this.m_provider instanceof CellLabelProvider) {
            return ((CellLabelProvider)this.m_provider).getToolTipTimeDisplayed(object);
        }
        return super.getToolTipTimeDisplayed(object);
    }

    public IDecorationContext getDecorationContext() {
        return this.m_decorationContext;
    }

    public void setDecorationContext(IDecorationContext decorationContext) {
        Assert.isNotNull((Object)decorationContext);
        this.m_decorationContext = decorationContext;
    }

    public void updateLabel(ViewerLabel settings, TreePath elementPath) {
        IDelayedLabelDecorator delayedDecorator;
        ILabelDecorator currentDecorator = this.getLabelDecorator();
        String oldText = settings.getText();
        Object element = elementPath.getLastSegment();
        boolean decorationReady = true;
        if (currentDecorator instanceof LabelDecorator) {
            LabelDecorator labelDecorator = (LabelDecorator)currentDecorator;
            if (!labelDecorator.prepareDecoration(element, oldText, this.getDecorationContext())) {
                decorationReady = false;
            }
        } else if (currentDecorator instanceof IDelayedLabelDecorator && !(delayedDecorator = (IDelayedLabelDecorator)currentDecorator).prepareDecoration(element, oldText)) {
            decorationReady = false;
        }
        if (this.m_provider instanceof ITreePathLabelProvider) {
            ITreePathLabelProvider pprov = (ITreePathLabelProvider)this.m_provider;
            if (decorationReady || oldText == null || settings.getText().length() == 0) {
                pprov.updateLabel(settings, elementPath);
                this.decorateSettings(settings, elementPath);
            }
        } else {
            if (decorationReady || oldText == null || settings.getText().length() == 0) {
                settings.setText(this.getText(element));
            }
            Image oldImage = settings.getImage();
            if (decorationReady || oldImage == null) {
                settings.setImage(this.getImage(element));
            }
            if (decorationReady) {
                this.updateForDecorationReady(settings, element);
            }
        }
    }

    private void decorateSettings(ViewerLabel settings, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (this.m_decorator != null) {
            Font font;
            if (this.m_decorator instanceof LabelDecorator) {
                Image image;
                LabelDecorator labelDecorator = (LabelDecorator)this.m_decorator;
                String text = labelDecorator.decorateText(settings.getText(), element, this.getDecorationContext());
                if (text != null && text.length() > 0) {
                    settings.setText(text);
                }
                if ((image = labelDecorator.decorateImage(settings.getImage(), element, this.getDecorationContext())) != null) {
                    settings.setImage(image);
                }
            } else {
                Image image;
                String text = this.m_decorator.decorateText(settings.getText(), element);
                if (text != null && text.length() > 0) {
                    settings.setText(text);
                }
                if ((image = this.m_decorator.decorateImage(settings.getImage(), element)) != null) {
                    settings.setImage(image);
                }
            }
            if (this.m_decorator instanceof IColorDecorator) {
                Color foreground;
                IColorDecorator colorDecorator = (IColorDecorator)this.m_decorator;
                Color background = colorDecorator.decorateBackground(element);
                if (background != null) {
                    settings.setBackground(background);
                }
                if ((foreground = colorDecorator.decorateForeground(element)) != null) {
                    settings.setForeground(foreground);
                }
            }
            if (this.m_decorator instanceof IFontDecorator && (font = ((IFontDecorator)this.m_decorator).decorateFont(element)) != null) {
                settings.setFont(font);
            }
        }
    }

    public void update(ViewerCell cell) {
        ViewerLabel label = new ViewerLabel(cell.getText(), cell.getImage());
        label.setBackground(this.getBackground(cell.getElement()));
        label.setForeground(this.getForeground(cell.getElement()));
        label.setFont(this.getFont(cell.getElement()));
        this.updateLabel(label, cell.getElement());
        cell.setBackground(label.getBackground());
        cell.setForeground(label.getForeground());
        cell.setFont(label.getFont());
        if (label.hasNewText()) {
            cell.setText(label.getText());
        }
        if (label.hasNewImage()) {
            cell.setImage(label.getImage());
        }
    }
}

